/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.format;

import org.eclipse.wst.css.core.internal.format.CSSSourceFormatter;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.html.core.internal.format.HTMLFormatter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;

public class EmbeddedCSSFormatter
extends HTMLFormatter {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected EmbeddedCSSFormatter() {
    }

    protected void formatNode(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        IDOMText text = (IDOMText)node;
        String source = this.getCSSContent(node);
        if (source == null) {
            source = text.getSource();
        }
        int offset = text.getStartOffset();
        int length = text.getEndOffset() - offset;
        this.replaceSource(text.getModel(), offset, length, source);
        this.setWidth(contraints, source);
    }

    private String getCSSContent(IDOMNode text) {
        INodeAdapter adapter;
        ICSSModel model = this.getCSSModel(text);
        if (model == null) {
            return null;
        }
        ICSSDocument document = model.getDocument();
        if (document == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)document;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.css.core.internal.format.CSSSourceFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = notifier.getAdapterFor((Object)clazz)) == null) {
            return null;
        }
        CSSSourceFormatter formatter = (CSSSourceFormatter)adapter;
        StringBuffer buffer = formatter.format((ICSSNode)document);
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    private ICSSModel getCSSModel(IDOMNode text) {
        INodeAdapter adapter;
        if (text == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)text.getParentNode();
        if (notifier == null) {
            return null;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = notifier.getAdapterFor((Object)clazz)) == null) {
            return null;
        }
        if (!(adapter instanceof IStyleSheetAdapter)) {
            return null;
        }
        IStyleSheetAdapter styleAdapter = (IStyleSheetAdapter)adapter;
        return styleAdapter.getModel();
    }
}

