/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.configuration;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.format.PhpFormatProcessorImpl;
import org.eclipse.php.internal.core.util.WeakPropertyChangeListener;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.php.internal.ui.doubleclick.PHPDoubleClickStrategy;
import org.eclipse.php.internal.ui.editor.PHPCodeHyperlinkDetector;
import org.eclipse.php.internal.ui.editor.contentassist.PHPContentAssistProcessor;
import org.eclipse.php.internal.ui.editor.contentassist.PHPDocContentAssistProcessor;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPhp;
import org.eclipse.php.internal.ui.editor.hover.PHPTextHoverProxy;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.internal.ui.util.ElementCreationProxy;
import org.eclipse.php.ui.editor.hover.IHyperlinkDetectorForPHP;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.contentassist.StructuredContentAssistant;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

public class PHPStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationHTML {
    private String[] configuredContentTypes;
    private LineStyleProvider fLineStyleProvider;
    private IPropertyChangeListener propertyChangeListener;
    private ArrayList detectors = new ArrayList();
    private ArrayList processors = null;
    private StructuredContentAssistant fContentAssistant = null;
    private static IAutoEditStrategy mainAutoEditStrategy = new MainAutoEditStrategy();
    private static IAutoEditStrategy[] phpStrategies = new IAutoEditStrategy[]{mainAutoEditStrategy};

    public PHPStructuredTextViewerConfiguration() {
        this.detectors.add(new PHPCodeHyperlinkDetector());
        String string = "org.eclipse.php.ui.phpHyperlinkDetector";
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            ElementCreationProxy elementCreationProxy;
            IHyperlinkDetectorForPHP iHyperlinkDetectorForPHP;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("detector") && (iHyperlinkDetectorForPHP = (IHyperlinkDetectorForPHP)(elementCreationProxy = new ElementCreationProxy(iConfigurationElement, string)).getObject()) != null) {
                this.detectors.add(iHyperlinkDetectorForPHP);
            }
            ++n;
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer iSourceViewer) {
        if (this.configuredContentTypes == null) {
            String[] stringArray = PHPStructuredTextPartitioner.getConfiguredContentTypes();
            String[] stringArray2 = StructuredTextPartitionerForXML.getConfiguredContentTypes();
            String[] stringArray3 = StructuredTextPartitionerForHTML.getConfiguredContentTypes();
            this.configuredContentTypes = new String[2 + stringArray.length + stringArray2.length + stringArray3.length];
            this.configuredContentTypes[0] = "org.eclipse.wst.sse.ST_DEFAULT";
            this.configuredContentTypes[1] = "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
            int n = 0;
            System.arraycopy(stringArray, 0, this.configuredContentTypes, n += 2, stringArray.length);
            System.arraycopy(stringArray2, 0, this.configuredContentTypes, n += stringArray.length, stringArray2.length);
            System.arraycopy(stringArray3, 0, this.configuredContentTypes, n += stringArray2.length, stringArray3.length);
        }
        return this.configuredContentTypes;
    }

    public LineStyleProvider getLineStyleProvider() {
        if (this.fLineStyleProvider == null) {
            this.fLineStyleProvider = new LineStyleProviderForPhp();
        }
        return this.fLineStyleProvider;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer iSourceViewer, String string) {
        if (string == "org.eclipse.php.PHP_DEFAULT") {
            return new LineStyleProvider[]{this.getLineStyleProvider()};
        }
        return super.getLineStyleProviders(iSourceViewer, string);
    }

    public IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer iSourceViewer, String string) {
        IContentAssistProcessor[] iContentAssistProcessorArray = null;
        if (string == "org.eclipse.php.PHP_DEFAULT") {
            ArrayList arrayList = this.getPHPDefaultProcessors();
            iContentAssistProcessorArray = new IContentAssistProcessor[arrayList.size()];
            arrayList.toArray(iContentAssistProcessorArray);
        } else {
            iContentAssistProcessorArray = super.getContentAssistProcessors(iSourceViewer, string);
        }
        return iContentAssistProcessorArray;
    }

    private ArrayList getPHPDefaultProcessors() {
        if (this.processors != null) {
            return this.processors;
        }
        this.processors = new ArrayList();
        this.processors.add(new PHPContentAssistProcessor());
        this.processors.add(new PHPDocContentAssistProcessor());
        String string = "org.eclipse.php.ui.phpContentAssistProcessor";
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            ElementCreationProxy elementCreationProxy;
            IContentAssistProcessor iContentAssistProcessor;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("processor") && (iContentAssistProcessor = (IContentAssistProcessor)(elementCreationProxy = new ElementCreationProxy(iConfigurationElement, string)).getObject()) != null) {
                this.processors.add(iContentAssistProcessor);
            }
            ++n;
        }
        return this.processors;
    }

    protected void setupPropertyChangeListener(final ISourceViewer iSourceViewer) {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    String string = propertyChangeEvent.getProperty();
                    if ("contentAssistAutoinsert".equals(string) || "contentAssistAutoactivation".equals(string) || "contentAssistAutoactivationDelay".equals(string)) {
                        PHPStructuredTextViewerConfiguration.this.configureContentAssistant(iSourceViewer);
                    }
                }
            };
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)WeakPropertyChangeListener.create((IPropertyChangeListener)this.propertyChangeListener, (Object)PreferenceConstants.getPreferenceStore()));
        }
    }

    protected void configureContentAssistant(ISourceViewer iSourceViewer) {
        this.setupPropertyChangeListener(iSourceViewer);
        IContentAssistant iContentAssistant = this.getPHPContentAssistant(iSourceViewer);
        if (iContentAssistant instanceof StructuredContentAssistant) {
            StructuredContentAssistant structuredContentAssistant = (StructuredContentAssistant)iContentAssistant;
            structuredContentAssistant.enableAutoInsert(PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoinsert"));
            structuredContentAssistant.enableAutoActivation(PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoactivation"));
            structuredContentAssistant.setAutoActivationDelay(PreferenceConstants.getPreferenceStore().getInt("contentAssistAutoactivationDelay"));
        }
    }

    public IContentAssistant getPHPContentAssistant(ISourceViewer iSourceViewer) {
        if (this.fContentAssistant == null) {
            this.fContentAssistant = this.getPHPContentAssistantExtension();
            if (this.fContentAssistant == null) {
                this.fContentAssistant = new StructuredContentAssistant();
            }
            this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(iSourceViewer));
            this.fContentAssistant.enableAutoActivation(true);
            this.fContentAssistant.setAutoActivationDelay(500);
            this.fContentAssistant.setProposalPopupOrientation(10);
            this.fContentAssistant.setContextInformationPopupOrientation(20);
            this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(iSourceViewer));
            String[] stringArray = this.getConfiguredContentTypes(iSourceViewer);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                IContentAssistProcessor[] iContentAssistProcessorArray = this.getContentAssistProcessors(iSourceViewer, string);
                if (iContentAssistProcessorArray != null) {
                    int n2 = 0;
                    while (n2 < iContentAssistProcessorArray.length) {
                        this.fContentAssistant.setContentAssistProcessor(iContentAssistProcessorArray[n2], string);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return this.fContentAssistant;
    }

    private StructuredContentAssistant getPHPContentAssistantExtension() {
        StructuredContentAssistant structuredContentAssistant = null;
        String string = "org.eclipse.php.ui.phpContentAssistant";
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(string);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            ElementCreationProxy elementCreationProxy;
            StructuredContentAssistant structuredContentAssistant2;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("contentAssistant") && (structuredContentAssistant2 = (StructuredContentAssistant)(elementCreationProxy = new ElementCreationProxy(iConfigurationElement, string)).getObject()) != null) {
                structuredContentAssistant = structuredContentAssistant2;
            }
            ++n;
        }
        return structuredContentAssistant;
    }

    public String[] getDefaultPrefixes(ISourceViewer iSourceViewer, String string) {
        return new String[]{"//", "#", ""};
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer iSourceViewer, String string) {
        PHPEditorTextHoverDescriptor[] pHPEditorTextHoverDescriptorArray = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int[] nArray = new int[pHPEditorTextHoverDescriptorArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < pHPEditorTextHoverDescriptorArray.length) {
            if (pHPEditorTextHoverDescriptorArray[n2].isEnabled()) {
                int n3 = 0;
                int n4 = pHPEditorTextHoverDescriptorArray[n2].getStateMask();
                while (n3 < n) {
                    if (nArray[n3] == n4) break;
                    ++n3;
                }
                if (n3 == n) {
                    nArray[n++] = n4;
                }
            }
            ++n2;
        }
        if (n == pHPEditorTextHoverDescriptorArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string, int n) {
        if (!PHPStructuredTextPartitioner.isPHPPartitionType((String)string)) {
            return super.getTextHover(iSourceViewer, string, n);
        }
        PHPEditorTextHoverDescriptor[] pHPEditorTextHoverDescriptorArray = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int n2 = 0;
        while (n2 < pHPEditorTextHoverDescriptorArray.length) {
            if (pHPEditorTextHoverDescriptorArray[n2].isEnabled() && pHPEditorTextHoverDescriptorArray[n2].getStateMask() == n) {
                return new PHPTextHoverProxy(pHPEditorTextHoverDescriptorArray[n2], null);
            }
            ++n2;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer iSourceViewer, String string) {
        return this.getTextHover(iSourceViewer, string, 255);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer iSourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray = super.getHyperlinkDetectors(iSourceViewer);
        int n = iHyperlinkDetectorArray != null ? iHyperlinkDetectorArray.length : 0;
        IHyperlinkDetector[] iHyperlinkDetectorArray2 = new IHyperlinkDetector[n + this.detectors.size()];
        this.detectors.toArray(iHyperlinkDetectorArray2);
        System.arraycopy(iHyperlinkDetectorArray, 0, iHyperlinkDetectorArray2, this.detectors.size(), n);
        return iHyperlinkDetectorArray2;
    }

    public IContentFormatter getContentFormatter(ISourceViewer iSourceViewer) {
        MultiPassContentFormatter multiPassContentFormatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(iSourceViewer), "org.eclipse.wst.html.HTML_DEFAULT");
        multiPassContentFormatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new PhpFormatProcessorImpl()));
        return multiPassContentFormatter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer iSourceViewer, String string) {
        if (string.equals("org.eclipse.php.PHP_DEFAULT")) {
            return phpStrategies;
        }
        return super.getAutoEditStrategies(iSourceViewer, string);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer iSourceViewer, String string) {
        if (string == "org.eclipse.php.PHP_DEFAULT") {
            return new PHPDoubleClickStrategy();
        }
        return super.getDoubleClickStrategy(iSourceViewer, string);
    }
}

