/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTrackerExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.debug.core.launching.HyperlinkEntry;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.ui.console.IHyperlink;

public class PHPLineTracker
implements IConsoleLineTrackerExtension {
    private IConsole fConsole;
    private PHPHyperLink fPHPHyperLink;

    public void init(IConsole iConsole) {
        this.fConsole = iConsole;
        this.fPHPHyperLink = ((PHPProcess)this.fConsole.getProcess()).getPHPHyperLink();
    }

    public void lineAppended(IRegion iRegion) {
        IHyperlink iHyperlink;
        String string = "";
        try {
            string = this.fConsole.getDocument().get(iRegion.getOffset(), iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            Logger.logException("PHPLineTracker error getting message", badLocationException);
            return;
        }
        HyperlinkEntry hyperlinkEntry = this.fPHPHyperLink.getHyperlinkEntry(string);
        if (hyperlinkEntry != null && (iHyperlink = hyperlinkEntry.getLink()) != null) {
            this.fConsole.addLink(iHyperlink, iRegion.getOffset(), hyperlinkEntry.getHyperLength());
        }
    }

    public void dispose() {
        this.fConsole = null;
        this.fPHPHyperLink = null;
    }

    public void consoleClosed() {
        this.fPHPHyperLink.dispose();
    }
}

