/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.server.ui.internal.viewers.ILockedLabelProvider;

public class LockedTableViewer
extends TableViewer {
    protected Color color;

    public LockedTableViewer(Composite parent) {
        super(parent);
        this.createColor((Control)parent);
    }

    public LockedTableViewer(Composite parent, int style) {
        super(parent, style);
        this.createColor((Control)parent);
    }

    public LockedTableViewer(Table table) {
        super(table);
        this.createColor((Control)table);
    }

    protected void createColor(Control c) {
        this.color = new Color((Device)c.getDisplay(), 255, 255, 225);
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LockedTableViewer.this.color.dispose();
            }
        });
    }

    public void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (this.color == null) {
            return;
        }
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            if (this.getLabelProvider() instanceof ILockedLabelProvider) {
                ILockedLabelProvider provider = (ILockedLabelProvider)this.getLabelProvider();
                if (provider.isLocked(element)) {
                    item.setBackground(this.color);
                    item.setImage(0, null);
                } else {
                    item.setBackground(null);
                }
            }
        }
        super.doUpdateItem(widget, element, fullMap);
    }
}

