/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.collections;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class BucketMap {
    private Map map;
    private Set setDefault = new HashSet(1);

    public BucketMap() {
        this.map = new HashMap();
    }

    public BucketMap(Set set) {
        this();
        this.setDefault = set;
    }

    public BucketMap(int n) {
        this.map = new HashMap(n);
    }

    public void add(Object object, Object object2) {
        Set set = (Set)this.map.get(object);
        if (set == null) {
            set = this.createSet();
            this.map.put(object, set);
        }
        set.add(object2);
    }

    private Set createSet() {
        if (this.setDefault instanceof Cloneable) {
            try {
                Method method = this.setDefault.getClass().getMethod("clone", null);
                return (Set)method.invoke((Object)this.setDefault, new Object[0]);
            }
            catch (Exception exception) {}
        }
        try {
            return (Set)this.setDefault.getClass().newInstance();
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
            return new HashSet();
        }
    }

    public void addAll(Object object, Collection collection) {
        Set set = (Set)this.map.get(object);
        if (set == null) {
            set = this.createSet();
            this.map.put(object, set);
        }
        set.addAll(collection);
    }

    public void merge(BucketMap bucketMap) {
        Iterator iterator = bucketMap.getKeys().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.addAll(e, bucketMap.getSet(e));
        }
    }

    public boolean contains(Object object, Object object2) {
        Set set = (Set)this.map.get(object);
        if (set == null) {
            return false;
        }
        return set.contains(object2);
    }

    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public Set get(Object object) {
        Set set = this.getSet(object);
        if (set == null) {
            return new HashSet(0);
        }
        return set;
    }

    public Set getSet(Object object) {
        return (Set)this.map.get(object);
    }

    public Set getAll() {
        Set set = this.createSet();
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Set set2 = (Set)iterator.next();
            Iterator iterator2 = set2.iterator();
            while (iterator2.hasNext()) {
                set.add(iterator2.next());
            }
        }
        return set;
    }

    public boolean remove(Object object, Object object2) {
        Set set = (Set)this.map.get(object);
        if (set == null) {
            return false;
        }
        boolean bl = set.remove(object2);
        if (set.size() == 0) {
            this.map.remove(object);
        }
        return bl;
    }

    public Object[] removeAll(Object object) {
        Set set = (Set)this.map.remove(object);
        if (set != null) {
            return set.toArray();
        }
        return new Object[0];
    }

    public void clear() {
        this.map.clear();
    }

    public Set getKeys() {
        return this.map.keySet();
    }
}

