/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.php.internal.core.util.collections.IntMap;

public class IntHashtable
implements IntMap,
Cloneable,
Serializable {
    static final long serialVersionUID = -3094290553755493591L;
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static EmptyEnumerator emptyEnumerator = new EmptyEnumerator();
    private static EmptyIterator emptyIterator = new EmptyIterator();

    public IntHashtable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public IntHashtable(int n) {
        this(n, 0.75f);
    }

    public IntHashtable() {
        this(11, 0.75f);
    }

    public IntHashtable(IntMap intMap) {
        this(Math.max(2 * intMap.size(), 11), 0.75f);
        this.putAll(intMap);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration elements() {
        return this.getEnumeration(1);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public synchronized boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public synchronized Object get(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    protected void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public synchronized Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && entry.key == n) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n3] = entry = new Entry(n2, n, object, entryArray[n3]);
        ++this.count;
        return null;
    }

    public synchronized Object remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n3];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n2 && entry.key == n) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n3] = entry.next;
                }
                --this.count;
                Object object = entry.value;
                entry.value = null;
                return object;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void putAll(IntMap intMap) {
        Iterator iterator = intMap.entrySet().iterator();
        while (iterator.hasNext()) {
            IntMap.Entry entry = (IntMap.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            IntHashtable intHashtable = (IntHashtable)super.clone();
            intHashtable.table = new Entry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                Entry entry = intHashtable.table[n] = this.table[n] != null ? (Entry)this.table[n].clone() : null;
            }
            intHashtable.entrySet = null;
            intHashtable.values = null;
            intHashtable.modCount = 0;
            return intHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.entrySet().iterator();
        stringBuffer.append("{");
        int n2 = 0;
        while (n2 <= n) {
            Map.Entry entry = (Map.Entry)iterator.next();
            stringBuffer.append(entry.getKey() + "=" + entry.getValue());
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private Enumeration getEnumeration(int n) {
        if (this.count == 0) {
            return emptyEnumerator;
        }
        return new Enumerator(n, false);
    }

    private Iterator getIterator(int n) {
        if (this.count == 0) {
            return emptyIterator;
        }
        return new Enumerator(n, true);
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.synchronizedSet(new EntrySet());
        }
        return this.entrySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = Collections.synchronizedCollection(new ValueCollection());
        }
        return this.values;
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntMap)) {
            return false;
        }
        IntMap intMap = (IntMap)object;
        if (intMap.size() != this.size()) {
            return false;
        }
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            IntMap.Entry entry = (IntMap.Entry)iterator.next();
            int n = entry.getKey();
            Object object2 = entry.getValue();
            if (!(object2 == null ? intMap.get(n) != null || !intMap.containsKey(n) : !object2.equals(intMap.get(n)))) continue;
            return false;
        }
        return true;
    }

    public synchronized int hashCode() {
        int n = 0;
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        int n = this.table.length - 1;
        while (n >= 0) {
            Entry entry = this.table[n];
            while (entry != null) {
                objectOutputStream.write(entry.key);
                objectOutputStream.writeObject(entry.value);
                entry = entry.next;
            }
            --n;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new Entry[n3];
        this.count = 0;
        while (n2 > 0) {
            int n4 = objectInputStream.readInt();
            Object object = objectInputStream.readObject();
            this.put(n4, object);
            --n2;
        }
    }

    private static class EmptyEnumerator
    implements Enumeration {
        EmptyEnumerator() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("Hashtable Enumerator");
        }
    }

    private static class EmptyIterator
    implements Iterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException("Hashtable Iterator");
        }

        public void remove() {
            throw new IllegalStateException("Hashtable Iterator");
        }
    }

    private static class Entry
    implements IntMap.Entry {
        int hash;
        int key;
        Object value;
        Entry next;

        protected Entry(int n, int n2, Object object, Entry entry) {
            this.hash = n;
            this.key = n2;
            this.value = object;
            this.next = entry;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IntMap.Entry)) {
                return false;
            }
            IntMap.Entry entry = (IntMap.Entry)object;
            return (this.key == 0 ? entry.getKey() == 0 : this.key == entry.getKey()) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value.toString();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return IntHashtable.this.getIterator(2);
        }

        public boolean contains(Object object) {
            if (!(object instanceof IntMap.Entry)) {
                return false;
            }
            IntMap.Entry entry = (IntMap.Entry)object;
            int n = entry.getKey();
            Entry[] entryArray = IntHashtable.this.table;
            int n2 = n;
            int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n3];
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.equals(entry)) {
                    return true;
                }
                entry2 = entry2.next;
            }
            return false;
        }

        public boolean remove(Object object) {
            if (!(object instanceof IntMap.Entry)) {
                return false;
            }
            IntMap.Entry entry = (IntMap.Entry)object;
            int n = entry.getKey();
            Entry[] entryArray = IntHashtable.this.table;
            int n2 = n;
            int n3 = (n2 & Integer.MAX_VALUE) % entryArray.length;
            Entry entry2 = entryArray[n3];
            Entry entry3 = null;
            while (entry2 != null) {
                if (entry2.hash == n2 && entry2.equals(entry)) {
                    IntHashtable intHashtable = IntHashtable.this;
                    intHashtable.modCount = intHashtable.modCount + 1;
                    if (entry3 != null) {
                        entry3.next = entry2.next;
                    } else {
                        entryArray[n3] = entry2.next;
                    }
                    IntHashtable intHashtable2 = IntHashtable.this;
                    intHashtable2.count = intHashtable2.count - 1;
                    entry2.value = null;
                    return true;
                }
                entry3 = entry2;
                entry2 = entry2.next;
            }
            return false;
        }

        public int size() {
            return IntHashtable.this.count;
        }

        public void clear() {
            IntHashtable.this.clear();
        }
    }

    private class Enumerator
    implements Enumeration,
    Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;

        Enumerator(int n, boolean bl) {
            this.table = IntHashtable.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = IntHashtable.this.modCount;
            this.type = n;
            this.iterator = bl;
        }

        public boolean hasMoreElements() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            return entry != null;
        }

        public Object nextElement() {
            Entry entry = this.entry;
            int n = this.index;
            Entry[] entryArray = this.table;
            while (entry == null && n > 0) {
                entry = entryArray[--n];
            }
            this.entry = entry;
            this.index = n;
            if (entry != null) {
                Entry entry2 = this.lastReturned = this.entry;
                this.entry = entry2.next;
                return this.type == 1 ? entry2.value : entry2;
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            if (IntHashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (IntHashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            IntHashtable intHashtable = IntHashtable.this;
            synchronized (intHashtable) {
                Entry[] entryArray = IntHashtable.this.table;
                int n = (this.lastReturned.hash & Integer.MAX_VALUE) % entryArray.length;
                Entry entry = entryArray[n];
                Entry entry2 = null;
                while (entry != null) {
                    if (entry == this.lastReturned) {
                        IntHashtable intHashtable2 = IntHashtable.this;
                        intHashtable2.modCount = intHashtable2.modCount + 1;
                        ++this.expectedModCount;
                        if (entry2 == null) {
                            entryArray[n] = entry.next;
                        } else {
                            entry2.next = entry.next;
                        }
                        IntHashtable intHashtable3 = IntHashtable.this;
                        intHashtable3.count = intHashtable3.count - 1;
                        this.lastReturned = null;
                        return;
                    }
                    entry2 = entry;
                    entry = entry.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        public Iterator iterator() {
            return IntHashtable.this.getIterator(1);
        }

        public int size() {
            return IntHashtable.this.count;
        }

        public boolean contains(Object object) {
            return IntHashtable.this.containsValue(object);
        }

        public void clear() {
            IntHashtable.this.clear();
        }
    }
}

