/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.MultiLaunchGroupFilter;
import org.eclipse.debug.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class LaunchConfigurationsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEBUG_LAUNCH_GROUP = "org.eclipse.debug.ui.launchGroup.debug";
    private static final String EXT_BUILDER_GROUP = "org.eclipse.ui.externaltools.launchGroup";
    private ProgressMonitorPart fMonitor;
    private Button fMigrateNow;
    private List fFieldEditors;
    private Table fTable;

    public LaunchConfigurationsPreferencePage() {
        this.setPreferenceStore(DebugUIPlugin.getDefault().getPreferenceStore());
        this.setTitle(DebugPreferencesMessages.LaunchConfigurationsPreferencePage_1);
    }

    private Composite createComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IDebugHelpContextIds.LAUNCH_CONFIGURATION_PREFERENCE_PAGE);
    }

    protected Control createContents(Composite parent) {
        this.fFieldEditors = new ArrayList();
        Composite comp = this.createComposite(parent);
        Group group = this.createGroupComposite(comp, DebugPreferencesMessages.LaunchingPreferencePage_32);
        Composite spacer = this.createComposite((Composite)group);
        BooleanFieldEditor edit = new BooleanFieldEditor(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_CLOSED, DebugPreferencesMessages.LaunchingPreferencePage_33, 0, spacer);
        this.fFieldEditors.add(edit);
        edit = new BooleanFieldEditor(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_DELETED, DebugPreferencesMessages.LaunchingPreferencePage_34, 0, spacer);
        this.fFieldEditors.add(edit);
        edit = new BooleanFieldEditor(IInternalDebugUIConstants.PREF_FILTER_WORKING_SETS, DebugPreferencesMessages.LaunchConfigurationsPreferencePage_3, 0, spacer);
        this.fFieldEditors.add(edit);
        edit = new RadioGroupFieldEditor(IInternalDebugUIConstants.PREF_DELETE_CONFIGS_ON_PROJECT_DELETE, DebugPreferencesMessages.LaunchConfigurationsPreferencePage_2, 3, (String[][])new String[][]{{DebugPreferencesMessages.LaunchingPreferencePage_3, "always"}, {DebugPreferencesMessages.LaunchingPreferencePage_4, "never"}, {DebugPreferencesMessages.LaunchingPreferencePage_5, "prompt"}}, comp, true);
        this.fFieldEditors.add(edit);
        this.createTypeFiltering((Composite)group);
        group = this.createGroupComposite(comp, DebugPreferencesMessages.LaunchingPreferencePage_35);
        Label label = new Label((Composite)group, 16448);
        GridData gd = new GridData(768);
        gd.widthHint = 350;
        label.setLayoutData((Object)gd);
        label.setText(DebugPreferencesMessages.LaunchingPreferencePage_26);
        label.setFont(parent.getFont());
        this.fMigrateNow = SWTUtil.createPushButton((Composite)group, DebugPreferencesMessages.LaunchingPreferencePage_27, null);
        gd = new GridData(1);
        this.fMigrateNow.setLayoutData((Object)gd);
        this.fMigrateNow.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationsPreferencePage.this.handleMigrateNowSelected();
            }
        });
        this.initFieldEditors();
        this.fTable.setEnabled(this.getPreferenceStore().getBoolean(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_TYPES));
        return comp;
    }

    private Composite createTypeFiltering(Composite parent) {
        Composite comp = this.createComposite(parent);
        BooleanFieldEditor2 editor = new BooleanFieldEditor2(IInternalDebugUIConstants.PREF_FILTER_LAUNCH_TYPES, DebugPreferencesMessages.LaunchConfigurationsPreferencePage_0, 0, comp);
        editor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                boolean newvalue = false;
                newvalue = event.getNewValue() instanceof Boolean ? ((Boolean)event.getNewValue()).booleanValue() : Boolean.valueOf(event.getNewValue().toString()).booleanValue();
                if (newvalue) {
                    LaunchConfigurationsPreferencePage.this.fTable.setEnabled(true);
                } else {
                    LaunchConfigurationsPreferencePage.this.fTable.setEnabled(false);
                }
            }
        });
        this.fFieldEditors.add(editor);
        this.fTable = new Table(comp, 2080);
        GridData gd = new GridData(768);
        gd.heightHint = 155;
        this.fTable.setLayoutData((Object)gd);
        CheckboxTableViewer tviewer = new CheckboxTableViewer(this.fTable);
        tviewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        tviewer.setContentProvider((IContentProvider)new TableContentProvider());
        tviewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        LaunchGroupExtension[] groups = new LaunchGroupExtension[]{DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(DEBUG_LAUNCH_GROUP), DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(EXT_BUILDER_GROUP)};
        tviewer.addFilter((ViewerFilter)new MultiLaunchGroupFilter(groups));
        tviewer.setInput((Object)this.getLaunchConfigurationTypes());
        this.fTable.setFont(parent.getFont());
        return comp;
    }

    private Group createGroupComposite(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(768);
        gd.horizontalIndent = 0;
        gd.verticalIndent = 0;
        group.setLayoutData((Object)gd);
        group.setText(text);
        group.setFont(parent.getFont());
        return group;
    }

    private ILaunchConfigurationType[] getLaunchConfigurationTypes() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
    }

    private void handleMigrateNowSelected() {
        try {
            ILaunchManager lmanager = DebugPlugin.getDefault().getLaunchManager();
            Object[] configurations = lmanager.getMigrationCandidates();
            if (configurations.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)DebugPreferencesMessages.LaunchingPreferencePage_29, (String)DebugPreferencesMessages.LaunchingPreferencePage_30);
                return;
            }
            LaunchConfigurationMigrationSelectionDialog listd = new LaunchConfigurationMigrationSelectionDialog(this.getShell(), new AdaptableList((IAdaptable[])configurations), (IStructuredContentProvider)new WorkbenchContentProvider(), DebugUITools.newDebugModelPresentation(), DebugPreferencesMessages.LaunchingPreferencePage_0);
            listd.setTitle(DebugPreferencesMessages.LaunchingPreferencePage_28);
            listd.setInitialSelections(configurations);
            if (listd.open() == 0) {
                this.fMonitor = new ProgressMonitorPart(this.fMigrateNow.getParent(), (Layout)new GridLayout());
                Object[] objs = listd.getResult();
                this.fMonitor.beginTask(DebugPreferencesMessages.LaunchingPreferencePage_31, objs.length);
                int i = 0;
                while (i < objs.length) {
                    if (objs[i] instanceof ILaunchConfiguration) {
                        ((ILaunchConfiguration)objs[i]).migrate();
                    }
                    this.fMonitor.worked(i);
                    ++i;
                }
                this.fMonitor.done();
                this.fMonitor.dispose();
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void initFieldEditors() {
        int i = 0;
        while (i < this.fFieldEditors.size()) {
            FieldEditor editor = (FieldEditor)this.fFieldEditors.get(i);
            editor.setPreferenceStore(this.getPreferenceStore());
            editor.load();
            ++i;
        }
        String[] types = this.getPreferenceStore().getString(IInternalDebugUIConstants.PREF_FILTER_TYPE_LIST).split("\\,");
        TableItem[] items = this.fTable.getItems();
        int i2 = 0;
        while (i2 < types.length) {
            int j = 0;
            while (j < items.length) {
                ILaunchConfigurationType type = (ILaunchConfigurationType)items[j].getData();
                if (type.getIdentifier().equals(types[i2])) {
                    items[j].setChecked(true);
                }
                ++j;
            }
            ++i2;
        }
    }

    protected void performDefaults() {
        FieldEditor editor = null;
        int i = 0;
        while (i < this.fFieldEditors.size()) {
            editor = (FieldEditor)this.fFieldEditors.get(i);
            editor.loadDefault();
            if (editor instanceof BooleanFieldEditor2) {
                this.fTable.setEnabled(((BooleanFieldEditor2)editor).getBooleanValue());
            }
            ++i;
        }
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.fFieldEditors.size()) {
            ((FieldEditor)this.fFieldEditors.get(i)).store();
            ++i;
        }
        String types = "";
        TableItem[] items = this.fTable.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2].getChecked()) {
                ILaunchConfigurationType type = (ILaunchConfigurationType)items[i2].getData();
                types = String.valueOf(types) + type.getIdentifier() + ",";
            }
            ++i2;
        }
        this.getPreferenceStore().setValue(IInternalDebugUIConstants.PREF_FILTER_TYPE_LIST, types);
        return super.performOk();
    }

    class LaunchConfigurationMigrationSelectionDialog
    extends ListSelectionDialog {
        private String SETTINGS_ID = String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MIGRATION_SELECTION_DIALOG";

        public LaunchConfigurationMigrationSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
            super(parentShell, input, contentProvider, labelProvider, message);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected IDialogSettings getDialogBoundsSettings() {
            IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(this.SETTINGS_ID);
            if (section == null) {
                section = settings.addNewSection(this.SETTINGS_ID);
            }
            return section;
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return LaunchConfigurationsPreferencePage.this.getLaunchConfigurationTypes();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

