/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTagData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPProjectModelVisitor;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;

public class PHPModelUtil {
    public static PHPCodeData getElementAt(PHPCodeData pHPCodeData, int n) {
        throw new RuntimeException("test me");
    }

    public static Object getExternalResource(Object object, IProject iProject) {
        if (!(object instanceof PHPCodeData)) {
            return null;
        }
        PHPCodeData pHPCodeData = (PHPCodeData)object;
        PHPFileData pHPFileData = PHPModelUtil.getPHPFileContainer(pHPCodeData);
        if (pHPFileData == null) {
            return null;
        }
        String string = pHPFileData.getName();
        File file = new File(string);
        if (file != null && file.exists()) {
            return file;
        }
        PHPProjectModel pHPProjectModel = null;
        if (iProject == null) {
            string = pHPFileData.getName();
            PHPProjectModel[] pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
            int n = 0;
            while (n < pHPProjectModelArray.length) {
                if (pHPProjectModelArray[n].getFileData(string) == pHPFileData) {
                    pHPProjectModel = pHPProjectModelArray[n];
                    break;
                }
                ++n;
            }
        } else {
            pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        }
        if (pHPProjectModel == null) {
            return null;
        }
        return pHPProjectModel.getExternalResource(pHPFileData);
    }

    public static CodeData[] getMatchingClasses(IPhpModel iPhpModel, String string) {
        return iPhpModel.getClass(string.toLowerCase());
    }

    public static PHPCodeData[] getMatchingElements(IPhpModel iPhpModel, String string) {
        PHPFunctionData[] pHPFunctionDataArray;
        int n;
        CodeData[] codeDataArray = PHPModelUtil.getMatchingClasses(iPhpModel, string);
        int n2 = codeDataArray.length;
        if (n2 + (n = (pHPFunctionDataArray = PHPModelUtil.getMatchingFunctions(iPhpModel, string)).length) == 0) {
            return new PHPCodeData[0];
        }
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>(n2 + n);
        if (n2 > 0) {
            arrayList.addAll(Arrays.asList(codeDataArray));
        }
        if (n > 0) {
            arrayList.addAll(Arrays.asList(pHPFunctionDataArray));
        }
        return arrayList.toArray(new PHPCodeData[0]);
    }

    public static PHPFunctionData[] getMatchingFunctions(IPhpModel iPhpModel, String string) {
        CodeData[] codeDataArray = iPhpModel.getFunctions(string);
        ArrayList<PHPFunctionData> arrayList = new ArrayList<PHPFunctionData>(1);
        int n = 0;
        while (n < codeDataArray.length) {
            PHPFunctionData pHPFunctionData = (PHPFunctionData)codeDataArray[n];
            if (string.equalsIgnoreCase(pHPFunctionData.getName())) {
                arrayList.add(pHPFunctionData);
            }
            ++n;
        }
        return arrayList.toArray(new PHPFunctionData[0]);
    }

    public static int getModifier(PHPCodeData pHPCodeData) {
        if (pHPCodeData instanceof PHPClassData) {
            PHPClassData pHPClassData = (PHPClassData)pHPCodeData;
            return pHPClassData.getModifiers();
        }
        if (pHPCodeData instanceof PHPFunctionData) {
            PHPFunctionData pHPFunctionData = (PHPFunctionData)pHPCodeData;
            return pHPFunctionData.getModifiers();
        }
        if (pHPCodeData instanceof PHPClassVarData) {
            PHPClassVarData pHPClassVarData = (PHPClassVarData)pHPCodeData;
            return pHPClassVarData.getModifiers();
        }
        return 0;
    }

    public static Object getParent(Object object) {
        if (object instanceof IResource) {
            if (object instanceof IProject) {
                return PHPWorkspaceModelManager.getInstance();
            }
            IContainer iContainer = ((IResource)object).getParent();
            boolean cfr_ignored_0 = iContainer instanceof IProject;
            return iContainer;
        }
        if (object instanceof PHPCodeData) {
            PHPCodeData pHPCodeData = ((PHPCodeData)object).getContainer();
            if (pHPCodeData == null && object instanceof PHPFileData) {
                IResource iResource = PHPModelUtil.getResource(object);
                if (iResource == null) {
                    return pHPCodeData;
                }
                IContainer iContainer = iResource.getParent();
                if (iContainer.exists()) {
                    return iContainer;
                }
            }
            return pHPCodeData;
        }
        if (object instanceof PHPProjectModel) {
            return PHPWorkspaceModelManager.getInstance();
        }
        return null;
    }

    public static PHPFileData getPHPFile(IFile iFile) {
        PHPFileData pHPFileData;
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iFile.getProject());
        if (pHPProjectModel != null && (pHPFileData = pHPProjectModel.getFileData(iFile.getFullPath().toString())) != null) {
            return pHPFileData;
        }
        return null;
    }

    public static PHPFileData getPHPFileContainer(PHPCodeData pHPCodeData) {
        UserData userData;
        if (pHPCodeData instanceof PHPFileData) {
            return (PHPFileData)pHPCodeData;
        }
        PHPCodeData pHPCodeData2 = pHPCodeData.getContainer();
        while (pHPCodeData2 != null && !(pHPCodeData2 instanceof PHPFileData)) {
            pHPCodeData2 = pHPCodeData2.getContainer();
        }
        if (pHPCodeData2 == null && (userData = pHPCodeData.getUserData()) != null) {
            Path path = new Path(userData.getFileName());
            pHPCodeData2 = PHPWorkspaceModelManager.getInstance().getModelForFile(path.toString());
        }
        return (PHPFileData)pHPCodeData2;
    }

    public static IContainer getPHPFolderRoot(PHPCodeData pHPCodeData) {
        IResource iResource = PHPModelUtil.getResource(pHPCodeData);
        return iResource != null ? iResource.getProject() : null;
    }

    public static IResource getResource(Object object) {
        if (object instanceof PHPCodeData) {
            Object object2;
            PHPFileData pHPFileData = null;
            if (!(object instanceof PHPFileData)) {
                pHPFileData = PHPModelUtil.getPHPFileContainer((PHPCodeData)object);
            }
            PHPFileData pHPFileData2 = pHPFileData;
            String string = null;
            PHPCodeData pHPCodeData = (PHPCodeData)object;
            if (pHPFileData2 != null) {
                string = pHPFileData2.getName();
            } else if (pHPCodeData.isUserCode()) {
                pHPCodeData.getContainer();
                object2 = pHPCodeData.getUserData();
                string = object2.getFileName();
            } else {
                return null;
            }
            object2 = new Path(string);
            if (object2.segmentCount() < 2) {
                return null;
            }
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)object2);
            if (iResource == null && ExternalFilesRegistry.getInstance().isEntryExist(string)) {
                iResource = ExternalFilesRegistry.getInstance().getFileEntry(string);
            }
            return iResource;
        }
        if (object instanceof PHPProjectModel) {
            PHPProjectModel pHPProjectModel = (PHPProjectModel)object;
            IProject iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel(pHPProjectModel);
            return iProject;
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        return null;
    }

    public static PHPClassData getSuperClass(PHPClassData pHPClassData) {
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData == null) {
            return null;
        }
        String string = pHPSuperClassNameData.getName();
        if (string == null) {
            return null;
        }
        PHPFileData pHPFileData = PHPModelUtil.getPHPFileContainer(pHPClassData);
        String string2 = null;
        if (pHPFileData != null) {
            string2 = pHPFileData.getName();
        }
        if (string2.equals("")) {
            string2 = null;
        }
        PHPClassData pHPClassData2 = null;
        PHPProjectModel pHPProjectModel = null;
        IProject iProject = null;
        IResource iResource = PHPModelUtil.getResource(pHPClassData);
        if (iResource != null) {
            iProject = iResource.getProject();
            pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
            if (pHPProjectModel != null && (pHPClassData2 = pHPProjectModel.getClass(iResource.getName(), string)) != null) {
                return pHPClassData2;
            }
        }
        PHPProjectModel[] pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
        int n = 0;
        while (n < pHPProjectModelArray.length) {
            if (pHPProjectModelArray[n].getFileData(string2) == pHPFileData && (pHPClassData2 = pHPProjectModelArray[n].getClass(string2, string)) != null) {
                return pHPClassData2;
            }
            ++n;
        }
        n = 0;
        while (n < pHPProjectModelArray.length) {
            pHPClassData2 = pHPProjectModelArray[n].getClass(string2, string);
            if (pHPClassData2 != null) {
                return pHPClassData2;
            }
            ++n;
        }
        return null;
    }

    public static PHPClassData[] getInterfaces(PHPClassData pHPClassData) {
        PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray = pHPClassData.getInterfacesNamesData();
        int n = pHPInterfaceNameDataArray.length;
        ArrayList<PHPClassData> arrayList = new ArrayList<PHPClassData>();
        int n2 = 0;
        while (n2 < n) {
            String string;
            if (pHPInterfaceNameDataArray[n2] != null && (string = pHPInterfaceNameDataArray[n2].getName()) != null) {
                PHPFileData pHPFileData = PHPModelUtil.getPHPFileContainer(pHPClassData);
                String string2 = null;
                if (pHPFileData != null) {
                    string2 = pHPFileData.getName();
                }
                if (string2.equals("")) {
                    string2 = null;
                }
                PHPClassData pHPClassData2 = null;
                PHPProjectModel pHPProjectModel = null;
                IProject iProject = null;
                IResource iResource = PHPModelUtil.getResource(pHPClassData);
                if (iResource != null) {
                    iProject = iResource.getProject();
                    pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
                    if (pHPProjectModel != null && (pHPClassData2 = pHPProjectModel.getClass(iResource.getName(), string)) != null) {
                        arrayList.add(pHPClassData2);
                    }
                } else {
                    PHPProjectModel[] pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < pHPProjectModelArray.length) {
                        if (pHPProjectModelArray[n3].getFileData(string2) == pHPFileData && (pHPClassData2 = pHPProjectModelArray[n3].getClass(string2, string)) != null) {
                            arrayList.add(pHPClassData2);
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        n3 = 0;
                        while (n3 < pHPProjectModelArray.length) {
                            pHPClassData2 = pHPProjectModelArray[n3].getClass(string2, string);
                            if (pHPClassData2 != null) {
                                arrayList.add(pHPClassData2);
                            }
                            ++n3;
                        }
                    }
                }
            }
            ++n2;
        }
        PHPClassData[] pHPClassDataArray = new PHPClassData[arrayList.size()];
        arrayList.toArray(pHPClassDataArray);
        return pHPClassDataArray;
    }

    public static PHPProjectModel getProjectModelForFile(PHPFileData pHPFileData) {
        PHPProjectModel pHPProjectModel = null;
        IProject iProject = (IProject)PHPModelUtil.getPHPFolderRoot(pHPFileData);
        if (iProject != null) {
            pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        }
        if (pHPProjectModel == null) {
            PHPProjectModel[] pHPProjectModelArray = PHPWorkspaceModelManager.getInstance().listModels();
            int n = 0;
            while (n < pHPProjectModelArray.length) {
                if (pHPProjectModelArray[n].getFileData(pHPFileData.getName()) == pHPFileData) {
                    pHPProjectModel = pHPProjectModelArray[n];
                    break;
                }
                ++n;
            }
        }
        return pHPProjectModel;
    }

    public static boolean hasChildren(PHPCodeData pHPCodeData) {
        if (pHPCodeData instanceof PHPFunctionData) {
            return false;
        }
        if (pHPCodeData instanceof PHPClassData) {
            PHPClassData pHPClassData = (PHPClassData)pHPCodeData;
            return pHPClassData.getFunctions().length > 0 || pHPClassData.getVars().length > 0 || pHPClassData.getConsts().length > 0;
        }
        return !(pHPCodeData instanceof PHPVariableData) && !(pHPCodeData instanceof PHPKeywordData) && !(pHPCodeData instanceof PHPConstantData) && !(pHPCodeData instanceof PHPClassConstData) && !(pHPCodeData instanceof PHPIncludeFileData);
    }

    public static boolean hasPhpExtention(IFile iFile) {
        IContentType iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        String[] stringArray = iContentType.getFileSpecs(8);
        String string = iFile.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (string2.equals(stringArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasSuperClass(PHPClassData pHPClassData, PHPClassData pHPClassData2) {
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData == null) {
            return false;
        }
        String string = pHPSuperClassNameData.getName();
        if (string == null) {
            return false;
        }
        PHPClassData pHPClassData3 = pHPClassData;
        while ((pHPClassData3 = PHPModelUtil.getSuperClass(pHPClassData3)) != null) {
            if (pHPClassData3 != pHPClassData2) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSuperClass(PHPClassData pHPClassData, String string) {
        return PHPModelUtil.discoverSuperClass(pHPClassData, string) != null || string.equalsIgnoreCase(PHPModelUtil.getSuperClassName(pHPClassData));
    }

    public static String getSuperClassName(PHPClassData pHPClassData) {
        PHPClassData.PHPSuperClassNameData pHPSuperClassNameData = pHPClassData.getSuperClassData();
        if (pHPSuperClassNameData != null) {
            return pHPSuperClassNameData.getName();
        }
        return null;
    }

    public static PHPClassData discoverSuperClass(PHPClassData pHPClassData, String string) {
        String string2 = PHPModelUtil.getSuperClassName(pHPClassData);
        if (string2 == null) {
            return null;
        }
        PHPClassData pHPClassData2 = pHPClassData;
        while ((pHPClassData2 = PHPModelUtil.getSuperClass(pHPClassData2)) != null) {
            string2 = pHPClassData2.getName();
            if (string2 == null) {
                return null;
            }
            if (string2.compareToIgnoreCase(string) != 0) continue;
            return pHPClassData2;
        }
        return null;
    }

    public static PHPClassData discoverInterface(PHPClassData pHPClassData, String string) {
        PHPClassData[] pHPClassDataArray = PHPModelUtil.getInterfaces(pHPClassData);
        int n = 0;
        while (n < pHPClassDataArray.length) {
            if (pHPClassDataArray[n].getName() != null && pHPClassDataArray[n].getName().equalsIgnoreCase(string)) {
                return pHPClassDataArray[n];
            }
            ++n;
        }
        return null;
    }

    public static boolean isExternal(Object object) {
        return false;
    }

    public static boolean isPhpFile(IFile iFile) {
        IContentDescription iContentDescription = null;
        if (iFile.exists()) {
            try {
                iContentDescription = iFile.getContentDescription();
            }
            catch (CoreException coreException) {
                PHPCorePlugin.log(coreException);
                return false;
            }
            if (iContentDescription == null) {
                if (PHPModelUtil.hasPhpExtention(iFile)) {
                    PHPCorePlugin.logErrorMessage("content description null!");
                }
                return false;
            }
            return ContentTypeIdForPHP.ContentTypeID_PHP.equals(iContentDescription.getContentType().getId());
        }
        return PHPModelUtil.hasPhpExtention(iFile);
    }

    public static boolean isReadOnly(Object object) {
        return false;
    }

    public static String getRelativeLocation(IProject iProject, String string) {
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject);
        if (pHPProjectModel == null) {
            return string;
        }
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        if (pHPFileData != null) {
            IResource iResource = PHPModelUtil.getResource(pHPFileData);
            if (iResource != null && iResource.exists()) {
                IProject iProject2 = iResource.getProject();
                if (iProject2.isAccessible()) {
                    return new Path(string).removeFirstSegments(1).toString();
                }
            } else {
                IPhpModel[] iPhpModelArray = pHPProjectModel.getModels();
                int n = 0;
                while (n < iPhpModelArray.length) {
                    if (iPhpModelArray[n].getFileData(string) == pHPFileData && iPhpModelArray[n] instanceof PHPIncludePathModelManager) {
                        PHPIncludePathModelManager pHPIncludePathModelManager = (PHPIncludePathModelManager)iPhpModelArray[n];
                        IPhpModel[] iPhpModelArray2 = pHPIncludePathModelManager.listModels();
                        int n2 = 0;
                        while (n2 < iPhpModelArray2.length) {
                            String string2 = ((PHPIncludePathModel)iPhpModelArray2[n2]).getID();
                            IPath iPath = IncludePathVariableManager.instance().getIncludePathVariable(string2);
                            if (iPhpModelArray2[n2].getFileData(string) == pHPFileData) {
                                return new Path(string).setDevice("").removeFirstSegments(iPath.segmentCount()).toString();
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
        }
        return string;
    }

    public static PHPFileData getFileData(Object object) {
        PHPFileData pHPFileData = null;
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            if (!PHPModelUtil.isPhpFile(iFile)) {
                return null;
            }
            pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(iFile.getFullPath().toString());
        }
        if (object instanceof PHPFileData) {
            pHPFileData = (PHPFileData)object;
        }
        return pHPFileData;
    }

    public static ArrayList getFunctionsToOverride(IProject iProject, PHPClassData pHPClassData, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        ArrayList<PHPFunctionData> arrayList4 = new ArrayList<PHPFunctionData>();
        if (pHPClassData != null) {
            int n;
            PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
            if (pHPClassData.getUserData() != null) {
                String string = pHPClassData.getUserData().getFileName();
                if (!arrayList2.contains(string = PHPModelUtil.getRelativeLocation(iProject, string))) {
                    arrayList2.add(string);
                    arrayList3.add(string);
                }
            }
            int n2 = pHPFunctionDataArray.length;
            if (PHPModifier.isInterface(pHPClassData.getModifiers())) {
                n = 0;
                while (n < n2) {
                    if (!arrayList.contains(pHPFunctionDataArray[n].getName())) {
                        arrayList4.add(pHPFunctionDataArray[n]);
                        arrayList.add(pHPFunctionDataArray[n].getName());
                    }
                    ++n;
                }
            } else if (PHPModifier.isAbstract(pHPClassData.getModifiers())) {
                n = 0;
                while (n < n2) {
                    if (!PHPModifier.isAbstract(pHPFunctionDataArray[n].getModifiers())) {
                        arrayList.add(pHPFunctionDataArray[n].getName());
                    } else if (!arrayList.contains(pHPFunctionDataArray[n].getName())) {
                        arrayList4.add(pHPFunctionDataArray[n]);
                        arrayList.add(pHPFunctionDataArray[n].getName());
                    }
                    ++n;
                }
            }
            if (pHPClassData.getSuperClassData() != null && pHPClassData.getSuperClassData().getName() != null) {
                PHPClassData pHPClassData2 = PHPModelUtil.getSuperClass(pHPClassData);
                ArrayList arrayList5 = PHPModelUtil.getFunctionsToOverride(iProject, pHPClassData2, arrayList, arrayList2, arrayList3);
                arrayList4.addAll(arrayList5);
                Iterator iterator = arrayList5.iterator();
                while (iterator.hasNext()) {
                    arrayList4.add((PHPFunctionData)iterator.next());
                }
            }
            if (pHPClassData.getInterfacesNamesData() != null && pHPClassData.getInterfacesNamesData().length > 0) {
                PHPClassData[] pHPClassDataArray = PHPModelUtil.getInterfaces(pHPClassData);
                int n3 = pHPClassDataArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ArrayList arrayList6 = PHPModelUtil.getFunctionsToOverride(iProject, pHPClassDataArray[n4], arrayList, arrayList2, arrayList3);
                    arrayList4.addAll(arrayList6);
                    ++n4;
                }
            }
        }
        return arrayList4;
    }

    public static IPath getIncludeModelLocation(IPhpModel iPhpModel) {
        Object object;
        if (iPhpModel instanceof PHPIncludePathModel && ((PHPIncludePathModel)(object = (PHPIncludePathModel)iPhpModel)).getType() == 1) {
            return IncludePathVariableManager.instance().getIncludePathVariable(iPhpModel.getID());
        }
        object = iPhpModel.getID();
        if (object != null) {
            return new Path((String)object);
        }
        return null;
    }

    static class FindElementVisitor
    implements PHPProjectModelVisitor {
        PHPCodeData foundElement;
        int offset;

        FindElementVisitor(int n) {
            this.offset = n;
        }

        boolean checkInside(PHPCodeData pHPCodeData) {
            boolean bl;
            UserData userData = pHPCodeData.getUserData();
            boolean bl2 = bl = userData.getStartPosition() <= this.offset && userData.getEndPosition() >= this.offset;
            if (bl) {
                this.foundElement = pHPCodeData;
            }
            return bl;
        }

        public void visit(PHPClassConstData pHPClassConstData) {
            this.checkInside(pHPClassConstData);
        }

        public void visit(PHPClassData pHPClassData) {
            this.checkInside(pHPClassData);
        }

        public void visit(PHPClassVarData pHPClassVarData) {
            this.checkInside(pHPClassVarData);
        }

        public void visit(PHPCodeData pHPCodeData) {
            this.checkInside(pHPCodeData);
        }

        public void visit(PHPConstantData pHPConstantData) {
            this.checkInside(pHPConstantData);
        }

        public void visit(PHPDocTagData pHPDocTagData) {
        }

        public void visit(PHPFileData pHPFileData) {
            this.checkInside(pHPFileData);
        }

        public void visit(PHPFunctionData pHPFunctionData) {
            this.checkInside(pHPFunctionData);
        }

        public void visit(PHPFunctionData.PHPFunctionParameter pHPFunctionParameter) {
            this.checkInside(pHPFunctionParameter);
        }

        public void visit(PHPIncludeFileData pHPIncludeFileData) {
            this.checkInside(pHPIncludeFileData);
        }

        public void visit(PHPClassData.PHPInterfaceNameData pHPInterfaceNameData) {
            this.checkInside(pHPInterfaceNameData);
        }

        public void visit(PHPKeywordData pHPKeywordData) {
            this.checkInside(pHPKeywordData);
        }

        public void visit(PHPClassData.PHPSuperClassNameData pHPSuperClassNameData) {
            this.checkInside(pHPSuperClassNameData);
        }

        public void visit(PHPVariableData pHPVariableData) {
            this.checkInside(pHPVariableData);
        }
    }

    public static class PHPContainerStringConverter {
        public static Object toContainer(String string) {
            PHPFileData pHPFileData;
            IPath iPath = Path.fromPortableString((String)string);
            if (iPath == null) {
                return null;
            }
            IFile iFile = null;
            try {
                iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (iFile != null && (pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(iFile, false)) != null) {
                return pHPFileData;
            }
            pHPFileData = null;
            try {
                pHPFileData = ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (pHPFileData != null) {
                return pHPFileData;
            }
            IProject iProject = null;
            try {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(iPath.segments()[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            return iProject;
        }

        public static String toString(Object object) {
            IPath iPath;
            if (object instanceof PHPCodeData) {
                while (object != null && !(object instanceof PHPFileData)) {
                    object = ((PHPCodeData)object).getContainer();
                }
            }
            if (object == null) {
                return "";
            }
            IResource iResource = PHPModelUtil.getResource(object);
            if (iResource != null && (iPath = iResource.getFullPath()) != null) {
                return iPath.toPortableString();
            }
            return "";
        }
    }
}

