/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;

public class ExternalFileDecorator
implements IFile,
IAdaptable,
IResource,
ICoreConstants,
Cloneable,
IPathRequestor {
    private String device;
    private IFile file;

    ExternalFileDecorator(IFile iFile, String string) {
        this.file = iFile;
        this.device = string;
    }

    public IPath getFullPath() {
        IPath iPath = this.file.getFullPath();
        if (iPath.segmentCount() > 1 && iPath.segment(0).equals(ExternalFilesRegistry.getInstance().getExternalFilesProject().getName())) {
            iPath = iPath.removeFirstSegments(1);
            String string = String.valueOf(File.separatorChar) + iPath.segment(0);
            iPath = new Path(string);
        }
        return iPath.setDevice(this.device);
    }

    public IPath getLocation() {
        IPath iPath = this.file.getLocation();
        if (iPath == null) {
            iPath = this.getFullPath();
        }
        return iPath;
    }

    public void accept(IResourceProxyVisitor iResourceProxyVisitor, int n) throws CoreException {
        this.file.accept(iResourceProxyVisitor, n);
    }

    public void accept(IResourceVisitor iResourceVisitor, int n, boolean bl) throws CoreException {
        this.file.accept(iResourceVisitor, n, bl);
    }

    public void accept(IResourceVisitor iResourceVisitor, int n, int n2) throws CoreException {
        this.file.accept(iResourceVisitor, n, n2);
    }

    public void accept(IResourceVisitor iResourceVisitor) throws CoreException {
        this.file.accept(iResourceVisitor);
    }

    public void appendContents(InputStream inputStream, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.appendContents(inputStream, bl, bl2, iProgressMonitor);
    }

    public void appendContents(InputStream inputStream, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.appendContents(inputStream, n, iProgressMonitor);
    }

    public void clearHistory(IProgressMonitor iProgressMonitor) {
        try {
            this.file.clearHistory(iProgressMonitor);
        }
        catch (CoreException coreException) {
            Logger.logException(coreException);
        }
    }

    public boolean contains(ISchedulingRule iSchedulingRule) {
        return this.file.contains(iSchedulingRule);
    }

    public void copy(IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.copy(iPath, bl, iProgressMonitor);
    }

    public void copy(IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.copy(iPath, n, iProgressMonitor);
    }

    public void copy(IProjectDescription iProjectDescription, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.copy(iProjectDescription, bl, iProgressMonitor);
    }

    public void copy(IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.copy(iProjectDescription, n, iProgressMonitor);
    }

    public void create(InputStream inputStream, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.create(inputStream, bl, iProgressMonitor);
    }

    public void create(InputStream inputStream, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.create(inputStream, n, iProgressMonitor);
    }

    public void createLink(IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.createLink(iPath, n, iProgressMonitor);
    }

    public void createLink(URI uRI, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.createLink(uRI, n, iProgressMonitor);
    }

    public IMarker createMarker(String string) throws CoreException {
        return this.file.createMarker(string);
    }

    public IResourceProxy createProxy() {
        return this.file.createProxy();
    }

    public void delete(boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.delete(bl, bl2, iProgressMonitor);
    }

    public void delete(boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.delete(bl, iProgressMonitor);
    }

    public void delete(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.delete(n, iProgressMonitor);
    }

    public void deleteMarkers(String string, boolean bl, int n) throws CoreException {
        this.file.deleteMarkers(string, bl, n);
    }

    public boolean equals(Object object) {
        return this.file.equals(object);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public IMarker findMarker(long l) {
        try {
            return this.file.findMarker(l);
        }
        catch (CoreException coreException) {
            Logger.logException(coreException);
            return null;
        }
    }

    public IMarker[] findMarkers(String string, boolean bl, int n) throws CoreException {
        try {
            return this.file.findMarkers(string, bl, n);
        }
        catch (Exception exception) {
            return new IMarker[0];
        }
    }

    public Object getAdapter(Class clazz) {
        return this.file.getAdapter(clazz);
    }

    public String getCharset() throws CoreException {
        return this.file.getCharset();
    }

    public String getCharset(boolean bl) throws CoreException {
        return this.file.getCharset(bl);
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        return this.file.getCharsetFor(reader);
    }

    public IContentDescription getContentDescription() throws CoreException {
        return this.file.getContentDescription();
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.file.getFullPath().toFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.core", 4, fileNotFoundException.getMessage(), (Throwable)fileNotFoundException));
        }
    }

    public InputStream getContents(boolean bl) throws CoreException {
        return this.file.getContents(bl);
    }

    public int getEncoding() throws CoreException {
        return this.file.getEncoding();
    }

    public String getFileExtension() {
        return this.file.getFileExtension();
    }

    public IFileState[] getHistory(IProgressMonitor iProgressMonitor) {
        try {
            return this.file.getHistory(iProgressMonitor);
        }
        catch (CoreException coreException) {
            Logger.logException(coreException);
            return new IFileState[0];
        }
    }

    public long getLocalTimeStamp() {
        return this.file.getLocalTimeStamp();
    }

    public URI getLocationURI() {
        return this.file.getLocationURI();
    }

    public IMarker getMarker(long l) {
        return this.file.getMarker(l);
    }

    public long getModificationStamp() {
        return this.file.getModificationStamp();
    }

    public String getName() {
        return this.file.getName();
    }

    public IContainer getParent() {
        return this.file.getParent();
    }

    public String getPersistentProperty(QualifiedName qualifiedName) throws CoreException {
        return this.file.getPersistentProperty(qualifiedName);
    }

    public IProject getProject() {
        return ExternalFilesRegistry.getInstance().getExternalFilesProject();
    }

    public IPath getProjectRelativePath() {
        return this.file.getProjectRelativePath();
    }

    public IPath getRawLocation() {
        return this.file.getRawLocation();
    }

    public URI getRawLocationURI() {
        return this.file.getRawLocationURI();
    }

    public ResourceAttributes getResourceAttributes() {
        return this.file.getResourceAttributes();
    }

    public Object getSessionProperty(QualifiedName qualifiedName) throws CoreException {
        return this.file.getSessionProperty(qualifiedName);
    }

    public int getType() {
        return this.file.getType();
    }

    public IWorkspace getWorkspace() {
        return this.file.getWorkspace();
    }

    public boolean isAccessible() {
        return this.file.isAccessible();
    }

    public boolean isConflicting(ISchedulingRule iSchedulingRule) {
        return this.file.isConflicting(iSchedulingRule);
    }

    public boolean isDerived() {
        return this.file.isDerived();
    }

    public boolean isLinked() {
        return this.file.isLinked();
    }

    public boolean isLinked(int n) {
        return this.file.isLinked(n);
    }

    public boolean isLocal(int n) {
        return this.file.isLocal(n);
    }

    public boolean isPhantom() {
        return this.file.isPhantom();
    }

    public boolean isReadOnly() {
        return this.file.isReadOnly();
    }

    public boolean isSynchronized(int n) {
        return this.file.isSynchronized(n);
    }

    public boolean isTeamPrivateMember() {
        return this.file.isTeamPrivateMember();
    }

    public void move(IPath iPath, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.move(iPath, bl, bl2, iProgressMonitor);
    }

    public void move(IPath iPath, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.move(iPath, bl, iProgressMonitor);
    }

    public void move(IPath iPath, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.move(iPath, n, iProgressMonitor);
    }

    public void move(IProjectDescription iProjectDescription, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.move(iProjectDescription, bl, bl2, iProgressMonitor);
    }

    public void move(IProjectDescription iProjectDescription, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.move(iProjectDescription, n, iProgressMonitor);
    }

    public void refreshLocal(int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.refreshLocal(n, iProgressMonitor);
    }

    public void revertModificationStamp(long l) throws CoreException {
        this.file.revertModificationStamp(l);
    }

    public void setCharset(String string, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.setCharset(string, iProgressMonitor);
    }

    public void setCharset(String string) throws CoreException {
        this.file.setCharset(string);
    }

    public void setContents(IFileState iFileState, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.setContents(iFileState, bl, bl2, iProgressMonitor);
    }

    public void setContents(IFileState iFileState, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.setContents(iFileState, n, iProgressMonitor);
    }

    public void setContents(InputStream inputStream, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.setContents(inputStream, bl, bl2, iProgressMonitor);
    }

    public void setContents(InputStream inputStream, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.setContents(inputStream, n, iProgressMonitor);
    }

    public void setDerived(boolean bl) throws CoreException {
        this.file.setDerived(bl);
    }

    public void setLocal(boolean bl, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.setLocal(bl, n, iProgressMonitor);
    }

    public long setLocalTimeStamp(long l) throws CoreException {
        return this.file.setLocalTimeStamp(l);
    }

    public void setPersistentProperty(QualifiedName qualifiedName, String string) throws CoreException {
        this.file.setPersistentProperty(qualifiedName, string);
    }

    public void setReadOnly(boolean bl) {
        this.file.setReadOnly(bl);
    }

    public void setResourceAttributes(ResourceAttributes resourceAttributes) throws CoreException {
        this.file.setResourceAttributes(resourceAttributes);
    }

    public void setSessionProperty(QualifiedName qualifiedName, Object object) throws CoreException {
        this.file.setSessionProperty(qualifiedName, object);
    }

    public void setTeamPrivateMember(boolean bl) throws CoreException {
        this.file.setTeamPrivateMember(bl);
    }

    public void touch(IProgressMonitor iProgressMonitor) throws CoreException {
        this.file.touch(iProgressMonitor);
    }

    public String requestName() {
        return this.getName();
    }

    public IPath requestPath() {
        return this.getFullPath();
    }

    public String toString() {
        return this.getFullPath().toString();
    }

    public static synchronized IFile createFile(String string) {
        IPath iPath = Path.fromOSString((String)string);
        if (iPath.segmentCount() == 1) {
            Path path = new Path(iPath.getDevice());
            path = path.append(ExternalFilesRegistry.getInstance().getExternalFilesProject().getFullPath());
            iPath = path.append(iPath.segment(0));
        }
        return new ExternalFileDecorator(ResourcesPlugin.getWorkspace().getRoot().getFile(iPath), iPath.getDevice());
    }
}

