/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.opengl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.opengl.carbon.AGL;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class GLCanvas
extends Canvas {
    int context;
    int pixelFormat;
    static final int MAX_ATTRIBUTES = 32;

    public GLCanvas(Composite parent, int style, GLData data) {
        super(parent, style);
        if (data == null) {
            SWT.error(4);
        }
        int[] aglAttrib = new int[32];
        int pos = 0;
        aglAttrib[pos++] = 4;
        if (data.doubleBuffer) {
            aglAttrib[pos++] = 5;
        }
        if (data.stereo) {
            aglAttrib[pos++] = 6;
        }
        if (data.redSize > 0) {
            aglAttrib[pos++] = 8;
            aglAttrib[pos++] = data.redSize;
        }
        if (data.greenSize > 0) {
            aglAttrib[pos++] = 9;
            aglAttrib[pos++] = data.greenSize;
        }
        if (data.blueSize > 0) {
            aglAttrib[pos++] = 10;
            aglAttrib[pos++] = data.blueSize;
        }
        if (data.alphaSize > 0) {
            aglAttrib[pos++] = 11;
            aglAttrib[pos++] = data.alphaSize;
        }
        if (data.depthSize > 0) {
            aglAttrib[pos++] = 12;
            aglAttrib[pos++] = data.depthSize;
        }
        if (data.stencilSize > 0) {
            aglAttrib[pos++] = 13;
            aglAttrib[pos++] = data.stencilSize;
        }
        if (data.accumRedSize > 0) {
            aglAttrib[pos++] = 14;
            aglAttrib[pos++] = data.accumRedSize;
        }
        if (data.accumGreenSize > 0) {
            aglAttrib[pos++] = 15;
            aglAttrib[pos++] = data.accumGreenSize;
        }
        if (data.accumBlueSize > 0) {
            aglAttrib[pos++] = 16;
            aglAttrib[pos++] = data.accumBlueSize;
        }
        if (data.accumAlphaSize > 0) {
            aglAttrib[pos++] = 17;
            aglAttrib[pos++] = data.accumAlphaSize;
        }
        if (data.sampleBuffers > 0) {
            aglAttrib[pos++] = 55;
            aglAttrib[pos++] = data.sampleBuffers;
        }
        if (data.samples > 0) {
            aglAttrib[pos++] = 56;
            aglAttrib[pos++] = data.samples;
        }
        aglAttrib[pos++] = 0;
        this.pixelFormat = AGL.aglChoosePixelFormat(0, 0, aglAttrib);
        if (this.pixelFormat == 0) {
            this.dispose();
            SWT.error(38);
        }
        this.context = AGL.aglCreateContext(this.pixelFormat, 0);
        int window = OS.GetControlOwner(this.handle);
        int port = OS.GetWindowPort(window);
        AGL.aglSetDrawable(this.context, port);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        AGL.aglDestroyContext(GLCanvas.this.context);
                        AGL.aglDestroyPixelFormat(GLCanvas.this.pixelFormat);
                        Shell shell = GLCanvas.this.getShell();
                        shell.removeListener(11, this);
                        shell.removeListener(22, this);
                        shell.removeListener(23, this);
                        Composite c = GLCanvas.this;
                        do {
                            c.removeListener(22, this);
                            c.removeListener(23, this);
                        } while ((c = c.getParent()) != shell);
                        break;
                    }
                    case 11: 
                    case 22: 
                    case 23: {
                        GLCanvas.this.getDisplay().asyncExec(new Runnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                if (1.access$0(this.this$1).isDisposed()) {
                                    return;
                                }
                                1.access$0(this.this$1).fixBounds();
                            }
                        });
                    }
                }
            }

            static /* synthetic */ GLCanvas access$0(1 var0) {
                return var0.GLCanvas.this;
            }
        };
        this.addListener(11, listener);
        Shell shell = this.getShell();
        shell.addListener(11, listener);
        shell.addListener(22, listener);
        shell.addListener(23, listener);
        Composite c = this;
        do {
            c.addListener(22, listener);
            c.addListener(23, listener);
        } while ((c = c.getParent()) != shell);
        this.addListener(12, listener);
    }

    void fixBounds() {
        GCData data = new GCData();
        int gc = this.internal_new_GC(data);
        Rect bounds = new Rect();
        OS.GetRegionBounds(data.visibleRgn, bounds);
        int width = bounds.right - bounds.left;
        int height = bounds.bottom - bounds.top;
        Rect rect = new Rect();
        int window = OS.GetControlOwner(this.handle);
        int port = OS.GetWindowPort(window);
        OS.GetPortBounds(port, rect);
        int[] glbounds = new int[]{bounds.left, rect.bottom - rect.top - bounds.top - height, width, height};
        AGL.aglSetInteger(this.context, 202, glbounds);
        AGL.aglEnable(this.context, 202);
        AGL.aglSetInteger(this.context, 254, data.visibleRgn);
        AGL.aglUpdateContext(this.context);
        this.internal_dispose_GC(gc, data);
    }

    public GLData getGLData() {
        this.checkWidget();
        GLData data = new GLData();
        int[] value = new int[1];
        AGL.aglDescribePixelFormat(this.pixelFormat, 5, value);
        data.doubleBuffer = value[0] != 0;
        AGL.aglDescribePixelFormat(this.pixelFormat, 6, value);
        data.stereo = value[0] != 0;
        AGL.aglDescribePixelFormat(this.pixelFormat, 8, value);
        data.redSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 9, value);
        data.greenSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 10, value);
        data.blueSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 11, value);
        data.alphaSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 12, value);
        data.depthSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 13, value);
        data.stencilSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 14, value);
        data.accumRedSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 15, value);
        data.accumGreenSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 16, value);
        data.accumBlueSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 17, value);
        data.accumAlphaSize = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 55, value);
        data.sampleBuffers = value[0];
        AGL.aglDescribePixelFormat(this.pixelFormat, 56, value);
        data.samples = value[0];
        return data;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return AGL.aglGetCurrentContext() == this.context;
    }

    public void setCurrent() {
        this.checkWidget();
        if (AGL.aglGetCurrentContext() != this.context) {
            AGL.aglSetCurrentContext(this.context);
        }
    }

    public void swapBuffers() {
        this.checkWidget();
        AGL.aglSwapBuffers(this.context);
    }
}

