/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ConfigureBuildPathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private IProject fProject;
    static /* synthetic */ Class class$0;

    public ConfigureBuildPathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ConfigureBP_label, JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_ConfigureBP_tooltip);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH);
        this.fSite = site;
    }

    private Shell getShell() {
        return this.fSite.getShell();
    }

    public void run() {
        if (this.fProject != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, (String)"org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage", null, null).open();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() != 1) {
            return false;
        }
        Object firstElement = elements.getFirstElement();
        this.fProject = this.getProjectFromSelectedElement(firstElement);
        return this.fProject != null;
    }

    private IProject getProjectFromSelectedElement(Object firstElement) {
        if (firstElement instanceof IJavaElement) {
            IJavaElement element = (IJavaElement)firstElement;
            IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot(element);
            if (root != null && root != element && root.isArchive()) {
                return null;
            }
            IJavaProject project = element.getJavaProject();
            if (project != null) {
                return project.getProject();
            }
            return null;
        }
        if (firstElement instanceof ClassPathContainer) {
            return ((ClassPathContainer)firstElement).getJavaProject().getProject();
        }
        if (firstElement instanceof IAdaptable) {
            IResource res;
            IAdaptable iAdaptable = (IAdaptable)firstElement;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((res = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                return res.getProject();
            }
        }
        return null;
    }
}

