/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.treecontent;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.project.options.IPhpProjectOptionChangeListener;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.treecontent.PHPTreeNode;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.graphics.Image;

public class IncludePathTreeContent
implements IPHPTreeContentProvider {
    public static final String ID_INCLUDES_NODE = "org.eclipse.php.ui.treecontent.IncludesNode";
    TreeViewer treeViewer;
    HashMap projects = new HashMap();
    ElementTree includePathTree = new ElementTree();
    static final String INCLUDE_MODEL_MANAGER_ID = "CompositeIncludePathModel";
    static final IPath INCLUDE_MODELS_PATH_ROOT = new Path("\u0000IncludePaths");

    Object[] getPathChildren(IPath iPath) {
        Object object;
        IPath iPath2 = iPath.uptoSegment(2);
        if (!this.includePathTree.includes(iPath2)) {
            return NO_CHILDREN;
        }
        Object object2 = this.includePathTree.getElementData(iPath2);
        if (!(object2 instanceof PHPIncludePathModel) && !(object2 instanceof PhpModelProxy)) {
            return NO_CHILDREN;
        }
        IPhpModel iPhpModel = (IPhpModel)this.includePathTree.getElementData(iPath2);
        IPath iPath3 = PHPModelUtil.getIncludeModelLocation((IPhpModel)iPhpModel);
        CodeData[] codeDataArray = iPhpModel.getFileDatas();
        int n = 0;
        while (n < codeDataArray.length) {
            Path path;
            IPath iPath4;
            object = codeDataArray[n].getName();
            if ((((String)object).startsWith(iPath3.toOSString()) || ((String)object).startsWith(iPath3.makeAbsolute().toString())) && !this.includePathTree.includes(iPath4 = iPath2.append((path = new Path((String)object)).removeFirstSegments(iPath3.segmentCount())))) {
                IPath iPath5 = iPath4.removeLastSegments(1);
                while (iPath5.segmentCount() > iPath2.segmentCount() && !this.includePathTree.includes(iPath5)) {
                    iPath5 = iPath5.removeLastSegments(1);
                }
                IPath iPath6 = iPath5.append(iPath4.segment(iPath5.segmentCount()));
                while (iPath6.segmentCount() < iPath4.segmentCount()) {
                    this.includePathTree.createElement(iPath6, (Object)((Workspace)ResourcesPlugin.getWorkspace()).newResource(iPath6, 2));
                    iPath6 = iPath6.append(iPath4.segment(iPath6.segmentCount()));
                }
                this.includePathTree.createElement(iPath4, (Object)codeDataArray[n]);
            }
            ++n;
        }
        IPath[] iPathArray = this.includePathTree.getChildren(iPath);
        object = new ArrayList(iPathArray.length);
        int n2 = 0;
        while (n2 < iPathArray.length) {
            ((ArrayList)object).add(this.includePathTree.getElementData(iPathArray[n2]));
            ++n2;
        }
        return ((ArrayList)object).toArray();
    }

    public Object[] getChildren(Object object) {
        if (object instanceof IProject) {
            IProject iProject = (IProject)object;
            PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
            if (pHPProjectOptions != null) {
                Object[] objectArray = new Object[]{this.getTreeNode(iProject)};
                return objectArray;
            }
        } else {
            if (object instanceof PHPTreeNode && ID_INCLUDES_NODE.equals(((PHPTreeNode)object).getId())) {
                PHPTreeNode pHPTreeNode = (PHPTreeNode)object;
                PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject((IProject)pHPTreeNode.getData());
                if (pHPProjectModel == null) {
                    return new Object[0];
                }
                PHPIncludePathModelManager pHPIncludePathModelManager = (PHPIncludePathModelManager)pHPProjectModel.getModel(INCLUDE_MODEL_MANAGER_ID);
                if (pHPIncludePathModelManager == null) {
                    return new Object[0];
                }
                IPhpModel[] iPhpModelArray = pHPIncludePathModelManager.listModels();
                ArrayList<IPhpModel> arrayList = new ArrayList<IPhpModel>(iPhpModelArray.length);
                int n = 0;
                while (n < iPhpModelArray.length) {
                    IPath iPath = PHPModelUtil.getIncludeModelLocation((IPhpModel)iPhpModelArray[n]);
                    if (iPath != null) {
                        arrayList.add(iPhpModelArray[n]);
                    }
                    ++n;
                }
                return arrayList.toArray();
            }
            if (object instanceof PHPIncludePathModel || object instanceof PhpModelProxy) {
                IPhpModel iPhpModel = (IPhpModel)object;
                this.validateRoot();
                IPath iPath = INCLUDE_MODELS_PATH_ROOT.append(IncludeModelPathRootConverter.to(iPhpModel));
                if (!this.includePathTree.includes(iPath)) {
                    this.includePathTree.createElement(iPath, (Object)iPhpModel);
                }
                return this.getPathChildren(iPath);
            }
            if (object instanceof IResource) {
                IPath iPath = ((IResource)object).getFullPath();
                if (this.includePathTree.includes(((IResource)object).getFullPath())) {
                    return this.getPathChildren(iPath);
                }
            }
        }
        return NO_CHILDREN;
    }

    private void validateRoot() {
        if (!this.includePathTree.includes(INCLUDE_MODELS_PATH_ROOT)) {
            this.includePathTree.createElement(INCLUDE_MODELS_PATH_ROOT, (Object)INCLUDE_MODELS_PATH_ROOT.segment(1));
        }
    }

    IncludesNode getTreeNode(IProject iProject) {
        Object[] objectArray;
        IncludesNode includesNode = (IncludesNode)this.projects.get(iProject);
        if (includesNode == null) {
            objectArray = PHPUiPlugin.getImageDescriptorRegistry().get(PHPPluginImages.DESC_OBJS_LIBRARY);
            includesNode = new IncludesNode("Include Paths", (Image)objectArray, ID_INCLUDES_NODE, iProject, null);
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)includesNode);
            this.projects.put(iProject, includesNode);
            PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
            pHPProjectOptions.addOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)includesNode);
        }
        if ((objectArray = this.getChildren(includesNode)).length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                this.getChildren(objectArray[n]);
                ++n;
            }
        }
        return includesNode;
    }

    public Object getParent(Object object) {
        block9: {
            IPath iPath;
            block10: {
                block8: {
                    if (this.includePathTree == null) {
                        return null;
                    }
                    if (!(object instanceof PHPFileData)) break block8;
                    PHPFileData pHPFileData = (PHPFileData)object;
                    String string = pHPFileData.getName();
                    Path path = new Path(string);
                    if (!this.includePathTree.includes(INCLUDE_MODELS_PATH_ROOT)) {
                        return null;
                    }
                    IPath[] iPathArray = this.includePathTree.getChildren(INCLUDE_MODELS_PATH_ROOT);
                    int n = 0;
                    while (n < iPathArray.length) {
                        IPath iPath2;
                        IPath iPath3 = PHPModelUtil.getIncludeModelLocation((IPhpModel)((PHPIncludePathModel)this.includePathTree.getElementData(iPathArray[n])));
                        if (string.startsWith(iPath3.toOSString()) && this.includePathTree.includes(iPath2 = iPathArray[n].append(path.removeFirstSegments(iPath3.segmentCount())))) {
                            IPath iPath4 = iPath2.removeLastSegments(1);
                            return this.includePathTree.getElementData(iPath4);
                        }
                        ++n;
                    }
                    break block9;
                }
                if (!(object instanceof IFolder)) break block10;
                IFolder iFolder = (IFolder)object;
                IPath iPath5 = iFolder.getFullPath();
                if (this.includePathTree.includes(iPath5)) {
                    return this.includePathTree.getElementData(iPath5.removeLastSegments(1));
                }
                break block9;
            }
            if (!(object instanceof PHPIncludePathModel) || !this.includePathTree.includes(iPath = INCLUDE_MODELS_PATH_ROOT.append(IncludeModelPathRootConverter.to((IPhpModel)((PHPIncludePathModel)object))))) break block9;
            Iterator iterator = this.projects.values().iterator();
            while (iterator.hasNext()) {
                IncludesNode includesNode = (IncludesNode)iterator.next();
                Object[] objectArray = this.getChildren(includesNode);
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] == object) {
                        return includesNode;
                    }
                    ++n;
                }
            }
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return object instanceof PHPTreeNode;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
        Iterator iterator = this.projects.keySet().iterator();
        while (iterator.hasNext()) {
            IProject iProject = (IProject)iterator.next();
            IncludesNode includesNode = (IncludesNode)this.projects.get(iProject);
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)includesNode);
            PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject);
            pHPProjectOptions.removeOptionChangeListener("org.eclipse.php.core.includePath", (IPhpProjectOptionChangeListener)includesNode);
        }
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public Image getImage(Object object) {
        if (object instanceof PHPTreeNode) {
            PHPTreeNode pHPTreeNode = (PHPTreeNode)object;
            return pHPTreeNode.getImage();
        }
        return null;
    }

    public String getText(Object object) {
        if (object instanceof PHPTreeNode) {
            PHPTreeNode pHPTreeNode = (PHPTreeNode)object;
            return pHPTreeNode.getText();
        }
        if (object instanceof PHPIncludePathModel) {
            PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)object;
            String string = pHPIncludePathModel.getID();
            IPath iPath = IncludePathVariableManager.instance().getIncludePathVariable(pHPIncludePathModel.getID());
            if (iPath != null) {
                return String.valueOf(string) + " (" + IncludePathVariableManager.instance().getIncludePathVariable(pHPIncludePathModel.getID()).toOSString() + ")";
            }
            return string;
        }
        if (object instanceof PhpModelProxy) {
            PhpModelProxy phpModelProxy = (PhpModelProxy)object;
            return phpModelProxy.getID();
        }
        if (object instanceof PHPFileData) {
            PHPFileData pHPFileData = (PHPFileData)object;
            IPath[] iPathArray = this.includePathTree.getChildren(this.includePathTree.getRoot());
            int n = 0;
            while (n < iPathArray.length) {
                PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)this.includePathTree.getElementData(iPathArray[n]);
                IPath iPath = PHPModelUtil.getIncludeModelLocation((IPhpModel)pHPIncludePathModel);
                if (pHPFileData.getName().startsWith(iPath.toOSString())) {
                    return new Path(pHPFileData.getName()).lastSegment();
                }
                ++n;
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    static class IncludeModelPathRootConverter {
        IncludeModelPathRootConverter() {
        }

        public static String to(IPhpModel iPhpModel) {
            return String.valueOf(iPhpModel.getID().replace('/', '?').replace(File.separatorChar, '!').replace(':', ';'));
        }

        static IPhpModel from(String string, IProject[] iProjectArray) {
            String string2 = string.replace('?', '/').replace('!', File.separatorChar).replace(';', ':');
            int n = 0;
            while (n < iProjectArray.length) {
                IPhpModel iPhpModel;
                PHPIncludePathModelManager pHPIncludePathModelManager;
                PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProjectArray[n]);
                if (pHPProjectModel != null && (pHPIncludePathModelManager = (PHPIncludePathModelManager)pHPProjectModel.getModel(IncludePathTreeContent.INCLUDE_MODEL_MANAGER_ID)) != null && (iPhpModel = pHPIncludePathModelManager.getModel(string2)) != null) {
                    return iPhpModel;
                }
                ++n;
            }
            return null;
        }

        public static IPhpModel from(String string, IProject iProject) {
            return IncludeModelPathRootConverter.from(string, new IProject[]{iProject});
        }

        public static IPhpModel from(String string) {
            return IncludeModelPathRootConverter.from(string, ResourcesPlugin.getWorkspace().getRoot().getProjects());
        }
    }

    class IncludesNode
    extends PHPTreeNode
    implements IPhpProjectOptionChangeListener,
    ModelListener {
        IncludesNode(String string, Image image, String string2, Object object, Object[] objectArray) {
            super(string, image, string2, object, objectArray);
        }

        protected void refresh(Object object) {
            if (IncludePathTreeContent.this.treeViewer != null && !IncludePathTreeContent.this.treeViewer.getControl().isDisposed()) {
                IncludePathTreeContent.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(this, object){
                    final /* synthetic */ IncludesNode this$1;
                    private final /* synthetic */ Object val$obj;
                    {
                        this.this$1 = includesNode;
                        this.val$obj = object;
                    }

                    public void run() {
                        if (IncludesNode.access$0((IncludesNode)this.this$1).treeViewer != null && !IncludesNode.access$0((IncludesNode)this.this$1).treeViewer.getControl().isDisposed()) {
                            IncludesNode.access$0((IncludesNode)this.this$1).treeViewer.refresh(this.val$obj);
                        }
                    }
                });
            }
        }

        protected void refresh() {
            this.refresh(this);
        }

        public void notifyOptionChanged(Object object, Object object2) {
            this.refresh();
        }

        public void dataCleared() {
        }

        private IPhpModel findModel(PHPFileData pHPFileData) {
            IncludePathTreeContent.this.validateRoot();
            IPath[] iPathArray = IncludePathTreeContent.this.includePathTree.getChildren(INCLUDE_MODELS_PATH_ROOT);
            IResource iResource = PHPModelUtil.getResource((Object)pHPFileData);
            Path path = new Path(pHPFileData.getName());
            String string = path.toOSString();
            if (iResource != null) {
                string = iResource.getLocation().toOSString();
            }
            int n = 0;
            while (n < iPathArray.length) {
                IPath iPath;
                IPhpModel iPhpModel = IncludeModelPathRootConverter.from(iPathArray[n].segment(1));
                if (iPhpModel != null && (iPath = PHPModelUtil.getIncludeModelLocation((IPhpModel)iPhpModel)) != null && (string.startsWith(iPath.toOSString()) || path.isAbsolute() && path.segment(0).equals(iPhpModel.getID()))) {
                    return iPhpModel;
                }
                ++n;
            }
            return null;
        }

        protected void refresh(PHPFileData pHPFileData, boolean bl) {
            IPhpModel iPhpModel = this.findModel(pHPFileData);
            if (iPhpModel == null) {
                return;
            }
            IPath iPath = PHPModelUtil.getIncludeModelLocation((IPhpModel)iPhpModel);
            String string = pHPFileData.getName();
            Path path = new Path(string);
            IPath iPath2 = INCLUDE_MODELS_PATH_ROOT.append(IncludeModelPathRootConverter.to(iPhpModel));
            IPath iPath3 = iPath2.append(path.removeFirstSegments(iPath.segmentCount()));
            if (IncludePathTreeContent.this.includePathTree.includes(iPath3)) {
                if (bl) {
                    IncludePathTreeContent.this.includePathTree.deleteElement(iPath3);
                    this.refresh(iPath3.removeLastSegments(1));
                } else {
                    this.refresh(iPath3);
                }
            } else {
                this.refresh();
            }
        }

        public void fileDataAdded(PHPFileData pHPFileData) {
            this.refresh(pHPFileData, false);
        }

        public void fileDataChanged(PHPFileData pHPFileData) {
            this.refresh(pHPFileData, false);
        }

        public void fileDataRemoved(PHPFileData pHPFileData) {
            this.refresh(pHPFileData, true);
        }

        static /* synthetic */ IncludePathTreeContent access$0(IncludesNode includesNode) {
            return includesNode.IncludePathTreeContent.this;
        }
    }
}

