/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.php.internal.core.phpModel.parser.PHPIncludePathModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.parser.PhpModelProxy;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineContentProvider;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.php.internal.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PHPElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;
    static /* synthetic */ Class class$0;

    public PHPElementImageProvider() {
        ISharedImages iSharedImages = PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = iSharedImages.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = PHPPluginImages.DESC_OBJS_PHP_PROJECT;
        this.fRegistry = null;
    }

    public Image getImageLabel(Object object, int n) {
        return this.getImageLabel(this.computeDescriptor(object, n));
    }

    private Image getImageLabel(ImageDescriptor imageDescriptor) {
        if (imageDescriptor == null) {
            return null;
        }
        return this.getRegistry().get(imageDescriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = PHPUiPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object object, int n) {
        if (object instanceof PHPCodeData) {
            return this.getPHPImageDescriptor((PHPCodeData)object, n);
        }
        if (object instanceof PHPProjectModel) {
            return DESC_OBJ_PROJECT;
        }
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            if ("as".equals(iFile.getFileExtension())) {
                return this.getCUResourceImageDescriptor(iFile, n);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)iFile, n);
        }
        if (object instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)object, n);
        }
        if (object.equals("constants")) {
            return PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP;
        }
        if (object instanceof PHPIncludePathModel) {
            PHPIncludePathModel pHPIncludePathModel = (PHPIncludePathModel)object;
            switch (pHPIncludePathModel.getType()) {
                case 1: {
                    return PHPPluginImages.DESC_OBJS_ENV_VAR;
                }
            }
            return PHPPluginImages.DESC_OBJS_LIBRARY;
        }
        if (object instanceof PhpModelProxy) {
            return DESC_OBJ_PROJECT;
        }
        switch (ProjectOutlineContentProvider.getNodeType(object)) {
            case 3: {
                return PHPPluginImages.DESC_OBJ_PHP_CLASSES_GROUP;
            }
            case 2: {
                return PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP;
            }
            case 4: {
                return PHPPluginImages.DESC_OBJ_PHP_FUNCTIONS_GROUP;
            }
        }
        return null;
    }

    private static boolean showOverlayIcons(int n) {
        return (n & 1) != 0;
    }

    private static boolean useSmallSize(int n) {
        return (n & 2) != 0;
    }

    private static boolean useLightIcons(int n) {
        return (n & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile iFile, int n) {
        Point point = PHPElementImageProvider.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        return new PHPElementImageDescriptor(PHPPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, point);
    }

    public ImageDescriptor getPHPImageDescriptor(PHPCodeData pHPCodeData, int n) {
        int n2 = this.computePHPAdornmentFlags(pHPCodeData, n);
        Point point = PHPElementImageProvider.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        return new PHPElementImageDescriptor(this.getBaseImageDescriptor(pHPCodeData, n), n2, point);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable iAdaptable, int n) {
        IWorkbenchAdapter iWorkbenchAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iAdaptable);
        if (imageDescriptor == null) {
            return null;
        }
        Point point = PHPElementImageProvider.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        return new PHPElementImageDescriptor(imageDescriptor, 0, point);
    }

    public ImageDescriptor getBaseImageDescriptor(PHPCodeData pHPCodeData, int n) {
        if (pHPCodeData instanceof PHPFunctionData) {
            PHPFunctionData pHPFunctionData = (PHPFunctionData)pHPCodeData;
            return PHPElementImageProvider.getMethodImageDescriptor(pHPFunctionData.getModifiers());
        }
        if (pHPCodeData instanceof PHPClassVarData) {
            PHPClassVarData pHPClassVarData = (PHPClassVarData)pHPCodeData;
            return PHPElementImageProvider.getFieldImageDescriptor(pHPClassVarData.getModifiers());
        }
        if (pHPCodeData instanceof PHPConstantData || pHPCodeData instanceof PHPClassConstData || pHPCodeData.equals("constants")) {
            return PHPPluginImages.DESC_CONSTANT;
        }
        if (pHPCodeData instanceof PHPClassData) {
            PHPClassData pHPClassData = (PHPClassData)pHPCodeData;
            if (PHPElementImageProvider.useLightIcons(n)) {
                if (PHPModifier.isInterface((int)pHPClassData.getModifiers())) {
                    return PHPPluginImages.DESC_OBJS_INTERFACE;
                }
                return PHPPluginImages.DESC_OBJS_CLASSALT;
            }
            return PHPElementImageProvider.getTypeImageDescriptor(pHPClassData.getModifiers());
        }
        if (pHPCodeData instanceof PHPFileData) {
            return PHPPluginImages.DESC_OBJS_CUNIT;
        }
        if (pHPCodeData instanceof PHPIncludeFileData) {
            return PHPPluginImages.DESC_OBJS_INCLUDE;
        }
        if (pHPCodeData instanceof PHPProjectModel) {
            PHPProjectModel pHPProjectModel = (PHPProjectModel)pHPCodeData;
            IProject iProject = PHPWorkspaceModelManager.getInstance().getProjectForModel(pHPProjectModel);
            if (iProject.isOpen()) {
                ImageDescriptor imageDescriptor;
                IWorkbenchAdapter iWorkbenchAdapter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iWorkbenchAdapter = (IWorkbenchAdapter)iProject.getAdapter((Class)clazz)) != null && (imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iProject)) != null) {
                    return imageDescriptor;
                }
                return DESC_OBJ_PROJECT;
            }
            return DESC_OBJ_PROJECT_CLOSED;
        }
        if (pHPCodeData instanceof IContainer) {
            return this.getPHPFolderIcon(pHPCodeData, n);
        }
        if (pHPCodeData instanceof PHPWorkspaceModelManager) {
            return PHPPluginImages.DESC_OBJS_PHP_MODEL;
        }
        Assert.isTrue((boolean)false, (String)("no image for this  Type: " + pHPCodeData));
        return null;
    }

    protected ImageDescriptor getPHPFolderIcon(Object object, int n) {
        IContainer iContainer = (IContainer)object;
        boolean bl = false;
        try {
            bl = iContainer.members().length > 0;
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        if (!bl) {
            // empty if block
        }
        if (!bl) {
            return PHPPluginImages.DESC_OBJS_PHPFOLDER_ROOT;
        }
        return PHPPluginImages.DESC_OBJS_PHPFOLDER_ROOT;
    }

    public void dispose() {
    }

    private int computePHPAdornmentFlags(PHPCodeData pHPCodeData, int n) {
        int n2 = 0;
        if (PHPElementImageProvider.showOverlayIcons(n)) {
            int n3 = -1;
            if (pHPCodeData instanceof PHPFunctionData) {
                PHPFunctionData pHPFunctionData = (PHPFunctionData)pHPCodeData;
                n3 = pHPFunctionData.getModifiers();
            } else if (pHPCodeData instanceof PHPConstantData || pHPCodeData instanceof PHPClassConstData) {
                n2 |= 2;
            } else if (pHPCodeData instanceof PHPClassData) {
                PHPClassData pHPClassData = (PHPClassData)pHPCodeData;
                n3 = pHPClassData.getModifiers();
            } else if (pHPCodeData instanceof PHPClassVarData) {
                PHPClassVarData pHPClassVarData = (PHPClassVarData)pHPCodeData;
                n3 = pHPClassVarData.getModifiers();
            }
            if (n3 != -1) {
                n2 = this.computeAdornments(n3, n2);
            }
        }
        return n2;
    }

    private int computeAdornments(int n, int n2) {
        if (PHPModifier.isAbstract((int)n)) {
            n2 |= 4;
        }
        if (PHPModifier.isFinal((int)n)) {
            n2 |= 8;
        }
        if (PHPModifier.isStatic((int)n)) {
            n2 |= 1;
        }
        return n2;
    }

    public static ImageDescriptor getMethodImageDescriptor(int n) {
        if (PHPModifier.isProtected((int)n)) {
            return PHPPluginImages.DESC_MISC_PROTECTED;
        }
        if (PHPModifier.isPrivate((int)n)) {
            return PHPPluginImages.DESC_MISC_PRIVATE;
        }
        return PHPPluginImages.DESC_MISC_PUBLIC;
    }

    public static ImageDescriptor getFieldImageDescriptor(int n) {
        if (PHPModifier.isProtected((int)n)) {
            return PHPPluginImages.DESC_FIELD_PROTECTED;
        }
        if (PHPModifier.isPrivate((int)n)) {
            return PHPPluginImages.DESC_FIELD_PRIVATE;
        }
        return PHPPluginImages.DESC_FIELD_PUBLIC;
    }

    public static ImageDescriptor getTypeImageDescriptor(int n) {
        return PHPElementImageProvider.getClassImageDescriptor(n);
    }

    public static Image getDecoratedImage(ImageDescriptor imageDescriptor, int n, Point point) {
        return PHPUiPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new PHPElementImageDescriptor(imageDescriptor, n, point));
    }

    private static ImageDescriptor getClassImageDescriptor(int n) {
        if (PHPModifier.isInterface((int)n)) {
            return PHPPluginImages.DESC_OBJS_INTERFACE;
        }
        return PHPPluginImages.DESC_OBJS_CLASS;
    }
}

