/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.php.internal.core.ast.binding.Attribute;
import org.eclipse.php.internal.core.ast.binding.ProgramScope;
import org.eclipse.php.internal.core.ast.binding.Scope;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;

public abstract class ScopeBase
implements Scope {
    public final int start;
    public int length;
    public final ProgramScope programScope;
    public final Entry symbolTable;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.internal.core.ast.binding.ScopeBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ScopeBase(int n, ProgramScope programScope) {
        this(n, programScope, false);
    }

    public ScopeBase(int n, ProgramScope programScope, boolean bl) {
        if (!$assertionsDisabled && programScope == null) {
            throw new AssertionError();
        }
        this.start = n;
        this.programScope = programScope;
        this.symbolTable = bl ? new CompositeEntry() : new EntryBase();
    }

    public Attribute probe(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        return this.symbolTable.getAttribute(string);
    }

    public Attribute lookup(VariableBase variableBase) {
        if (!$assertionsDisabled && variableBase == null) {
            throw new AssertionError();
        }
        return Attribute.NULL_ATTRIBUTE;
    }

    public void insertIdentifier(String string, Attribute attribute) {
        if (!($assertionsDisabled || string != null && attribute != null)) {
            throw new AssertionError();
        }
        if (this.symbolTable.containsAttribute(string)) {
            throw new IllegalArgumentException();
        }
        this.symbolTable.setAttribute(string, attribute);
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, "");
        return stringBuffer.toString();
    }

    protected void appendInterval(StringBuffer stringBuffer) {
        stringBuffer.append(" start='").append(this.start).append("' length='").append(this.length).append("'");
    }

    public void toString(StringBuffer stringBuffer, String string) {
        this.symbolTable.appendEntry(stringBuffer, string);
    }

    private static class CompositeEntry
    implements Entry {
        public final Map entryMap = new HashMap(2);
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.php.internal.core.ast.binding.ScopeBase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public boolean addEntry(String string, Attribute attribute) {
            if (!($assertionsDisabled || string != null && attribute != null)) {
                throw new AssertionError();
            }
            Attribute attribute2 = this.entryMap.put(string, attribute);
            return attribute2 == null;
        }

        public Attribute getAttribute(String string) {
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            return (Attribute)this.entryMap.get(string);
        }

        public boolean containsAttribute(String string) {
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            return (Attribute)this.entryMap.get(string) != null;
        }

        public boolean setAttribute(String string, Attribute attribute) {
            if (!($assertionsDisabled || string != null && attribute != null)) {
                throw new AssertionError();
            }
            Attribute attribute2 = this.entryMap.put(string, attribute);
            return attribute2 == null;
        }

        public void appendEntry(StringBuffer stringBuffer, String string) {
            Iterator iterator = this.entryMap.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n").append("\t").append(string).append("<Entry");
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                Attribute attribute = (Attribute)entry.getKey();
                stringBuffer.append(" key='").append(string2).append("' value='").append(attribute.toString()).append("'");
                stringBuffer.append("/>");
            }
        }
    }

    private static interface Entry {
        public boolean setAttribute(String var1, Attribute var2);

        public Attribute getAttribute(String var1);

        public boolean containsAttribute(String var1);

        public void appendEntry(StringBuffer var1, String var2);
    }

    private static class EntryBase
    implements Entry {
        public String name;
        public Attribute attribute;

        private EntryBase() {
        }

        public boolean setAttribute(String string, Attribute attribute) {
            this.name = string;
            this.attribute = attribute;
            return false;
        }

        public void appendEntry(StringBuffer stringBuffer, String string) {
            stringBuffer.append("\n").append("\t").append(string).append("<Entry");
            stringBuffer.append(" key='").append(this.name).append("' value='").append(this.attribute.toString()).append("'");
            stringBuffer.append("/>");
        }

        public Attribute getAttribute(String string) {
            return this.name.equals(string) ? this.attribute : null;
        }

        public boolean containsAttribute(String string) {
            return string.equals(this.name);
        }
    }
}

