/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;

public class DebugMessagesRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugMessages";
    private static final String MESSAGE_TAG = "message";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String HANDLER_ATTRIBUTE = "handler";
    private IntHashtable messagesHash = new IntHashtable(50);
    private Dictionary messagesTypes = new Hashtable();
    private IntHashtable handlers = new IntHashtable();
    private static DebugMessagesRegistry instance = null;

    private DebugMessagesRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            final IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (MESSAGE_TAG.equals(iConfigurationElement.getName())) {
                final IDebugMessage[] iDebugMessageArray = new IDebugMessage[1];
                SafeRunnable.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.internal.debug.core.phpDebugMessages"){

                    public void run() throws Exception {
                        iDebugMessageArray[0] = (IDebugMessage)iConfigurationElement.createExecutableExtension(DebugMessagesRegistry.CLASS_ATTRIBUTE);
                    }
                });
                if (iDebugMessageArray[0] != null && !this.messagesHash.containsKey(iDebugMessageArray[0].getType())) {
                    this.messagesHash.put(iDebugMessageArray[0].getType(), (Object)iDebugMessageArray[0]);
                    this.messagesTypes.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new Integer(iDebugMessageArray[0].getType()));
                    String string = iConfigurationElement.getAttribute(HANDLER_ATTRIBUTE);
                    if (string != null && !this.handlers.containsKey(iDebugMessageArray[0].getType())) {
                        this.handlers.put(iDebugMessageArray[0].getType(), (Object)new DebugMessageHandlerFactory(iConfigurationElement));
                    }
                }
            }
            ++n;
        }
    }

    private IntHashtable getMessages() {
        return this.messagesHash;
    }

    private Dictionary getMessagesTypes() {
        return this.messagesTypes;
    }

    private IntHashtable getHandlers() {
        return this.handlers;
    }

    private static DebugMessagesRegistry getInstance() {
        if (instance == null) {
            instance = new DebugMessagesRegistry();
        }
        return instance;
    }

    public static IDebugMessage getMessage(int n) throws Exception {
        IntHashtable intHashtable = DebugMessagesRegistry.getInstance().getMessages();
        if (intHashtable.containsKey(n)) {
            return (IDebugMessage)intHashtable.get(n).getClass().newInstance();
        }
        throw new Exception("Can't find message for ID = " + n + " in Debug messages registry!");
    }

    public static IDebugMessage getMessage(String string) throws Exception {
        return (IDebugMessage)DebugMessagesRegistry.getInstance().getMessages().get(((Integer)DebugMessagesRegistry.getInstance().getMessagesTypes().get(string)).intValue()).getClass().newInstance();
    }

    public static IDebugMessageHandler getHandler(IDebugMessage iDebugMessage) {
        return ((DebugMessageHandlerFactory)DebugMessagesRegistry.getInstance().getHandlers().get(iDebugMessage.getType())).createHandler();
    }

    class DebugMessageHandlerFactory {
        IDebugMessageHandler handler;
        IConfigurationElement element;

        public DebugMessageHandlerFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IDebugMessageHandler createHandler() {
            if (this.handler == null) {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(this, "Error creation handler for extension-point org.eclipse.php.internal.debug.core.phpDebugMessages"){
                    final /* synthetic */ DebugMessageHandlerFactory this$1;
                    {
                        this.this$1 = debugMessageHandlerFactory;
                        super(string);
                    }

                    public void run() throws Exception {
                        this.this$1.handler = (IDebugMessageHandler)this.this$1.element.createExecutableExtension("handler");
                    }
                });
            }
            return this.handler;
        }
    }
}

