/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.wst.wsdl.WSDLPlugin;
import org.eclipse.wst.wsdl.util.WSDLDiagnosticImpl;
import org.eclipse.wst.wsdl.util.WSDLDiagnosticSeverity;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class WSDLParser
extends DefaultHandler
implements LexicalHandler {
    private static final String END_COLUMN = "endColumn";
    private static final String END_LINE = "endLine";
    private static final String START_COLUMN = "startColumn";
    private static final String START_LINE = "startLine";
    protected static final Map userDataMap = Collections.synchronizedMap(new WeakHashMap());
    protected int column;
    List diagnostics = new ArrayList();
    protected Document document;
    protected Element element;
    protected String encoding;
    protected boolean inSchema;
    protected int line;
    protected Locator locator;
    protected SAXParser saxParser;
    protected Stack stack = new Stack();

    public static int getEndColumn(Node node) {
        Integer result = (Integer)WSDLParser.getUserData(node).get(END_COLUMN);
        return result == null ? 1 : result;
    }

    public static int getEndLine(Node node) {
        Integer result = (Integer)WSDLParser.getUserData(node).get(END_LINE);
        return result == null ? 1 : result;
    }

    public static int getStartColumn(Node node) {
        Integer result = (Integer)WSDLParser.getUserData(node).get(START_COLUMN);
        return result == null ? 1 : result;
    }

    public static int getStartLine(Node node) {
        Integer result = (Integer)WSDLParser.getUserData(node).get(START_LINE);
        return result == null ? 1 : result;
    }

    public static Map getUserData(Node node) {
        HashMap result = (HashMap)userDataMap.get(node);
        if (result == null) {
            result = new HashMap();
            userDataMap.put(node, result);
        }
        return result;
    }

    public WSDLParser() {
        this.saxParser = this.createSAXParser();
    }

    public void characters(char[] characters, int start, int length) throws SAXException {
        Text textNode = this.document.createTextNode(new String(characters, start, length));
        this.element.appendChild(textNode);
        this.saveLocation();
    }

    public void comment(char[] characters, int start, int length) throws SAXException {
        Comment commentNode = this.document.createComment(new String(characters, start, length));
        if (this.element == null) {
            this.document.appendChild(commentNode);
        } else {
            this.element.appendChild(commentNode);
        }
        this.saveLocation();
    }

    private Document createDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.newDocument();
        }
        catch (ParserConfigurationException exception) {
            WSDLPlugin.INSTANCE.log(exception);
            return null;
        }
    }

    private SAXParser createSAXParser() {
        SAXParser saxParser = null;
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(false);
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            saxParser = saxParserFactory.newSAXParser();
            saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        }
        catch (SAXException exception) {
            this.fatalError(exception);
        }
        catch (ParserConfigurationException exception) {
            this.fatalError(exception);
        }
        return saxParser;
    }

    public void endCDATA() {
    }

    public void endDocument() {
        this.element = null;
        this.saveLocation();
        this.locator = null;
    }

    public void endDTD() {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.saveLocation();
        Map extendedAttributes = null;
        extendedAttributes = this.inSchema ? XSDParser.getUserData((Node)this.element) : WSDLParser.getUserData(this.element);
        extendedAttributes.put(END_LINE, new Integer(this.line));
        extendedAttributes.put(END_COLUMN, new Integer(this.column));
        if (this.isSchemaElement(uri, localName)) {
            this.inSchema = false;
        }
        this.element = (Element)this.stack.pop();
    }

    public void endEntity(String name) {
    }

    public void error(SAXParseException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.ERROR_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_IOError_message", new Object[]{exception.getMessage()}));
        diagnostic.setLine(exception.getLineNumber());
        diagnostic.setColumn(exception.getColumnNumber());
        this.diagnostics.add(diagnostic);
    }

    protected void fatalError(IOException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.FATAL_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_IOError_message", new Object[]{exception.getMessage()}));
        this.diagnostics.add(diagnostic);
    }

    protected void fatalError(ParserConfigurationException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.FATAL_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.diagnostics.add(diagnostic);
    }

    public void fatalError(SAXException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.FATAL_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        this.diagnostics.add(diagnostic);
    }

    public void fatalError(SAXParseException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.FATAL_LITERAL);
        diagnostic.setMessage(WSDLPlugin.INSTANCE.getString("_UI_ParserError_message", new Object[]{exception.getMessage()}));
        diagnostic.setLine(exception.getLineNumber());
        diagnostic.setColumn(exception.getColumnNumber());
        this.diagnostics.add(diagnostic);
    }

    public Collection getDiagnostics() {
        return this.diagnostics;
    }

    public Document getDocument() {
        return this.document;
    }

    private boolean isSchemaElement(String uri, String localName) {
        return uri.equals("http://www.w3.org/2001/XMLSchema") && localName.equals("schema");
    }

    public void parse(InputSource inputSource) {
        try {
            this.saxParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (IOException exception) {
            this.fatalError(exception);
        }
        catch (SAXException exception) {
            this.fatalError(exception);
        }
    }

    public void parse(InputStream inputStream) {
        try {
            this.saxParser.parse(new InputSource(inputStream), (DefaultHandler)this);
        }
        catch (IOException exception) {
            this.fatalError(exception);
        }
        catch (SAXException exception) {
            this.fatalError(exception);
        }
    }

    public void processingInstruction(String target, String data) {
        ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(target, data);
        if (this.stack.isEmpty()) {
            this.document.appendChild(processingInstruction);
        } else {
            this.element.appendChild(processingInstruction);
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource inputSource;
        if ("-//W3C//DTD XMLSCHEMA 200102//EN".equalsIgnoreCase(publicId)) {
            inputSource = new InputSource(XSDPlugin.INSTANCE.getBaseURL() + "cache/www.w3.org/2001/XMLSchema.dtd");
            inputSource.setPublicId(publicId);
        } else if (systemId != null && systemId.startsWith("file://bundleentry:")) {
            inputSource = new InputSource(systemId.substring(7));
            inputSource.setPublicId(publicId);
        } else {
            try {
                inputSource = super.resolveEntity(publicId, systemId);
            }
            catch (IOException exception) {
                throw new SAXException(exception);
            }
        }
        return inputSource;
    }

    protected void saveLocation() {
        this.line = this.locator.getLineNumber();
        this.column = this.locator.getColumnNumber();
        if (this.column == -1) {
            this.column = 1;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    public void startCDATA() {
    }

    public void startDocument() {
        this.saveLocation();
        this.document = this.createDocument();
    }

    public void startDTD(String name, String publicId, String systemId) {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.inSchema) {
            this.inSchema = this.isSchemaElement(uri, localName);
        }
        Element newElement = this.document.createElementNS(uri, qName);
        int index = 0;
        int count = attributes.getLength();
        while (index < count) {
            String attributeURI = attributes.getURI(index);
            String attributeQName = attributes.getQName(index);
            String attributeValue = attributes.getValue(index);
            if (attributeQName.equals("xmlns") || attributeQName.startsWith("xmlns:")) {
                attributeURI = "http://www.w3.org/2000/xmlns/";
            } else if ("".equals(attributeURI)) {
                attributeURI = null;
            }
            newElement.setAttributeNS(attributeURI, attributeQName, attributeValue);
            ++index;
        }
        if (this.stack.isEmpty()) {
            this.document.appendChild(newElement);
        } else {
            this.element.appendChild(newElement);
        }
        this.stack.push(this.element);
        this.element = newElement;
        Map extendedAttributes = null;
        extendedAttributes = this.inSchema ? XSDParser.getUserData((Node)this.element) : WSDLParser.getUserData(this.element);
        extendedAttributes.put(START_LINE, new Integer(this.line));
        extendedAttributes.put(START_COLUMN, new Integer(this.column));
        this.saveLocation();
    }

    public void startEntity(String name) {
    }

    public void warning(SAXParseException exception) {
        WSDLDiagnosticImpl diagnostic = new WSDLDiagnosticImpl();
        diagnostic.setSeverity(WSDLDiagnosticSeverity.WARNING_LITERAL);
        diagnostic.setMessage("DOM:" + exception.getMessage());
        diagnostic.setLine(exception.getLineNumber());
        diagnostic.setColumn(exception.getColumnNumber());
        this.diagnostics.add(diagnostic);
    }
}

