/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.launching.ApplicationFileSelectionDialog;
import org.eclipse.php.internal.debug.ui.launching.ProjectSelectionDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.dialogs.ResourceSorter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LaunchUtilities {
    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell() {
        return LaunchUtilities.getStandardDisplay().getActiveShell();
    }

    public static void openError(final String string) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = LaunchUtilities.getShell();
                MessageDialog.openError((Shell)shell, (String)PHPDebugUIMessages.LaunchUtilities_error, (String)string);
            }
        });
    }

    public static void openError(final String string, final IStatus iStatus) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = LaunchUtilities.getShell();
                ErrorDialog.openError((Shell)shell, (String)PHPDebugUIMessages.LaunchUtilities_error, (String)string, (IStatus)iStatus);
            }
        });
    }

    public static void openError(Shell shell, String string) {
        MessageDialog.openError((Shell)shell, (String)PHPDebugUIMessages.LaunchUtilities_error, (String)string);
    }

    public static void openError(Shell shell, String string, IStatus iStatus) {
        ErrorDialog.openError((Shell)shell, (String)PHPDebugUIMessages.LaunchUtilities_error, (String)string, (IStatus)iStatus);
    }

    public static String getProjectFromDialog(Shell shell, String[] stringArray) {
        ProjectSelectionDialog projectSelectionDialog = new ProjectSelectionDialog(shell, stringArray, PHPDebugUIMessages.LaunchUtilities_projects, PHPDebugUIMessages.LaunchUtilities_selectProject);
        projectSelectionDialog.open();
        Object[] objectArray = projectSelectionDialog.getResult();
        String string = null;
        if (objectArray != null && objectArray.length > 0) {
            Object object = objectArray[0];
            IPath iPath = null;
            if (object instanceof IPath) {
                iPath = (IPath)objectArray[0];
            } else if (object instanceof IProject) {
                iPath = ((IProject)object).getFullPath();
            }
            string = iPath.makeRelative().toString();
        }
        return string;
    }

    public static IResource getFileFromDialog(IProject iProject, Shell shell, String[] stringArray, String[] stringArray2, boolean bl) {
        Object[] objectArray;
        LaunchUtilities launchUtilities;
        LaunchUtilities launchUtilities2 = launchUtilities = new LaunchUtilities();
        launchUtilities2.getClass();
        ApplicationFileSelectionDialog applicationFileSelectionDialog = new ApplicationFileSelectionDialog(shell, (ILabelProvider)launchUtilities2.new WebLaunchLabelProvider(), PHPDebugUIMessages.LaunchUtilities_selectFile, PHPDebugUIMessages.LaunchUtilities_selectProjectFile, stringArray, stringArray2, false, bl);
        if (iProject != null) {
            applicationFileSelectionDialog.setInput(iProject);
            applicationFileSelectionDialog.setInitialSelection(iProject);
        } else {
            objectArray = ResourcesPlugin.getWorkspace().getRoot();
            applicationFileSelectionDialog.setInput(objectArray);
            applicationFileSelectionDialog.setInitialSelection(objectArray);
        }
        applicationFileSelectionDialog.setAllowMultiple(false);
        applicationFileSelectionDialog.setSorter((ViewerSorter)new ResourceSorter(2));
        applicationFileSelectionDialog.open();
        if (applicationFileSelectionDialog.getReturnCode() == 0) {
            objectArray = applicationFileSelectionDialog.getResult();
            Object object = objectArray[0];
            return (IResource)object;
        }
        return null;
    }

    private class WebLaunchLabelProvider
    extends WorkbenchLabelProvider {
        private WebLaunchLabelProvider() {
        }

        protected String decorateText(String string, Object object) {
            if (object instanceof IFile) {
                IFile iFile = (IFile)object;
                String string2 = iFile.getName();
                return string2;
            }
            return string;
        }
    }
}

