/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class MergeSourceViewer
extends StructuredTextViewer
implements ISelectionChangedListener,
ITextListener,
IMenuListener {
    public static final String UNDO_ID = "undo";
    public static final String REDO_ID = "redo";
    public static final String CUT_ID = "cut";
    public static final String COPY_ID = "copy";
    public static final String PASTE_ID = "paste";
    public static final String DELETE_ID = "delete";
    public static final String SELECT_ALL_ID = "selectAll";
    public static final String SAVE_ID = "save";
    private ResourceBundle fResourceBundle;
    private Position fRegion;
    private boolean fEnabled = true;
    private HashMap fActions = new HashMap();
    private IDocument fRememberedDocument;
    private boolean fAddSaveAction = true;

    public MergeSourceViewer(Composite composite, ResourceBundle resourceBundle) {
        this(composite, 0, resourceBundle);
    }

    public MergeSourceViewer(Composite composite, int n, ResourceBundle resourceBundle) {
        super(composite, null, null, false, n | 0x100 | 0x200);
        this.fResourceBundle = resourceBundle;
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        StyledText styledText = this.getTextWidget();
        styledText.setMenu(menuManager.createContextMenu((Control)styledText));
    }

    public void rememberDocument(IDocument iDocument) {
        this.fRememberedDocument = iDocument;
    }

    public IDocument getRememberedDocument() {
        return this.fRememberedDocument;
    }

    public void hideSaveAction() {
        this.fAddSaveAction = false;
    }

    public void setFont(Font font) {
        StyledText styledText = this.getTextWidget();
        if (styledText != null) {
            styledText.setFont(font);
        }
    }

    public void setBackgroundColor(Color color) {
        StyledText styledText = this.getTextWidget();
        if (styledText != null) {
            styledText.setBackground(color);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.fEnabled) {
            this.fEnabled = bl;
            StyledText styledText = this.getTextWidget();
            if (styledText != null) {
                styledText.setEnabled(bl);
                Display display = styledText.getDisplay();
                styledText.setBackground(bl ? display.getSystemColor(25) : null);
            }
        }
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public void setRegion(Position position) {
        this.fRegion = position;
    }

    public Position getRegion() {
        return this.fRegion;
    }

    public boolean isControlOkToUse() {
        StyledText styledText = this.getTextWidget();
        return styledText != null && !styledText.isDisposed();
    }

    public void setSelection(Position position) {
        if (position != null) {
            this.setSelectedRange(position.getOffset(), position.getLength());
        }
    }

    public void setLineBackground(Position position, Color color) {
        StyledText styledText = this.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            Point point = new Point(0, 0);
            this.getLineRange(position, point);
            point.x -= this.getDocumentRegionOffset();
            try {
                styledText.setLineBackground(point.x, point.y, color);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void resetLineBackground() {
        StyledText styledText = this.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            int n = this.getLineCount();
            styledText.setLineBackground(0, n, null);
        }
    }

    public int getLineCount() {
        IRegion iRegion = this.getVisibleRegion();
        int n = iRegion.getLength();
        if (n == 0) {
            return 0;
        }
        IDocument iDocument = this.getDocument();
        int n2 = 0;
        int n3 = 0;
        int n4 = iRegion.getOffset();
        try {
            n2 = iDocument.getLineOfOffset(n4);
        }
        catch (BadLocationException badLocationException) {}
        try {
            n3 = iDocument.getLineOfOffset(n4 + n);
        }
        catch (BadLocationException badLocationException) {}
        return n3 - n2 + 1;
    }

    public int getViewportLines() {
        StyledText styledText = this.getTextWidget();
        Rectangle rectangle = styledText.getClientArea();
        if (!rectangle.isEmpty()) {
            return rectangle.height / styledText.getLineHeight();
        }
        return 0;
    }

    public int getViewportHeight() {
        StyledText styledText = this.getTextWidget();
        Rectangle rectangle = styledText.getClientArea();
        if (!rectangle.isEmpty()) {
            return rectangle.height;
        }
        return 0;
    }

    public int getDocumentRegionOffset() {
        int n = this.getVisibleRegion().getOffset();
        IDocument iDocument = this.getDocument();
        if (iDocument != null) {
            try {
                return iDocument.getLineOfOffset(n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    public int getVerticalScrollOffset() {
        StyledText styledText = this.getTextWidget();
        int n = styledText.getLineHeight();
        return this.getTopInset() - (this.getDocumentRegionOffset() * n + styledText.getTopPixel());
    }

    public Point getLineRange(Position position, Point point) {
        IDocument iDocument = this.getDocument();
        if (position == null || iDocument == null) {
            point.x = 0;
            point.y = 0;
            return point;
        }
        int n = position.getOffset();
        int n2 = position.getLength();
        int n3 = 0;
        try {
            n3 = iDocument.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {}
        int n4 = 0;
        if (n2 != 0) {
            int n5 = 0;
            try {
                n5 = iDocument.getLineOfOffset(n + n2 - 1);
            }
            catch (BadLocationException badLocationException) {}
            n4 = n5 - n3 + 1;
        }
        point.x = n3;
        point.y = n4;
        return point;
    }

    public void vscroll(int n) {
        int n2;
        int n3 = this.getLineCount();
        if (n3 > (n2 = this.getViewportLines())) {
            int n4;
            if (n < 0) {
                n = 0;
            }
            if ((n4 = this.getTopIndex()) != n) {
                this.setTopIndex(n + this.getDocumentRegionOffset());
            }
        }
    }

    public void addAction(String string, MergeViewerAction mergeViewerAction) {
        this.fActions.put(string, mergeViewerAction);
    }

    public MergeViewerAction getAction(String string) {
        MergeViewerAction mergeViewerAction = (MergeViewerAction)this.fActions.get(string);
        if (mergeViewerAction == null) {
            mergeViewerAction = this.createAction(string);
            if (mergeViewerAction == null) {
                return null;
            }
            if (mergeViewerAction.isContentDependent()) {
                this.addTextListener(this);
            }
            if (mergeViewerAction.isSelectionDependent()) {
                this.addSelectionChangedListener(this);
            }
            Utilities.initAction((IAction)mergeViewerAction, (ResourceBundle)this.fResourceBundle, (String)("action." + string + "."));
            this.fActions.put(string, mergeViewerAction);
        }
        if (mergeViewerAction.isEditableDependent() && !this.isEditable()) {
            return null;
        }
        return mergeViewerAction;
    }

    protected MergeViewerAction createAction(String string) {
        if (UNDO_ID.equals(string)) {
            return new TextOperationAction(1, true, false, true);
        }
        if (REDO_ID.equals(string)) {
            return new TextOperationAction(2, true, false, true);
        }
        if (CUT_ID.equals(string)) {
            return new TextOperationAction(3, true, true, false);
        }
        if (COPY_ID.equals(string)) {
            return new TextOperationAction(4, false, true, false);
        }
        if (PASTE_ID.equals(string)) {
            return new TextOperationAction(5, true, false, false);
        }
        if (DELETE_ID.equals(string)) {
            return new TextOperationAction(6, true, false, false);
        }
        if (SELECT_ALL_ID.equals(string)) {
            return new TextOperationAction(7, false, false, false);
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        Iterator iterator = this.fActions.values().iterator();
        while (iterator.hasNext()) {
            MergeViewerAction mergeViewerAction = (MergeViewerAction)iterator.next();
            if (!mergeViewerAction.isSelectionDependent()) continue;
            mergeViewerAction.update();
        }
    }

    public void textChanged(TextEvent textEvent) {
        Iterator iterator = this.fActions.values().iterator();
        while (iterator.hasNext()) {
            MergeViewerAction mergeViewerAction = (MergeViewerAction)iterator.next();
            if (!mergeViewerAction.isContentDependent()) continue;
            mergeViewerAction.update();
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator(UNDO_ID));
        this.addMenu(iMenuManager, UNDO_ID);
        this.addMenu(iMenuManager, REDO_ID);
        iMenuManager.add((IContributionItem)new Separator("ccp"));
        this.addMenu(iMenuManager, CUT_ID);
        this.addMenu(iMenuManager, COPY_ID);
        this.addMenu(iMenuManager, PASTE_ID);
        this.addMenu(iMenuManager, DELETE_ID);
        this.addMenu(iMenuManager, SELECT_ALL_ID);
        iMenuManager.add((IContributionItem)new Separator("edit"));
        iMenuManager.add((IContributionItem)new Separator("find"));
        iMenuManager.add((IContributionItem)new Separator(SAVE_ID));
        if (this.fAddSaveAction) {
            this.addMenu(iMenuManager, SAVE_ID);
        }
        iMenuManager.add((IContributionItem)new Separator("rest"));
    }

    private void addMenu(IMenuManager iMenuManager, String string) {
        MergeViewerAction mergeViewerAction = this.getAction(string);
        if (mergeViewerAction != null) {
            iMenuManager.add((IAction)mergeViewerAction);
        }
    }

    protected void handleDispose() {
        this.removeTextListener(this);
        this.removeSelectionChangedListener(this);
        super.handleDispose();
    }

    class TextOperationAction
    extends MergeViewerAction {
        private int fOperationCode;

        TextOperationAction(int n, boolean bl, boolean bl2, boolean bl3) {
            super(bl, bl2, bl3);
            this.fOperationCode = n;
            this.update();
        }

        public void run() {
            if (this.isEnabled()) {
                MergeSourceViewer.this.doOperation(this.fOperationCode);
            }
        }

        public boolean isEnabled() {
            return this.fOperationCode != -1 && MergeSourceViewer.this.canDoOperation(this.fOperationCode);
        }

        public void update() {
            this.setEnabled(this.isEnabled());
        }
    }
}

