/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.env.AbstractCompilationEnv;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.env.EclipseRoundCompleteEvent;
import org.eclipse.jdt.apt.core.internal.env.ReconcileEnv;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.ReconcileContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTDispatchRunnable
implements IWorkspaceRunnable {
    private static final BuildContext[] NO_FILES_TO_PROCESS = new BuildContext[0];
    private BuildContext[] _filesWithAnnotation = null;
    private BuildContext[] _filesWithoutAnnotation = null;
    private final AptProject _aptProject;
    private final Map<AnnotationProcessorFactory, FactoryPath.Attributes> _factories;
    private final Set<AnnotationProcessorFactory> _dispatchedBatchFactories;
    private Set<AnnotationProcessorFactory> _currentDispatchBatchFactories = Collections.emptySet();
    private final boolean _isFullBuild;

    public static Set<AnnotationProcessorFactory> runAPTDuringBuild(BuildContext[] filesWithAnnotations, BuildContext[] filesWithoutAnnotations, AptProject aptProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories, Set<AnnotationProcessorFactory> dispatchedBatchFactories, boolean isFullBuild) {
        if (filesWithAnnotations == null) {
            filesWithAnnotations = NO_FILES_TO_PROCESS;
        }
        APTDispatchRunnable runnable = new APTDispatchRunnable(filesWithAnnotations, filesWithoutAnnotations, aptProject, factories, dispatchedBatchFactories, isFullBuild);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            workspace.run((IWorkspaceRunnable)runnable, (ISchedulingRule)aptProject.getJavaProject().getResource(), 1, null);
        }
        catch (CoreException ce) {
            AptPlugin.log(ce, "Could not run APT");
        }
        return runnable._currentDispatchBatchFactories;
    }

    public static void runAPTDuringReconcile(ReconcileContext reconcileContext, AptProject aptProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories) {
        APTDispatchRunnable runnable = new APTDispatchRunnable(aptProject, factories);
        runnable.reconcile(reconcileContext, aptProject.getJavaProject());
    }

    private APTDispatchRunnable(BuildContext[] filesWithAnnotation, BuildContext[] filesWithoutAnnotation, AptProject aptProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories, Set<AnnotationProcessorFactory> dispatchedBatchFactories, boolean isFullBuild) {
        assert (filesWithAnnotation != null) : "missing files";
        this._filesWithAnnotation = filesWithAnnotation;
        this._filesWithoutAnnotation = filesWithoutAnnotation;
        this._aptProject = aptProject;
        this._factories = factories;
        this._dispatchedBatchFactories = dispatchedBatchFactories;
        this._isFullBuild = isFullBuild;
    }

    private APTDispatchRunnable(AptProject aptProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories) {
        this._aptProject = aptProject;
        this._factories = factories;
        this._isFullBuild = false;
        this._dispatchedBatchFactories = Collections.emptySet();
    }

    private void reconcile(final ReconcileContext reconcileContext, IJavaProject javaProject) {
        if (this._factories.size() == 0) {
            if (AptPlugin.DEBUG) {
                APTDispatchRunnable.trace("runAPT: leaving early because there are no factories", null);
            }
            return;
        }
        AbstractCompilationEnv.EnvCallback callback = new AbstractCompilationEnv.EnvCallback(){

            public void run(AbstractCompilationEnv env) {
                APTDispatchRunnable.this.dispatchToFileBasedProcessor(env);
                List<? extends CategorizedProblem> problemList = env.getProblems();
                int numProblems = problemList.size();
                if (numProblems > 0) {
                    CategorizedProblem[] aptCatProblems = new CategorizedProblem[numProblems];
                    reconcileContext.putProblems("org.eclipse.jdt.apt.core.compile.problem", problemList.toArray(aptCatProblems));
                }
                env.close();
            }
        };
        AbstractCompilationEnv.newReconcileEnv(reconcileContext, callback);
    }

    public void run(IProgressMonitor monitor) {
        this.build();
    }

    private boolean shouldBuild() {
        int totalFiles;
        if ((this._factories == null || this._factories.size() == 0) && this._dispatchedBatchFactories.isEmpty()) {
            return false;
        }
        int n = totalFiles = this._filesWithAnnotation == null ? 0 : this._filesWithAnnotation.length;
        return totalFiles > 0 || !this._dispatchedBatchFactories.isEmpty();
    }

    private void build() {
        if (!this.shouldBuild()) {
            if (AptPlugin.DEBUG) {
                String msg = (this._factories == null || this._factories.size() == 0) && this._dispatchedBatchFactories.isEmpty() ? "no AnnotationProcessoryFactory instances registered." : "no files to dispatch to.";
                APTDispatchRunnable.trace("run():  leaving early because there are " + msg, null);
            }
            this.cleanupAllGeneratedFiles();
        } else {
            assert (this._filesWithAnnotation != null) : "should never be invoked unless we are in build mode!";
            AbstractCompilationEnv.EnvCallback buildCallback = new AbstractCompilationEnv.EnvCallback(){

                public void run(AbstractCompilationEnv env) {
                    APTDispatchRunnable.this.build((BuildEnv)env);
                }
            };
            BuildEnv.newBuildEnv(this._filesWithAnnotation, this._filesWithoutAnnotation, this._aptProject.getJavaProject(), buildCallback);
        }
    }

    private boolean hasBatchFactory() {
        for (FactoryPath.Attributes attr : this._factories.values()) {
            if (!attr.runInBatchMode()) continue;
            return true;
        }
        return false;
    }

    private boolean shouldDispatchToBatchProcessor(AbstractCompilationEnv processorEnv) {
        return this._isFullBuild && processorEnv.getPhase() == Phase.BUILD && this.hasBatchFactory();
    }

    private void runAPTInFileBasedMode(BuildEnv processorEnv, Map<IFile, Set<IFile>> lastGeneratedFiles) {
        BuildContext[] cpResults = processorEnv.getFilesWithAnnotation();
        GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager();
        BuildContext[] buildContextArray = cpResults;
        int n = 0;
        int n2 = buildContextArray.length;
        while (n < n2) {
            BuildContext curResult = buildContextArray[n];
            processorEnv.beginFileProcessing(curResult);
            this.dispatchToFileBasedProcessor(processorEnv);
            IFile curFile = curResult.getFile();
            this.reportResult(curResult, lastGeneratedFiles.get(curFile), processorEnv.getAllGeneratedFiles(), processorEnv.getModifiedGeneratedFiles(), processorEnv.getProblems(), processorEnv.getTypeDependencies(), gfm, processorEnv);
            processorEnv.completedFileProcessing();
            ++n;
        }
    }

    private void reportResult(BuildContext curResult, Set<IFile> lastGeneratedFiles, Set<IFile> generatedFiles, Set<IFile> modifiedGeneratedFiles, List<? extends CategorizedProblem> problems, Set<String> deps, GeneratedFileManager gfm, BuildEnv processorEnv) {
        int numDeps;
        int numProblems;
        int numDeletedFiles;
        if (lastGeneratedFiles == null) {
            lastGeneratedFiles = Collections.emptySet();
        }
        if (generatedFiles == null) {
            generatedFiles = Collections.emptySet();
        }
        ArrayList<IFile> deletedFiles = new ArrayList<IFile>();
        this.cleanupNoLongerGeneratedFiles(curResult, lastGeneratedFiles, generatedFiles, gfm, processorEnv, deletedFiles);
        int numNewFiles = modifiedGeneratedFiles.size();
        if (numNewFiles > 0) {
            IFile[] newFilesArray = new IFile[numNewFiles];
            curResult.recordAddedGeneratedFiles(modifiedGeneratedFiles.toArray(newFilesArray));
        }
        if ((numDeletedFiles = deletedFiles.size()) > 0) {
            IFile[] deletedFilesArray = new IFile[numDeletedFiles];
            curResult.recordDeletedGeneratedFiles(deletedFiles.toArray(deletedFilesArray));
        }
        if ((numProblems = problems.size()) > 0) {
            CategorizedProblem[] catProblemsArray = new CategorizedProblem[numProblems];
            curResult.recordNewProblems(problems.toArray(catProblemsArray));
        }
        if ((numDeps = deps.size()) > 0) {
            String[] depsArray = new String[numDeps];
            curResult.recordDependencies(deps.toArray(depsArray));
        }
    }

    private void runAPTInMixedMode(Map<IFile, Set<IFile>> lastGeneratedFiles, BuildEnv processorEnv) {
        BuildContext[] cpResults = processorEnv.getFilesWithAnnotation();
        HashMap<BuildContext, Set<AnnotationTypeDeclaration>> file2AnnotationDecls = new HashMap<BuildContext, Set<AnnotationTypeDeclaration>>(cpResults.length * 4 / 3 + 1);
        Map<String, AnnotationTypeDeclaration> annotationDecls = processorEnv.getAllAnnotationTypes(file2AnnotationDecls);
        if (annotationDecls.isEmpty() && this._dispatchedBatchFactories.isEmpty()) {
            if (AptPlugin.DEBUG) {
                APTDispatchRunnable.trace("runAPT:  leaving early because annotationDecls is empty", processorEnv);
            }
            return;
        }
        if (AptPlugin.DEBUG) {
            APTDispatchRunnable.trace("annotations found " + annotationDecls.keySet(), processorEnv);
        }
        HashMap fileFactory2Annos = new HashMap(this._factories.size() * 4 / 3 + 1);
        HashMap<AnnotationProcessorFactory, Set<AnnotationTypeDeclaration>> batchFactory2Annos = new HashMap<AnnotationProcessorFactory, Set<AnnotationTypeDeclaration>>(this._factories.size() * 4 / 3 + 1);
        for (Map.Entry<AnnotationProcessorFactory, FactoryPath.Attributes> entry : this._factories.entrySet()) {
            AnnotationProcessorFactory factory = entry.getKey();
            Set<AnnotationTypeDeclaration> annotationTypes = APTDispatchRunnable.getFactorySupportedAnnotations(factory, annotationDecls);
            if (annotationTypes != null) {
                HashMap<AnnotationProcessorFactory, Set<AnnotationTypeDeclaration>> factory2Annos;
                boolean batch = entry.getValue().runInBatchMode();
                HashMap<AnnotationProcessorFactory, Set<AnnotationTypeDeclaration>> hashMap = factory2Annos = batch ? batchFactory2Annos : fileFactory2Annos;
                if (annotationTypes.size() == 0) {
                    annotationTypes = new HashSet<AnnotationTypeDeclaration>(annotationDecls.values());
                    factory2Annos.put(factory, annotationTypes);
                    annotationDecls.clear();
                    break;
                }
                factory2Annos.put(factory, annotationTypes);
            }
            if (annotationDecls.isEmpty()) break;
        }
        annotationDecls.isEmpty();
        if (!batchFactory2Annos.isEmpty() || this._dispatchedBatchFactories != null && !this._dispatchedBatchFactories.isEmpty()) {
            processorEnv.beginBatchProcessing();
            if (!batchFactory2Annos.isEmpty()) {
                this._currentDispatchBatchFactories = new LinkedHashSet<AnnotationProcessorFactory>();
                for (AnnotationProcessorFactory factory : this._factories.keySet()) {
                    AnnotationProcessor processor;
                    Set annotationTypes = (Set)batchFactory2Annos.get(factory);
                    if (annotationTypes == null || (processor = factory.getProcessorFor(annotationTypes, processorEnv)) == null) continue;
                    if (AptPlugin.DEBUG) {
                        APTDispatchRunnable.trace("runAPT: invoking batch processor " + processor.getClass().getName(), processorEnv);
                    }
                    this._currentDispatchBatchFactories.add(factory);
                    processor.process();
                }
            }
            for (AnnotationProcessorFactory prevRoundFactory : this._dispatchedBatchFactories) {
                AnnotationProcessor processor;
                if (this._currentDispatchBatchFactories.contains(prevRoundFactory) || (processor = prevRoundFactory.getProcessorFor(Collections.<AnnotationTypeDeclaration>emptySet(), processorEnv)) == null) continue;
                if (AptPlugin.DEBUG) {
                    APTDispatchRunnable.trace("runAPT: invoking batch processor " + processor.getClass().getName(), processorEnv);
                }
                processor.process();
            }
            BuildContext firstResult = null;
            if (cpResults.length > 0) {
                firstResult = cpResults[0];
            } else {
                BuildContext[] others = processorEnv.getFilesWithoutAnnotation();
                if (others != null && others.length > 0) {
                    firstResult = others[0];
                }
            }
            assert (firstResult != null) : "don't know where to report results";
            if (firstResult != null) {
                GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager();
                this.reportResult(firstResult, lastGeneratedFiles.get(null), processorEnv.getAllGeneratedFiles(), processorEnv.getModifiedGeneratedFiles(), processorEnv.getProblems(), processorEnv.getTypeDependencies(), gfm, processorEnv);
            }
            processorEnv.completedBatchProcessing();
        }
        if (!fileFactory2Annos.isEmpty()) {
            BuildContext[] buildContextArray = cpResults;
            int n = 0;
            int n2 = buildContextArray.length;
            while (n < n2) {
                BuildContext curResult = buildContextArray[n];
                Set annotationTypesInFile = (Set)file2AnnotationDecls.get(curResult);
                if (annotationTypesInFile != null && !annotationTypesInFile.isEmpty()) {
                    for (AnnotationProcessorFactory factory : this._factories.keySet()) {
                        Set<AnnotationTypeDeclaration> intersect;
                        Set annotationTypesForFactory = (Set)fileFactory2Annos.get(factory);
                        if (annotationTypesForFactory == null || annotationTypesForFactory.isEmpty() || (intersect = this.setIntersect(annotationTypesInFile, annotationTypesForFactory)) == null || intersect.isEmpty()) continue;
                        processorEnv.beginFileProcessing(curResult);
                        AnnotationProcessor processor = factory.getProcessorFor(intersect, processorEnv);
                        if (processor == null) continue;
                        if (AptPlugin.DEBUG) {
                            APTDispatchRunnable.trace("runAPT: invoking file-based processor " + processor.getClass().getName(), processorEnv);
                        }
                        processor.process();
                    }
                    GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager();
                    IFile curFile = curResult.getFile();
                    this.reportResult(curResult, lastGeneratedFiles.get(curFile), processorEnv.getAllGeneratedFiles(), processorEnv.getModifiedGeneratedFiles(), processorEnv.getProblems(), processorEnv.getTypeDependencies(), gfm, processorEnv);
                    processorEnv.completedFileProcessing();
                }
                ++n;
            }
        }
    }

    private void dispatchToFileBasedProcessor(AbstractCompilationEnv processorEnv) {
        Map<String, AnnotationTypeDeclaration> annotationDecls = processorEnv.getAnnotationTypes();
        for (Map.Entry<AnnotationProcessorFactory, FactoryPath.Attributes> entry : this._factories.entrySet()) {
            AnnotationProcessor processor;
            if (entry.getValue().runInBatchMode()) continue;
            AnnotationProcessorFactory factory = entry.getKey();
            Set<AnnotationTypeDeclaration> factoryDecls = APTDispatchRunnable.getFactorySupportedAnnotations(factory, annotationDecls);
            if (factoryDecls != null && factoryDecls.size() == 0) {
                factoryDecls = new HashSet<AnnotationTypeDeclaration>(annotationDecls.values());
                annotationDecls.clear();
            }
            if (factoryDecls != null && factoryDecls.size() > 0 && (processor = factory.getProcessorFor(factoryDecls, processorEnv)) != null) {
                if (AptPlugin.DEBUG) {
                    APTDispatchRunnable.trace("runAPT: invoking file-based processor " + processor.getClass().getName() + " on " + processorEnv.getFile(), processorEnv);
                }
                processor.process();
            }
            if (annotationDecls.isEmpty()) break;
        }
        annotationDecls.isEmpty();
    }

    private Set<AnnotationProcessorFactory> build(BuildEnv processorEnv) {
        try {
            BuildContext[] results = processorEnv.getFilesWithAnnotation();
            GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager();
            HashMap<IFile, Set<IFile>> lastGeneratedFiles = new HashMap<IFile, Set<IFile>>();
            BuildContext[] buildContextArray = results;
            int n = 0;
            int n2 = buildContextArray.length;
            while (n < n2) {
                BuildContext result = buildContextArray[n];
                IFile parentIFile = result.getFile();
                lastGeneratedFiles.put(parentIFile, gfm.getGeneratedFilesForParent(parentIFile));
                ++n;
            }
            boolean mixedModeDispatch = this.shouldDispatchToBatchProcessor(processorEnv);
            if (mixedModeDispatch) {
                this.runAPTInMixedMode(lastGeneratedFiles, processorEnv);
            } else {
                this.runAPTInFileBasedMode(processorEnv, lastGeneratedFiles);
            }
            Set<AnnotationProcessorListener> listeners = processorEnv.getProcessorListeners();
            for (AnnotationProcessorListener listener : listeners) {
                EclipseRoundCompleteEvent event = null;
                if (!(listener instanceof RoundCompleteListener)) continue;
                if (event == null) {
                    event = new EclipseRoundCompleteEvent(processorEnv);
                }
                RoundCompleteListener rcListener = (RoundCompleteListener)listener;
                rcListener.roundComplete(event);
            }
            if (this._filesWithoutAnnotation != null) {
                this.cleanupAllGeneratedFilesFrom(this._filesWithoutAnnotation);
            }
            processorEnv.close();
            gfm.writeState();
        }
        catch (Error t) {
            if (t.getClass().getName().startsWith("junit.framework")) {
                throw t;
            }
            AptPlugin.log(t, "Unexpected failure running APT on the file(s): " + APTDispatchRunnable.getFileNamesForPrinting(processorEnv));
        }
        catch (Throwable t) {
            AptPlugin.log(t, "Unexpected failure running APT on the file(s): " + APTDispatchRunnable.getFileNamesForPrinting(processorEnv));
        }
        return Collections.emptySet();
    }

    private Set<AnnotationTypeDeclaration> setIntersect(Set<AnnotationTypeDeclaration> one, Set<AnnotationTypeDeclaration> two) {
        HashSet<AnnotationTypeDeclaration> intersect = null;
        for (AnnotationTypeDeclaration obj : one) {
            if (!two.contains(obj)) continue;
            if (intersect == null) {
                intersect = new HashSet<AnnotationTypeDeclaration>();
            }
            intersect.add(obj);
        }
        return intersect;
    }

    private void cleanupAllGeneratedFiles() {
        this.cleanupAllGeneratedFilesFrom(this._filesWithAnnotation);
        this.cleanupAllGeneratedFilesFrom(this._filesWithoutAnnotation);
    }

    private void cleanupAllGeneratedFilesFrom(BuildContext[] cpResults) {
        ArrayList<IFile> deleted = new ArrayList<IFile>();
        if (cpResults != null) {
            GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager();
            BuildContext[] buildContextArray = cpResults;
            int n = 0;
            int n2 = buildContextArray.length;
            while (n < n2) {
                BuildContext cpResult = buildContextArray[n];
                Set<IFile> lastGeneratedFiles = gfm.getGeneratedFilesForParent(cpResult.getFile());
                this.cleanupNoLongerGeneratedFiles(cpResult, lastGeneratedFiles, Collections.<IFile>emptySet(), gfm, null, deleted);
                if (deleted.size() > 0) {
                    IFile[] deletedFilesArray = new IFile[deleted.size()];
                    cpResult.recordDeletedGeneratedFiles(deleted.toArray(deletedFilesArray));
                }
                ++n;
            }
        }
    }

    private void cleanupNoLongerGeneratedFiles(BuildContext parent, Set<IFile> lastGeneratedFiles, Set<IFile> newGeneratedFiles, GeneratedFileManager gfm, BuildEnv processorEnv, Collection<IFile> deleted) {
        IFile[] files;
        int numLastGeneratedFiles = lastGeneratedFiles.size();
        IFile[] iFileArray = files = lastGeneratedFiles.toArray(new IFile[numLastGeneratedFiles]);
        int n = 0;
        int n2 = iFileArray.length;
        while (n < n2) {
            IFile f = iFileArray[n];
            if (!newGeneratedFiles.contains(f)) {
                IFile parentFile = parent.getFile();
                if (AptPlugin.DEBUG) {
                    APTDispatchRunnable.trace("runAPT:  File " + f + " is no longer a generated file for " + parentFile, processorEnv);
                }
                try {
                    if (gfm.deleteGeneratedFile(f, parentFile, null)) {
                        deleted.add(f);
                    }
                }
                catch (CoreException ce) {
                    AptPlugin.log(ce, "Could not clean up generated files");
                }
            }
            ++n;
        }
    }

    private static Set<AnnotationTypeDeclaration> getFactorySupportedAnnotations(AnnotationProcessorFactory factory, Map<String, AnnotationTypeDeclaration> declarations) {
        Collection<String> supportedTypes = factory.supportedAnnotationTypes();
        if (supportedTypes == null || supportedTypes.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<AnnotationTypeDeclaration> fDecls = new HashSet<AnnotationTypeDeclaration>();
        for (String typeName : supportedTypes) {
            if (typeName.equals("*")) {
                fDecls.addAll(declarations.values());
                declarations.clear();
                AptPlugin.logWarning(null, "Processor Factory " + factory + " claimed all annotations (*), which prevents any following factories from being dispatched.");
                continue;
            }
            if (typeName.endsWith("*")) {
                String prefix = typeName.substring(0, typeName.length() - 2);
                Iterator<Map.Entry<String, AnnotationTypeDeclaration>> entries = declarations.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<String, AnnotationTypeDeclaration> entry = entries.next();
                    String key = entry.getKey();
                    if (!key.startsWith(prefix)) continue;
                    fDecls.add(entry.getValue());
                    entries.remove();
                }
                continue;
            }
            AnnotationTypeDeclaration decl = declarations.get(typeName);
            if (decl == null) continue;
            fDecls.add(decl);
            declarations.remove(typeName);
        }
        return fDecls.isEmpty() ? null : fDecls;
    }

    private static void trace(String s, AbstractCompilationEnv processorEnv) {
        if (AptPlugin.DEBUG) {
            if (processorEnv != null) {
                s = "[ phase = " + (Object)((Object)processorEnv.getPhase()) + ", file = " + APTDispatchRunnable.getFileNamesForPrinting(processorEnv) + " ]  " + s;
            }
            System.out.println("[" + APTDispatchRunnable.class.getName() + "][ thread= " + Thread.currentThread().getName() + " ]" + s);
        }
    }

    private static String getFileNamesForPrinting(AbstractCompilationEnv env) {
        if (env instanceof ReconcileEnv) {
            return env.getFile().getName();
        }
        return APTDispatchRunnable.getFileNamesForPrinting((BuildEnv)env);
    }

    private static String getFileNamesForPrinting(BuildEnv processorEnv) {
        IFile file = processorEnv.getFile();
        if (file != null) {
            return file.getName();
        }
        BuildContext[] results = processorEnv.getFilesWithAnnotation();
        int len = results.length;
        switch (len) {
            case 0: {
                return "no file(s)";
            }
            case 1: {
                return results[0].getFile().getName();
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean firstItem = true;
        BuildContext[] buildContextArray = results;
        int n = 0;
        int n2 = buildContextArray.length;
        while (n < n2) {
            BuildContext curResult = buildContextArray[n];
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append(curResult.getFile().getName());
            ++n;
        }
        return sb.toString();
    }
}

