/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.php.internal.core.ast.binding.ArrayAttribute;
import org.eclipse.php.internal.core.ast.binding.Attribute;
import org.eclipse.php.internal.core.ast.binding.AttributeType;
import org.eclipse.php.internal.core.ast.binding.GlobalScope;
import org.eclipse.php.internal.core.ast.binding.Scope;
import org.eclipse.php.internal.core.ast.binding.ScopeType;
import org.eclipse.php.internal.core.ast.binding.TypeResolver;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.BackTickExpression;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.ExpressionStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;

public class ProgramScope
extends AbstractVisitor
implements Scope {
    private GlobalScope rootGlobalScope;
    private final Map classScopes = new HashMap();
    private final Map functionScopes = new HashMap();
    private GlobalScope currentGlobalScope;

    public ProgramScope(Program program) {
        this.currentGlobalScope = this.rootGlobalScope = GlobalScope.createRootScope(program.getStart(), this);
        program.accept(this);
    }

    private void attachAttributes(int n, ListVariable listVariable, Attribute attribute) {
        VariableBase[] variableBaseArray = listVariable.getVariables();
        Attribute[] attributeArray = new Attribute[variableBaseArray.length];
        if (attribute.getType() == AttributeType.ARRAY_ATTRIBUTE) {
            ArrayAttribute arrayAttribute = (ArrayAttribute)attribute;
            int n2 = 0;
            Iterator iterator = arrayAttribute.getAttrributes().iterator();
            while (iterator.hasNext()) {
                Attribute attribute2;
                attributeArray[n2] = attribute2 = (Attribute)iterator.next();
                ++n2;
            }
        } else {
            attributeArray[0] = attribute;
        }
        int n3 = 0;
        while (n3 < variableBaseArray.length) {
            VariableBase variableBase = variableBaseArray[n3];
            this.attachVariableBase(n, variableBase, attributeArray[n3]);
            ++n3;
        }
    }

    private void attachIndexedVariable(int n, Attribute attribute, ArrayAccess arrayAccess) {
        Expression expression = arrayAccess.getVariableName();
        if (expression.getType() == 33) {
            String string = ((Identifier)expression).getName();
            ArrayAttribute arrayAttribute = new ArrayAttribute();
            arrayAttribute.addAttribute(attribute);
            this.updateScope(n, string, arrayAttribute);
        }
    }

    private void attachVariable(int n, Attribute attribute, Variable variable) {
        Expression expression = variable.getVariableName();
        if (expression.getType() == 33) {
            String string = ((Identifier)expression).getName();
            this.updateScope(n, string, attribute);
        }
    }

    private void attachVariableBase(int n, VariableBase variableBase, Attribute attribute) {
        if (attribute == null) {
            attribute = Attribute.NULL_ATTRIBUTE;
        }
        switch (variableBase.getType()) {
            case 41: {
                this.attachAttributes(n, (ListVariable)variableBase, attribute);
                break;
            }
            case 43: {
                break;
            }
            case 24: {
                break;
            }
            case 0: {
                this.attachIndexedVariable(n, attribute, (ArrayAccess)variableBase);
                break;
            }
            case 49: {
                break;
            }
            case 52: {
                break;
            }
            case 60: {
                this.attachVariable(n, attribute, (Variable)variableBase);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad assignment");
            }
        }
    }

    public Scope getChild() {
        return null;
    }

    public int getLength() {
        return Integer.MAX_VALUE;
    }

    public Scope getParent() {
        return null;
    }

    public Scope getScope(int n) {
        return null;
    }

    public ScopeType getScopeType() {
        return null;
    }

    public int getStart() {
        return 0;
    }

    public Attribute lookup(StaticConstantAccess staticConstantAccess) {
        return Attribute.NULL_ATTRIBUTE;
    }

    public Attribute lookup(String string) {
        return null;
    }

    public Attribute lookup(VariableBase variableBase) {
        return null;
    }

    public Attribute probe(String string) {
        return null;
    }

    private Attribute resolveAttribute(Expression expression) {
        return TypeResolver.resolve(this.currentGlobalScope, expression);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, "");
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer, String string) {
        Scope scope;
        stringBuffer.append(string).append("<ProgramScope>\n");
        stringBuffer.append("\t").append(string).append("<RootGlobalScope>\n");
        this.rootGlobalScope.toString(stringBuffer, "\t\t" + string);
        stringBuffer.append("\t").append(string).append("</RootGlobalScope>\n");
        stringBuffer.append("\t").append(string).append("<ClassScopes>\n");
        Iterator iterator = this.classScopes.values().iterator();
        while (iterator.hasNext()) {
            scope = (Scope)iterator.next();
            scope.toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\t").append(string).append("</ClassScopes>\n");
        stringBuffer.append("\t").append(string).append("<FunctionScopes>\n");
        iterator = this.functionScopes.values().iterator();
        while (iterator.hasNext()) {
            scope = (Scope)iterator.next();
            scope.toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\t").append(string).append("</FunctionScopes>\n");
        stringBuffer.append(string).append("</ProgramScope>");
    }

    private void updateScope(int n, String string, Attribute attribute) {
        Attribute attribute2 = this.currentGlobalScope.lookup(string);
        if (!(attribute2 != null && attribute2.equals(attribute) || n == this.currentGlobalScope.start)) {
            this.currentGlobalScope = this.currentGlobalScope.enterScope(n);
        }
        this.currentGlobalScope.insertIdentifier(string, attribute);
    }

    public void visit(Assignment assignment) {
        Attribute attribute = this.resolveAttribute(assignment.getValue());
        this.attachVariableBase(assignment.getStart(), assignment.getVariable(), attribute);
    }

    public void visit(BackTickExpression backTickExpression) {
    }

    public void visit(ExpressionStatement expressionStatement) {
    }

    public void visit(Program program) {
        super.visit(program);
    }

    public void visit(StaticMethodInvocation staticMethodInvocation) {
    }
}

