/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.resources;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.php.internal.core.resources.ExternalFileDecorator;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistryListener;

public class ExternalFilesRegistry {
    private static ExternalFilesRegistry instance = null;
    private final HashMap externalFilesRegistry = new HashMap();
    private final ListenerList listeners = new ListenerList();
    private IProject externalFilesProject = ResourcesPlugin.getWorkspace().getRoot().getProject("external_" + System.currentTimeMillis());

    private ExternalFilesRegistry() {
    }

    public static synchronized ExternalFilesRegistry getInstance() {
        if (instance == null) {
            instance = new ExternalFilesRegistry();
        }
        return instance;
    }

    public void addFileEntry(String string, IFile iFile) {
        if (!this.externalFilesRegistry.containsKey(string)) {
            this.externalFilesRegistry.put(string, iFile);
            this.notifyEntryChange(string, true);
        }
    }

    public IFile getFileEntry(String string) {
        return (IFile)this.externalFilesRegistry.get(string);
    }

    public void removeFileEntry(String string) {
        if (this.externalFilesRegistry.remove(string) != null) {
            this.notifyEntryChange(string, false);
        }
    }

    private void notifyEntryChange(String string, boolean bl) {
        Object[] objectArray = this.listeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            if (bl) {
                ((ExternalFilesRegistryListener)objectArray[n]).externalFileAdded(string);
            } else {
                ((ExternalFilesRegistryListener)objectArray[n]).externalFileRemoved(string);
            }
            ++n;
        }
    }

    public boolean isEntryExist(String string) {
        return this.externalFilesRegistry.containsKey(string);
    }

    public void addListener(ExternalFilesRegistryListener externalFilesRegistryListener) {
        this.listeners.add((Object)externalFilesRegistryListener);
    }

    public void removeListener(ExternalFilesRegistryListener externalFilesRegistryListener) {
        this.listeners.remove((Object)externalFilesRegistryListener);
    }

    public IFile[] getAllAsIFiles() {
        Collection collection = this.externalFilesRegistry.values();
        IFile[] iFileArray = new ExternalFileDecorator[collection.size()];
        collection.toArray(iFileArray);
        return iFileArray;
    }

    public IProject getExternalFilesProject() {
        return this.externalFilesProject;
    }
}

