/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.ISavable;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.ViewerSwitchingCancelled;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class ContentMergeViewer
extends ContentViewer
implements IPropertyChangeNotifier,
ISavable {
    private static final String ANCESTOR_ENABLED = "org.eclipse.compare.InitiallyShowAncestorPane";
    static final int HORIZONTAL = 1;
    static final int VERTICAL = 2;
    static final double HSPLIT = 0.5;
    static final double VSPLIT = 0.3;
    private int fStyles;
    private ResourceBundle fBundle;
    private CompareConfiguration fCompareConfiguration;
    private IPropertyChangeListener fPropertyChangeListener;
    private ICompareInputChangeListener fCompareInputChangeListener;
    private ListenerList fListenerList;
    boolean fConfirmSave = true;
    private double fHSplit = 0.5;
    private double fVSplit = 0.3;
    private boolean fAncestorEnabled = true;
    boolean fShowAncestor = false;
    private boolean fIsThreeWay = false;
    private ActionContributionItem fAncestorItem;
    private Action fCopyLeftToRightAction;
    private Action fCopyRightToLeftAction;
    MergeViewerAction fLeftSaveAction;
    MergeViewerAction fRightSaveAction;
    private IKeyBindingService fKeyBindingService;
    Composite fComposite;
    private CLabel fAncestorLabel;
    private CLabel fLeftLabel;
    private CLabel fRightLabel;
    CLabel fDirectionLabel;
    Control fCenter;
    private Image fRightArrow;
    private Image fLeftArrow;
    private Image fBothArrow;
    Cursor fNormalCursor;
    private Cursor fHSashCursor;
    private Cursor fVSashCursor;
    private Cursor fHVSashCursor;

    protected ContentMergeViewer(int n, ResourceBundle resourceBundle, CompareConfiguration compareConfiguration) {
        this.fStyles = n & 0xF9FFFFFF;
        this.fBundle = resourceBundle;
        this.fAncestorEnabled = Utilities.getBoolean((CompareConfiguration)compareConfiguration, (String)ANCESTOR_ENABLED, (boolean)this.fAncestorEnabled);
        this.fConfirmSave = Utilities.getBoolean((CompareConfiguration)compareConfiguration, (String)"org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY", (boolean)this.fConfirmSave);
        this.setContentProvider((IContentProvider)new MergeViewerContentProvider(compareConfiguration));
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput iCompareInput) {
                ContentMergeViewer.this.internalRefresh(iCompareInput);
            }
        };
        this.fCompareConfiguration = compareConfiguration;
        if (this.fCompareConfiguration != null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ContentMergeViewer.this.propertyChange(propertyChangeEvent);
                }
            };
            this.fCompareConfiguration.addPropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fLeftSaveAction = new SaveAction(true);
        this.fLeftSaveAction.setEnabled(false);
        this.fRightSaveAction = new SaveAction(false);
        this.fRightSaveAction.setEnabled(false);
    }

    public String getTitle() {
        return Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"title");
    }

    protected abstract void createControls(Composite var1);

    protected abstract void handleResizeAncestor(int var1, int var2, int var3, int var4);

    protected abstract void handleResizeLeftRight(int var1, int var2, int var3, int var4, int var5, int var6);

    protected void createToolItems(ToolBarManager toolBarManager) {
    }

    protected abstract void updateContent(Object var1, Object var2, Object var3);

    protected abstract void copy(boolean var1);

    protected abstract byte[] getContents(boolean var1);

    protected ResourceBundle getResourceBundle() {
        return this.fBundle;
    }

    protected CompareConfiguration getCompareConfiguration() {
        return this.fCompareConfiguration;
    }

    public void setContentProvider(IContentProvider iContentProvider) {
        Assert.isTrue((boolean)(iContentProvider instanceof IMergeViewerContentProvider));
        super.setContentProvider(iContentProvider);
    }

    IMergeViewerContentProvider getMergeContentProvider() {
        return (IMergeViewerContentProvider)this.getContentProvider();
    }

    public ISelection getSelection() {
        return new ISelection(){

            public boolean isEmpty() {
                return true;
            }
        };
    }

    public void setSelection(ISelection iSelection, boolean bl) {
    }

    void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (string.equals(ANCESTOR_ENABLED)) {
            this.fAncestorEnabled = Utilities.getBoolean((CompareConfiguration)this.getCompareConfiguration(), (String)ANCESTOR_ENABLED, (boolean)this.fAncestorEnabled);
            this.fComposite.layout(true);
            this.updateCursor((Control)this.fLeftLabel, 2);
            this.updateCursor((Control)this.fDirectionLabel, 3);
            this.updateCursor((Control)this.fRightLabel, 2);
            return;
        }
    }

    void updateCursor(Control control, int n) {
        if (!(control instanceof Sash)) {
            Cursor cursor = null;
            switch (n) {
                case 2: {
                    if (this.fAncestorEnabled) {
                        if (this.fVSashCursor == null) {
                            this.fVSashCursor = new Cursor((Device)control.getDisplay(), 7);
                        }
                        cursor = this.fVSashCursor;
                        break;
                    }
                    if (this.fNormalCursor == null) {
                        this.fNormalCursor = new Cursor((Device)control.getDisplay(), 0);
                    }
                    cursor = this.fNormalCursor;
                    break;
                }
                case 1: {
                    if (this.fHSashCursor == null) {
                        this.fHSashCursor = new Cursor((Device)control.getDisplay(), 9);
                    }
                    cursor = this.fHSashCursor;
                    break;
                }
                case 3: {
                    if (this.fAncestorEnabled) {
                        if (this.fHVSashCursor == null) {
                            this.fHVSashCursor = new Cursor((Device)control.getDisplay(), 5);
                        }
                        cursor = this.fHVSashCursor;
                        break;
                    }
                    if (this.fHSashCursor == null) {
                        this.fHSashCursor = new Cursor((Device)control.getDisplay(), 9);
                    }
                    cursor = this.fHSashCursor;
                }
            }
            if (cursor != null) {
                control.setCursor(cursor);
            }
        }
    }

    void setAncestorVisibility(boolean bl, boolean bl2) {
        Action action;
        if (this.fAncestorItem != null && (action = (Action)this.fAncestorItem.getAction()) != null) {
            action.setChecked(bl);
            action.setEnabled(bl2);
        }
        if (this.fCompareConfiguration != null) {
            this.fCompareConfiguration.setProperty(ANCESTOR_ENABLED, (Object)new Boolean(bl));
        }
    }

    boolean isThreeWay() {
        return this.fIsThreeWay;
    }

    protected final void inputChanged(Object object, Object object2) {
        if (object != object2 && object2 instanceof ICompareInput) {
            ((ICompareInput)object2).removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        boolean bl = this.doSave(object, object2);
        if (object != object2 && object instanceof ICompareInput) {
            ((ICompareInput)object).addCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (bl) {
            this.setLeftDirty(false);
            this.setRightDirty(false);
        }
        if (object != object2) {
            this.internalRefresh(object);
        }
    }

    protected boolean doSave(Object object, Object object2) {
        if (this.fLeftSaveAction.isEnabled() || this.fRightSaveAction.isEnabled()) {
            if (this.fConfirmSave) {
                Shell shell = this.fComposite.getShell();
                MessageDialog messageDialog = new MessageDialog(shell, Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"saveDialog.title"), null, Utilities.getString((ResourceBundle)this.getResourceBundle(), (String)"saveDialog.message"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                switch (messageDialog.open()) {
                    case 0: {
                        this.saveContent(object2);
                        break;
                    }
                    case 1: {
                        this.setLeftDirty(false);
                        this.setRightDirty(false);
                        break;
                    }
                    case 2: {
                        throw new ViewerSwitchingCancelled();
                    }
                }
            } else {
                this.saveContent(object2);
            }
            return true;
        }
        return false;
    }

    public void setConfirmSave(boolean bl) {
        this.fConfirmSave = bl;
    }

    public void refresh() {
        this.internalRefresh(this.getInput());
    }

    private void internalRefresh(Object object) {
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        if (iMergeViewerContentProvider != null) {
            ToolBarManager toolBarManager;
            Object object2 = iMergeViewerContentProvider.getAncestorContent(object);
            if (object instanceof ICompareInput) {
                this.fIsThreeWay = (((ICompareInput)object).getKind() & 0xC) != 0;
            } else {
                boolean bl = this.fIsThreeWay = object2 != null;
            }
            if (this.fAncestorItem != null) {
                this.fAncestorItem.setVisible(this.fIsThreeWay);
            }
            boolean bl = this.fShowAncestor;
            boolean bl2 = this.fShowAncestor = this.fIsThreeWay && iMergeViewerContentProvider.showAncestor(object);
            if (this.fAncestorEnabled && bl != this.fShowAncestor) {
                this.fComposite.layout(true);
            }
            if ((toolBarManager = CompareViewerPane.getToolBarManager((Composite)this.fComposite.getParent())) != null) {
                this.updateToolItems();
                toolBarManager.update(true);
                toolBarManager.getControl().getParent().layout(true);
            }
            this.updateHeader();
            Object object3 = iMergeViewerContentProvider.getLeftContent(object);
            Object object4 = iMergeViewerContentProvider.getRightContent(object);
            this.updateContent(object2, object3, object4);
        }
    }

    protected final Control buildControl(Composite composite) {
        this.fComposite = new Composite(composite, this.fStyles | 0x2000000){

            public boolean setFocus() {
                return ContentMergeViewer.this.internalSetFocus();
            }
        };
        this.fComposite.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)this.getTitle());
        this.hookControl((Control)this.fComposite);
        this.fComposite.setLayout((Layout)new ContentMergeViewerLayout());
        int n = 8;
        this.fAncestorLabel = new CLabel(this.fComposite, n);
        this.fLeftLabel = new CLabel(this.fComposite, n);
        new Resizer((Control)this.fLeftLabel, 2);
        this.fDirectionLabel = new CLabel(this.fComposite, n);
        this.fDirectionLabel.setAlignment(0x1000000);
        new Resizer((Control)this.fDirectionLabel, 3);
        this.fRightLabel = new CLabel(this.fComposite, n);
        new Resizer((Control)this.fRightLabel, 2);
        if (this.fCenter == null || this.fCenter.isDisposed()) {
            this.fCenter = this.createCenter(this.fComposite);
        }
        this.createControls(this.fComposite);
        IWorkbenchPartSite iWorkbenchPartSite = Utilities.findSite((Control)this.fComposite);
        this.fKeyBindingService = iWorkbenchPartSite != null ? iWorkbenchPartSite.getKeyBindingService() : null;
        ToolBarManager toolBarManager = CompareViewerPane.getToolBarManager((Composite)composite);
        if (toolBarManager != null) {
            toolBarManager.removeAll();
            toolBarManager.add((IContributionItem)new Separator("modes"));
            toolBarManager.add((IContributionItem)new Separator("merge"));
            toolBarManager.add((IContributionItem)new Separator("navigation"));
            CompareConfiguration compareConfiguration = this.getCompareConfiguration();
            if (compareConfiguration.isRightEditable()) {
                this.fCopyLeftToRightAction = new Action(){

                    public void run() {
                        ContentMergeViewer.this.copy(true);
                    }
                };
                Utilities.initAction((IAction)this.fCopyLeftToRightAction, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyLeftToRight.");
                toolBarManager.appendToGroup("merge", (IAction)this.fCopyLeftToRightAction);
                Utilities.registerAction((IKeyBindingService)this.fKeyBindingService, (IAction)this.fCopyLeftToRightAction, (String)"org.eclipse.compare.copyAllLeftToRight");
            }
            if (compareConfiguration.isLeftEditable()) {
                this.fCopyRightToLeftAction = new Action(){

                    public void run() {
                        ContentMergeViewer.this.copy(false);
                    }
                };
                Utilities.initAction((IAction)this.fCopyRightToLeftAction, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyRightToLeft.");
                toolBarManager.appendToGroup("merge", (IAction)this.fCopyRightToLeftAction);
                Utilities.registerAction((IKeyBindingService)this.fKeyBindingService, (IAction)this.fCopyRightToLeftAction, (String)"org.eclipse.compare.copyAllRightToLeft");
            }
            ChangePropertyAction changePropertyAction = new ChangePropertyAction(this.fBundle, this.fCompareConfiguration, "action.EnableAncestor.", ANCESTOR_ENABLED);
            changePropertyAction.setChecked(this.fAncestorEnabled);
            this.fAncestorItem = new ActionContributionItem((IAction)changePropertyAction);
            this.fAncestorItem.setVisible(false);
            toolBarManager.appendToGroup("modes", (IContributionItem)this.fAncestorItem);
            this.createToolItems(toolBarManager);
            this.updateToolItems();
            toolBarManager.update(true);
        }
        return this.fComposite;
    }

    boolean internalSetFocus() {
        return false;
    }

    int getCenterWidth() {
        return 3;
    }

    boolean getAncestorEnabled() {
        return this.fAncestorEnabled;
    }

    Control createCenter(Composite composite) {
        Sash sash = new Sash(composite, 512);
        new Resizer((Control)sash, 1);
        return sash;
    }

    Control getCenter() {
        return this.fCenter;
    }

    public Control getControl() {
        return this.fComposite;
    }

    protected void handleDispose(DisposeEvent disposeEvent) {
        Object object;
        if (this.fKeyBindingService != null) {
            if (this.fCopyLeftToRightAction != null) {
                this.fKeyBindingService.unregisterAction((IAction)this.fCopyLeftToRightAction);
            }
            if (this.fCopyRightToLeftAction != null) {
                this.fKeyBindingService.unregisterAction((IAction)this.fCopyRightToLeftAction);
            }
            this.fKeyBindingService = null;
        }
        if ((object = this.getInput()) instanceof ICompareInput) {
            ((ICompareInput)object).removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        if (this.fCompareConfiguration != null && this.fPropertyChangeListener != null) {
            this.fCompareConfiguration.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        this.fAncestorLabel = null;
        this.fLeftLabel = null;
        this.fDirectionLabel = null;
        this.fRightLabel = null;
        this.fCenter = null;
        if (this.fRightArrow != null) {
            this.fRightArrow.dispose();
            this.fRightArrow = null;
        }
        if (this.fLeftArrow != null) {
            this.fLeftArrow.dispose();
            this.fLeftArrow = null;
        }
        if (this.fBothArrow != null) {
            this.fBothArrow.dispose();
            this.fBothArrow = null;
        }
        if (this.fNormalCursor != null) {
            this.fNormalCursor.dispose();
            this.fNormalCursor = null;
        }
        if (this.fHSashCursor != null) {
            this.fHSashCursor.dispose();
            this.fHSashCursor = null;
        }
        if (this.fVSashCursor != null) {
            this.fVSashCursor.dispose();
            this.fVSashCursor = null;
        }
        if (this.fHVSashCursor != null) {
            this.fHVSashCursor.dispose();
            this.fHVSashCursor = null;
        }
        super.handleDispose(disposeEvent);
    }

    protected void updateToolItems() {
        boolean bl;
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        Object object = this.getInput();
        if (this.fCopyLeftToRightAction != null) {
            bl = iMergeViewerContentProvider.isRightEditable(object);
            this.fCopyLeftToRightAction.setEnabled(bl);
        }
        if (this.fCopyRightToLeftAction != null) {
            bl = iMergeViewerContentProvider.isLeftEditable(object);
            this.fCopyRightToLeftAction.setEnabled(bl);
        }
    }

    protected void updateHeader() {
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        Object object = this.getInput();
        if (this.fAncestorLabel != null) {
            this.fAncestorLabel.setImage(iMergeViewerContentProvider.getAncestorImage(object));
            this.fAncestorLabel.setText(iMergeViewerContentProvider.getAncestorLabel(object));
        }
        if (this.fLeftLabel != null) {
            this.fLeftLabel.setImage(iMergeViewerContentProvider.getLeftImage(object));
            this.fLeftLabel.setText(iMergeViewerContentProvider.getLeftLabel(object));
        }
        if (this.fRightLabel != null) {
            this.fRightLabel.setImage(iMergeViewerContentProvider.getRightImage(object));
            this.fRightLabel.setText(iMergeViewerContentProvider.getRightLabel(object));
        }
    }

    int getHeaderHeight() {
        int n = this.fLeftLabel.computeSize((int)-1, (int)-1, (boolean)true).y;
        n = Math.max(n, this.fDirectionLabel.computeSize((int)-1, (int)-1, (boolean)true).y);
        return n;
    }

    boolean canToggleMergeDirection() {
        Object object;
        IMergeViewerContentProvider iMergeViewerContentProvider = this.getMergeContentProvider();
        return iMergeViewerContentProvider.isLeftEditable(object = this.getInput()) && iMergeViewerContentProvider.isRightEditable(object);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.fListenerList == null) {
            this.fListenerList = new ListenerList();
        }
        this.fListenerList.add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        if (this.fListenerList != null) {
            this.fListenerList.remove((Object)iPropertyChangeListener);
            if (this.fListenerList.isEmpty()) {
                this.fListenerList = null;
            }
        }
    }

    void fireDirtyState(boolean bl) {
        Utilities.firePropertyChange((ListenerList)this.fListenerList, (Object)((Object)this), (String)"DIRTY_STATE", null, (Object)new Boolean(bl));
    }

    protected void setLeftDirty(boolean bl) {
        if (this.fLeftSaveAction.isEnabled() != bl) {
            this.fLeftSaveAction.setEnabled(bl);
            this.fireDirtyState(bl);
        }
    }

    protected void setRightDirty(boolean bl) {
        if (this.fRightSaveAction.isEnabled() != bl) {
            this.fRightSaveAction.setEnabled(bl);
            this.fireDirtyState(bl);
        }
    }

    public void save(IProgressMonitor iProgressMonitor) throws CoreException {
        this.saveContent(this.getInput());
    }

    void saveContent(Object object) {
        byte[] byArray;
        boolean bl;
        IMergeViewerContentProvider iMergeViewerContentProvider = (IMergeViewerContentProvider)this.getContentProvider();
        boolean bl2 = iMergeViewerContentProvider.getLeftContent(object) == null;
        boolean bl3 = bl = iMergeViewerContentProvider.getRightContent(object) == null;
        if (this.fCompareConfiguration.isLeftEditable() && this.fLeftSaveAction.isEnabled()) {
            byArray = this.getContents(true);
            if (bl2 && byArray != null && byArray.length == 0) {
                byArray = null;
            }
            this.setLeftDirty(false);
            iMergeViewerContentProvider.saveLeftContent(object, byArray);
        }
        if (this.fCompareConfiguration.isRightEditable() && this.fRightSaveAction.isEnabled()) {
            byArray = this.getContents(false);
            if (bl && byArray != null && byArray.length == 0) {
                byArray = null;
            }
            this.setRightDirty(false);
            iMergeViewerContentProvider.saveRightContent(object, byArray);
        }
    }

    private class ContentMergeViewerLayout
    extends Layout {
        private ContentMergeViewerLayout() {
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            return new Point(100, 100);
        }

        public void layout(Composite composite, boolean bl) {
            int n = ((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.computeSize((int)-1, (int)-1, (boolean)true).y;
            Rectangle rectangle = composite.getClientArea();
            int n2 = ContentMergeViewer.this.getCenterWidth();
            int n3 = (int)((double)(rectangle.width - n2) * ContentMergeViewer.this.fHSplit);
            int n4 = rectangle.width - n3 - n2;
            int n5 = 0;
            int n6 = 0;
            if (ContentMergeViewer.this.fAncestorEnabled && ContentMergeViewer.this.fShowAncestor) {
                n5 = (int)((double)(rectangle.height - 2 * n) * ContentMergeViewer.this.fVSplit);
                n6 = rectangle.height - 2 * n - n5;
            } else {
                n5 = 0;
                n6 = rectangle.height - n;
            }
            int n7 = 0;
            if (ContentMergeViewer.this.fAncestorEnabled && ContentMergeViewer.this.fShowAncestor) {
                ContentMergeViewer.this.fAncestorLabel.setBounds(0, n7, rectangle.width, n);
                ContentMergeViewer.this.fAncestorLabel.setVisible(true);
                ContentMergeViewer.this.handleResizeAncestor(0, n7 += n, rectangle.width, n5);
                n7 += n5;
            } else {
                ContentMergeViewer.this.fAncestorLabel.setVisible(false);
                ContentMergeViewer.this.handleResizeAncestor(0, 0, 0, 0);
            }
            ContentMergeViewer.this.fLeftLabel.getSize();
            if (n2 > 3) {
                ContentMergeViewer.this.fLeftLabel.setBounds(0, n7, n3 + 1, n);
                ContentMergeViewer.this.fDirectionLabel.setVisible(true);
                ContentMergeViewer.this.fDirectionLabel.setBounds(n3 + 1, n7, n2 - 1, n);
                ContentMergeViewer.this.fRightLabel.setBounds(n3 + n2, n7, n4, n);
            } else {
                ContentMergeViewer.this.fLeftLabel.setBounds(0, n7, n3, n);
                ContentMergeViewer.this.fDirectionLabel.setVisible(false);
                ContentMergeViewer.this.fRightLabel.setBounds(n3, n7, rectangle.width - n3, n);
            }
            n7 += n;
            if (ContentMergeViewer.this.fCenter != null && !ContentMergeViewer.this.fCenter.isDisposed()) {
                ContentMergeViewer.this.fCenter.setBounds(n3, n7, n2, n6);
            }
            ContentMergeViewer.this.handleResizeLeftRight(0, n7, n3, n2, n4, n6);
        }
    }

    class Resizer
    extends MouseAdapter
    implements MouseMoveListener {
        Control fControl;
        int fX;
        int fY;
        int fWidth1;
        int fWidth2;
        int fHeight1;
        int fHeight2;
        int fDirection;
        boolean fLiveResize;
        boolean fIsDown;

        public Resizer(Control control, int n) {
            this.fDirection = n;
            this.fControl = control;
            this.fLiveResize = !(this.fControl instanceof Sash);
            ContentMergeViewer.this.updateCursor(control, n);
            this.fControl.addMouseListener((MouseListener)this);
            this.fControl.addMouseMoveListener((MouseMoveListener)this);
            this.fControl.addDisposeListener(new DisposeListener(this){
                final /* synthetic */ Resizer this$1;
                {
                    this.this$1 = resizer;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    this.this$1.fControl = null;
                }
            });
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            if ((this.fDirection & 1) != 0) {
                ContentMergeViewer.this.fHSplit = 0.5;
            }
            if ((this.fDirection & 2) != 0) {
                ContentMergeViewer.this.fVSplit = 0.3;
            }
            ContentMergeViewer.this.fComposite.layout(true);
        }

        public void mouseDown(MouseEvent mouseEvent) {
            Composite composite = this.fControl.getParent();
            Point point = composite.getSize();
            Point point2 = ContentMergeViewer.this.fAncestorLabel.getSize();
            Point point3 = ContentMergeViewer.this.fLeftLabel.getSize();
            Point point4 = ContentMergeViewer.this.fRightLabel.getSize();
            this.fWidth1 = point3.x;
            this.fWidth2 = point4.x;
            this.fHeight1 = ((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.getLocation().y - point2.y;
            this.fHeight2 = point.y - (((ContentMergeViewer)ContentMergeViewer.this).fLeftLabel.getLocation().y + point3.y);
            this.fX = mouseEvent.x;
            this.fY = mouseEvent.y;
            this.fIsDown = true;
        }

        public void mouseUp(MouseEvent mouseEvent) {
            this.fIsDown = false;
            if (!this.fLiveResize) {
                this.resize(mouseEvent);
            }
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (this.fIsDown && this.fLiveResize) {
                this.resize(mouseEvent);
            }
        }

        private void resize(MouseEvent mouseEvent) {
            int n = mouseEvent.x - this.fX;
            int n2 = mouseEvent.y - this.fY;
            int n3 = ContentMergeViewer.this.fCenter.getSize().x;
            if (this.fWidth1 + n > n3 && this.fWidth2 - n > n3) {
                this.fWidth1 += n;
                this.fWidth2 -= n;
                if ((this.fDirection & 1) != 0) {
                    ContentMergeViewer.this.fHSplit = (double)this.fWidth1 / (double)(this.fWidth1 + this.fWidth2);
                }
            }
            if (this.fHeight1 + n2 > n3 && this.fHeight2 - n2 > n3) {
                this.fHeight1 += n2;
                this.fHeight2 -= n2;
                if ((this.fDirection & 2) != 0) {
                    ContentMergeViewer.this.fVSplit = (double)this.fHeight1 / (double)(this.fHeight1 + this.fHeight2);
                }
            }
            ContentMergeViewer.this.fComposite.layout(true);
            this.fControl.getDisplay().update();
        }
    }

    class SaveAction
    extends MergeViewerAction {
        SaveAction(boolean bl) {
            super(true, false, false);
            Utilities.initAction((IAction)this, (ResourceBundle)ContentMergeViewer.this.getResourceBundle(), (String)"action.save.");
        }

        public void run() {
            ContentMergeViewer.this.saveContent(ContentMergeViewer.this.getInput());
        }
    }
}

