/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dnd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class DelegatingDragAdapter
implements DragSourceListener {
    private TransferDragSourceListener[] fPossibleListeners;
    private List fActiveListeners;
    private TransferDragSourceListener fFinishListener;

    public DelegatingDragAdapter(TransferDragSourceListener[] transferDragSourceListenerArray) {
        this.setPossibleListeners(transferDragSourceListenerArray);
    }

    protected void setPossibleListeners(TransferDragSourceListener[] transferDragSourceListenerArray) {
        Assert.isNotNull((Object)transferDragSourceListenerArray);
        Assert.isTrue((this.fActiveListeners == null ? 1 : 0) != 0, (String)"Can only set possible listeners before drag operation has started");
        this.fPossibleListeners = transferDragSourceListenerArray;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        this.fFinishListener = null;
        boolean bl = dragSourceEvent.doit;
        Object object = dragSourceEvent.data;
        boolean bl2 = false;
        ArrayList<Transfer> arrayList = new ArrayList<Transfer>(this.fPossibleListeners.length);
        this.fActiveListeners = new ArrayList(this.fPossibleListeners.length);
        int n = 0;
        while (n < this.fPossibleListeners.length) {
            TransferDragSourceListener transferDragSourceListener = this.fPossibleListeners[n];
            dragSourceEvent.doit = bl;
            transferDragSourceListener.dragStart(dragSourceEvent);
            if (dragSourceEvent.doit) {
                arrayList.add(transferDragSourceListener.getTransfer());
                this.fActiveListeners.add(transferDragSourceListener);
            }
            bl2 = bl2 || dragSourceEvent.doit;
            ++n;
        }
        if (bl2) {
            ((DragSource)dragSourceEvent.widget).setTransfer(arrayList.toArray(new Transfer[arrayList.size()]));
        }
        dragSourceEvent.data = object;
        dragSourceEvent.doit = bl2;
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        this.fFinishListener = this.getListener(dragSourceEvent.dataType);
        if (this.fFinishListener != null) {
            this.fFinishListener.dragSetData(dragSourceEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dragFinished(DragSourceEvent dragSourceEvent) {
        try {
            if (this.fFinishListener != null) {
                this.fFinishListener.dragFinished(dragSourceEvent);
            } else {
                this.fFinishListener = this.getListener(dragSourceEvent.dataType);
                if (this.fFinishListener != null) {
                    this.fFinishListener.dragFinished(dragSourceEvent);
                }
            }
            Object var2_4 = null;
            this.fFinishListener = null;
            this.fActiveListeners = null;
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fFinishListener = null;
            this.fActiveListeners = null;
            throw throwable;
        }
    }

    private TransferDragSourceListener getListener(TransferData transferData) {
        if (transferData == null) {
            return null;
        }
        Iterator iterator = this.fActiveListeners.iterator();
        while (iterator.hasNext()) {
            TransferDragSourceListener transferDragSourceListener = (TransferDragSourceListener)iterator.next();
            if (!transferDragSourceListener.getTransfer().isSupportedType(transferData)) continue;
            return transferDragSourceListener;
        }
        return null;
    }
}

