/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionRendererVisitor;
import org.eclipse.php.internal.ui.editor.contentassist.PHPContextInfoRendererVisitor;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.util.PHPCodeDataHTMLDescriptionUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CodeDataCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4 {
    private static final PHPCompletionRendererVisitor rendererVisitor = new PHPCompletionRendererVisitor();
    private static final PHPContextInfoRendererVisitor contextRendererVisitor = new PHPContextInfoRendererVisitor();
    protected static final char[] phpDelimiters = new char[]{'?', ':', ';', '|', '^', '&', '<', '>', '+', '-', '.', '*', '/', '%', '!', '~', '[', ']', '(', ')', '{', '}', '@', '\n', '\t', ' ', ',', '$', '\'', '\"'};
    private String displayText;
    private Image displayImage;
    private CodeData codeData;
    protected int replacementOffset;
    protected int replacementLength;
    protected int selectionLength;
    private String replacementString;
    private String prefix;
    private String suffix;
    private int caretOffsetInSuffix;
    private PHPProjectModel projectModel;
    private ContextInformation contextInfo;
    private boolean showTypeHints;

    public CodeDataCompletionProposal(CodeData codeData, int n, int n2, int n3, String string, String string2, int n4, boolean bl) {
        this.codeData = codeData;
        this.replacementOffset = n;
        this.replacementLength = n2;
        this.selectionLength = n3;
        this.prefix = string;
        this.suffix = string2;
        this.caretOffsetInSuffix = n4;
        this.showTypeHints = bl;
    }

    protected String getReplacementString() {
        if (this.replacementString == null) {
            this.replacementString = String.valueOf(this.prefix) + this.codeData.getName() + this.suffix;
        }
        return this.replacementString;
    }

    public void apply(IDocument iDocument) {
        try {
            boolean bl = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistInsertCompletion");
            if (!bl) {
                this.removeTrailingCharacters(iDocument);
            }
            iDocument.replace(this.replacementOffset, this.replacementLength + this.selectionLength, this.getReplacementString());
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void removeTrailingCharacters(IDocument iDocument) {
        try {
            int n = this.replacementOffset + this.replacementLength + this.selectionLength;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n);
            int n2 = iRegion.getOffset() + iRegion.getLength();
            while (n < n2) {
                char c = iDocument.getChar(n);
                if (CodeDataCompletionProposal.isDelimeter(c, phpDelimiters)) {
                    if (this.suffix.startsWith(String.valueOf(c))) {
                        this.suffix = "";
                    }
                    break;
                }
                ++this.replacementLength;
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static final boolean isDelimeter(char c, char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        IDocument iDocument = iTextViewer.getDocument();
        this.apply(iDocument);
        int n3 = this.replacementOffset + this.getReplacementString().length() - this.suffix.length() + this.caretOffsetInSuffix;
        iTextViewer.getSelectionProvider().setSelection((ISelection)new TextSelection(iDocument, n3, 0));
    }

    /*
     * Exception decompiling
     */
    public void selected(ITextViewer var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 71->75)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        String string = "";
        try {
            string = iDocument.get(this.replacementOffset, n - this.replacementOffset);
        }
        catch (BadLocationException badLocationException) {}
        boolean bl = this.codeData.getName().toLowerCase().startsWith(string.toLowerCase());
        if (bl) {
            this.replacementLength = string.length();
        }
        return bl;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public Point getSelection(IDocument iDocument) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        if (this.projectModel != null) {
            return PHPCodeDataHTMLDescriptionUtilities.getHTMLHyperlinkDescriptionText(this.codeData, this.projectModel);
        }
        return null;
    }

    public IContextInformation getContextInformation() {
        if (!this.showTypeHints) {
            return null;
        }
        if (this.contextInfo == null) {
            contextRendererVisitor.init(this.codeData);
            String string = contextRendererVisitor.getDisplayString().trim();
            if (string.length() > 0) {
                this.contextInfo = new ContextInformation(null, contextRendererVisitor.getDisplayString());
            }
        }
        return this.contextInfo;
    }

    public String getDisplayString() {
        this.initialize();
        return this.displayText;
    }

    public Image getImage() {
        this.initialize();
        return this.displayImage;
    }

    private void initialize() {
        if (this.displayText != null) {
            return;
        }
        rendererVisitor.init(this.codeData);
        this.displayText = rendererVisitor.getDisplayString();
        this.displayImage = rendererVisitor.getImage();
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        return this.prefix;
    }

    public int getPrefixCompletionStart(IDocument iDocument, int n) {
        return this.replacementOffset;
    }

    public CodeData getCodeData() {
        return this.codeData;
    }
}

