/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PHPManualConfig;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewPHPManualSiteDialog
extends StatusDialog {
    private static final String[] FILE_EXT = new String[]{"php", "htm", "html"};
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private static final String FILE_PROTO = "file://";
    private static final String CHM_PROTO = "mk:@MSITStore:";
    protected Text name;
    protected Text url;
    private Button okButton;
    private boolean enableOK = false;
    private List configs;
    private PHPManualConfig edited;
    private PHPManualConfig result;
    private Button remoteSiteBtn;
    private Button localDirectoryBtn;
    private Button chmFileBtn;
    private Text localDir;
    private Text chmFile;
    private Button dirBrowseButton;
    private Button chmBrowseButton;
    private Label fileExtLabel;
    private Combo fileExtCombo;

    public NewPHPManualSiteDialog(Shell shell, PHPManualConfig pHPManualConfig, List list) {
        super(shell);
        this.configs = new ArrayList(list.size());
        int n = 0;
        while (n < list.size()) {
            PHPManualConfig pHPManualConfig2 = (PHPManualConfig)list.get(n);
            if (!pHPManualConfig2.equals(pHPManualConfig)) {
                this.configs.add(pHPManualConfig2);
            }
            ++n;
        }
        this.edited = pHPManualConfig;
        if (pHPManualConfig != null) {
            this.setTitle(PHPUIMessages.NewPHPManualSiteDialog_updateTitle);
        } else {
            this.setTitle(PHPUIMessages.NewPHPManualSiteDialog_newTitle);
        }
    }

    public PHPManualConfig getResult() {
        return this.result;
    }

    protected void setResult(PHPManualConfig pHPManualConfig) {
        this.result = pHPManualConfig;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.okButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton.setEnabled(this.enableOK);
    }

    protected Control createDialogArea(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 15;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.widthHint = 400;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 0);
        label.setText(PHPUIMessages.NewPHPManualSiteDialog_name);
        this.name = new Text(composite3, 2048);
        gridData = new GridData(768);
        this.name.setLayoutData((Object)gridData);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.remoteSiteBtn = new Button(composite2, 16);
        this.remoteSiteBtn.setText(PHPUIMessages.getString("NewPHPManualSiteDialog_remoteSiteURL"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.remoteSiteBtn.setLayoutData((Object)gridData);
        this.remoteSiteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = NewPHPManualSiteDialog.this.remoteSiteBtn.getSelection();
                NewPHPManualSiteDialog.this.url.setEnabled(bl);
            }
        });
        this.url = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalIndent = this.convertWidthInCharsToPixels(3);
        gridData.horizontalSpan = 2;
        this.url.setLayoutData((Object)gridData);
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.localDirectoryBtn = new Button(composite2, 16);
        this.localDirectoryBtn.setText(PHPUIMessages.getString("NewPHPManualSiteDialog_localDirectory"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.localDirectoryBtn.setLayoutData((Object)gridData);
        this.localDirectoryBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = NewPHPManualSiteDialog.this.localDirectoryBtn.getSelection();
                NewPHPManualSiteDialog.this.localDir.setEnabled(bl);
                NewPHPManualSiteDialog.this.dirBrowseButton.setEnabled(bl);
            }
        });
        this.localDir = new Text(composite2, 2048);
        gridData = new GridData(768);
        gridData.horizontalIndent = this.convertWidthInCharsToPixels(3);
        this.localDir.setLayoutData((Object)gridData);
        this.localDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.dirBrowseButton = new Button(composite2, 0);
        gridData = new GridData();
        gridData.widthHint = 50;
        gridData.horizontalAlignment = 0x1000008;
        this.dirBrowseButton.setLayoutData((Object)gridData);
        this.dirBrowseButton.setText("...");
        this.dirBrowseButton.setAlignment(0x1000000);
        this.dirBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
                directoryDialog.setText(PHPUIMessages.NewPHPManualSiteDialog_chooseDir);
                String string = directoryDialog.open();
                if (string == null) {
                    return;
                }
                NewPHPManualSiteDialog.this.localDir.setText(string);
            }
        });
        if (isWindows) {
            this.chmFileBtn = new Button(composite2, 16);
            this.chmFileBtn.setText(PHPUIMessages.getString("NewPHPManualSiteDialog_windowsCHMFile"));
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.chmFileBtn.setLayoutData((Object)gridData);
            this.chmFileBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = NewPHPManualSiteDialog.this.chmFileBtn.getSelection();
                    NewPHPManualSiteDialog.this.chmFile.setEnabled(bl);
                    NewPHPManualSiteDialog.this.chmBrowseButton.setEnabled(bl);
                }
            });
            this.chmFile = new Text(composite2, 2048);
            gridData = new GridData(768);
            gridData.horizontalIndent = this.convertWidthInCharsToPixels(3);
            this.chmFile.setLayoutData((Object)gridData);
            this.chmFile.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    NewPHPManualSiteDialog.this.verifyComplete();
                }
            });
            this.chmBrowseButton = new Button(composite2, 0);
            gridData = new GridData();
            gridData.widthHint = 50;
            gridData.horizontalAlignment = 0x1000008;
            this.chmBrowseButton.setLayoutData((Object)gridData);
            this.chmBrowseButton.setText("...");
            this.chmBrowseButton.setAlignment(0x1000000);
            this.chmBrowseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog fileDialog = new FileDialog(PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
                    fileDialog.setText(PHPUIMessages.getString("NewPHPManualSiteDialog_chooseCHMFile"));
                    fileDialog.setFilterExtensions(new String[]{"*.chm"});
                    String string = fileDialog.open();
                    if (string == null) {
                        return;
                    }
                    NewPHPManualSiteDialog.this.chmFile.setText(string);
                }
            });
        }
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        composite4.setLayoutData((Object)gridData);
        this.fileExtLabel = new Label(composite4, 0);
        gridData = new GridData(768);
        this.fileExtLabel.setLayoutData((Object)gridData);
        this.fileExtLabel.setText(PHPUIMessages.getString("NewPHPManualSiteDialog_fileExtension"));
        this.fileExtCombo = new Combo(composite4, 8);
        this.fileExtCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewPHPManualSiteDialog.this.verifyComplete();
            }
        });
        this.fileExtCombo.setItems(FILE_EXT);
        this.fileExtCombo.select(0);
        this.initializeFields();
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void initializeFields() {
        if (this.edited != null) {
            this.name.setText(this.edited.getLabel());
            this.fileExtCombo.setText(this.edited.getExtension());
            String string = this.edited.getUrl();
            if (isWindows && string.startsWith(CHM_PROTO)) {
                int n = (string = string.substring(CHM_PROTO.length())).indexOf("::");
                if (n != -1) {
                    string = string.substring(0, n);
                }
                this.chmFile.setText(string);
                this.chmFileBtn.setSelection(true);
            } else if (string.startsWith(FILE_PROTO)) {
                string = string.substring(FILE_PROTO.length());
                this.localDir.setText(string);
                this.localDirectoryBtn.setSelection(true);
            } else {
                this.url.setText(string);
            }
        } else {
            this.url.setText("http://www.php.net/manual/en");
            this.remoteSiteBtn.setSelection(true);
        }
        this.remoteSiteBtn.notifyListeners(13, new Event());
        this.localDirectoryBtn.notifyListeners(13, new Event());
        if (isWindows) {
            this.chmFileBtn.notifyListeners(13, new Event());
        }
    }

    private void verifyComplete() {
        if (this.okButton == null) {
            return;
        }
        if (this.name.getText().trim().length() == 0) {
            this.okButton.setEnabled(false);
            this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_siteNotSpecified, null));
            return;
        }
        if (this.isDuplicate()) {
            return;
        }
        this.okButton.setEnabled(true);
        this.updateStatus((IStatus)new Status(0, PHPUiPlugin.getPluginId(), 0, "", null));
        if (this.remoteSiteBtn.getSelection()) {
            try {
                String string = this.url.getText().trim();
                new URL(URLDecoder.decode(string, "UTF-8"));
                this.result = new PHPManualConfig(this.name.getText(), string, this.fileExtCombo.getText(), false);
            }
            catch (Exception exception) {
                this.okButton.setEnabled(false);
                this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_incorrectUrl, null));
                return;
            }
        } else if (this.localDirectoryBtn.getSelection()) {
            String string = this.localDir.getText().trim();
            if (!new File(string).isDirectory()) {
                this.okButton.setEnabled(false);
                this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.getString("NewPHPManualSiteDialog_dirDoesntExist"), null));
                return;
            }
            this.result = new PHPManualConfig(this.name.getText(), FILE_PROTO + string, this.fileExtCombo.getText(), false);
        } else if (isWindows) {
            String string = this.chmFile.getText().trim();
            if (!new File(string).isFile()) {
                this.okButton.setEnabled(false);
                this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.getString("NewPHPManualSiteDialog_fileDoesntExist"), null));
                return;
            }
            this.result = new PHPManualConfig(this.name.getText(), CHM_PROTO + string + "::/en", this.fileExtCombo.getText(), false);
        }
    }

    private boolean isDuplicate() {
        if (this.configs == null) {
            return false;
        }
        int n = 0;
        while (n < this.configs.size()) {
            PHPManualConfig pHPManualConfig;
            if (!this.isCurrentlyEditedSiteBookmark(n) && (pHPManualConfig = (PHPManualConfig)this.configs.get(n)).getLabel().equals(this.name.getText().trim())) {
                this.okButton.setEnabled(false);
                this.updateStatus((IStatus)new Status(4, PHPUiPlugin.getPluginId(), 0, PHPUIMessages.NewPHPManualSiteDialog_nameAlreadyInUse, null));
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isCurrentlyEditedSiteBookmark(int n) {
        return false;
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        if (this.okButton != null && !this.okButton.isDisposed() && this.name.getText().trim().length() != 0) {
            this.okButton.setEnabled(!iStatus.matches(4));
        }
    }
}

