/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.JavaFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class PHPOpenExternalFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private String fFilterPath;
    private StringBuffer notFound = new StringBuffer();

    public PHPOpenExternalFileAction() {
        this.setEnabled(true);
    }

    public void dispose() {
        this.fWindow = null;
        this.fFilterPath = null;
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fWindow = iWorkbenchWindow;
        this.fFilterPath = System.getProperty("user.home");
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void run(List list) {
        if (list != null) {
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Path path = new Path(string);
                this.fFilterPath = path.removeLastSegments(1).toOSString();
                IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(this.fFilterPath));
                if (!(iFileStore = iFileStore.getChild(path.lastSegment())).fetchInfo().isDirectory() && iFileStore.fetchInfo().exists()) {
                    IEditorInput iEditorInput = this.createEditorInput(iFileStore);
                    String string2 = this.getEditorId(iFileStore);
                    IWorkbenchPage iWorkbenchPage = this.fWindow.getActivePage();
                    try {
                        iWorkbenchPage.openEditor(iEditorInput, string2);
                    }
                    catch (PartInitException partInitException) {
                        Logger.logException("Failed opening file called externally", partInitException);
                    }
                    continue;
                }
                if (++n > 1) {
                    this.notFound.append('\n');
                }
                this.notFound.append(string);
            }
        }
    }

    public String getFileNotFoundStr() {
        return this.notFound.toString();
    }

    private String getEditorId(IFileStore iFileStore) {
        IWorkbench iWorkbench = this.fWindow.getWorkbench();
        IEditorRegistry iEditorRegistry = iWorkbench.getEditorRegistry();
        IEditorDescriptor iEditorDescriptor = iEditorRegistry.getDefaultEditor(iFileStore.getName(), this.getContentType(iFileStore));
        if (iEditorDescriptor == null && iEditorRegistry.isSystemInPlaceEditorAvailable(iFileStore.getName())) {
            iEditorDescriptor = iEditorRegistry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (iEditorDescriptor == null && iEditorRegistry.isSystemExternalEditorAvailable(iFileStore.getName())) {
            iEditorDescriptor = iEditorRegistry.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (iEditorDescriptor != null) {
            return iEditorDescriptor.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * Unable to fully structure code
     */
    private IContentType getContentType(IFileStore var1_1) {
        if (var1_1 == null) {
            return null;
        }
        var2_2 = null;
        var2_2 = var1_1.openInputStream(0, null);
        var6_3 = Platform.getContentTypeManager().findContentTypeFor(var2_2, var1_1.getName());
        var4_4 = null;
        try {
            if (var2_2 != null) {
                var2_2.close();
            }
        }
        catch (IOException var7_7) {
            EditorsPlugin.log((Throwable)var7_7);
        }
        return var6_3;
        catch (IOException var3_10) {
            EditorsPlugin.log((Throwable)var3_10);
lbl21:
            // 3 sources

            while (true) {
                var4_5 = null;
                try {
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                }
                catch (IOException var7_8) {
                    EditorsPlugin.log((Throwable)var7_8);
                }
                return null;
            }
        }
        catch (CoreException var3_11) {
            if (var3_11.getStatus().getException() instanceof FileNotFoundException) ** GOTO lbl21
            EditorsPlugin.log((Throwable)var3_11);
            ** continue;
            {
                catch (Throwable var5_12) {
                    var4_6 = null;
                    try {
                        if (var2_2 != null) {
                            var2_2.close();
                        }
                    }
                    catch (IOException var7_9) {
                        EditorsPlugin.log((Throwable)var7_9);
                    }
                    throw var5_12;
                }
            }
        }
    }

    private IEditorInput createEditorInput(IFileStore iFileStore) {
        IFile iFile = this.getWorkspaceFile(iFileStore);
        if (iFile != null) {
            return new FileEditorInput(iFile);
        }
        return new JavaFileEditorInput(iFileStore);
    }

    private IFile getWorkspaceFile(IFileStore iFileStore) {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IFile[] iFileArray = iWorkspace.getRoot().findFilesForLocation((IPath)new Path(iFileStore.toURI().getPath()));
        if ((iFileArray = this.filterNonExistentFiles(iFileArray)) == null || iFileArray.length == 0) {
            return null;
        }
        if (iFileArray.length == 1) {
            return iFileArray[0];
        }
        return this.selectWorkspaceFile(iFileArray);
    }

    private IFile[] filterNonExistentFiles(IFile[] iFileArray) {
        if (iFileArray == null) {
            return null;
        }
        int n = iFileArray.length;
        ArrayList<IFile> arrayList = new ArrayList<IFile>(n);
        int n2 = 0;
        while (n2 < n) {
            if (iFileArray[n2].exists()) {
                arrayList.add(iFileArray[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    private IFile selectWorkspaceFile(IFile[] iFileArray) {
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.fWindow.getShell(), (ILabelProvider)new FileLabelProvider());
        elementListSelectionDialog.setElements((Object[])iFileArray);
        if (elementListSelectionDialog.open() == 0) {
            return (IFile)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        public String getText(Object object) {
            if (object instanceof IFile) {
                IPath iPath = ((IFile)object).getFullPath();
                return iPath != null ? iPath.toString() : "";
            }
            return super.getText(object);
        }
    }
}

