/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.debug.core.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;

public class BreakpointSet {
    private IProject fProject;
    private ArrayList fZips;
    private ArrayList fDirectories;
    private ArrayList fProjects;
    private boolean fIsPHPCGI;

    public BreakpointSet(IProject iProject, boolean bl) {
        IIncludePathEntry[] iIncludePathEntryArray;
        PHPProjectOptions pHPProjectOptions;
        this.fProject = iProject;
        this.fIsPHPCGI = bl;
        this.fZips = new ArrayList();
        this.fDirectories = new ArrayList();
        this.fProjects = new ArrayList();
        if (iProject == null) {
            // empty if block
        }
        if ((pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject)) != null && (iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath()) != null) {
            int n = 0;
            while (n < iIncludePathEntryArray.length) {
                File file;
                Object object;
                IPath iPath;
                if (iIncludePathEntryArray[n].getEntryKind() == 1) {
                    iPath = iIncludePathEntryArray[n].getPath();
                    object = new File(iPath.toString());
                    if (iIncludePathEntryArray[n].getContentKind() == 2) {
                        this.fZips.add(RemoteDebugger.convertToSystemIndependentFileName(((File)object).getAbsolutePath()));
                    } else {
                        this.fDirectories.add(RemoteDebugger.convertToSystemIndependentFileName(((File)object).getAbsolutePath()));
                    }
                } else if (iIncludePathEntryArray[n].getEntryKind() == 2) {
                    iPath = iIncludePathEntryArray[n].getResource();
                    if (iPath instanceof IProject) {
                        this.fProjects.add(iPath);
                    }
                } else if (iIncludePathEntryArray[n].getEntryKind() == 4 && (file = this.getVariableFile((String)(object = (iPath = iIncludePathEntryArray[n].getPath()).toString()))) != null) {
                    if (file.isDirectory()) {
                        this.fDirectories.add(RemoteDebugger.convertToSystemIndependentFileName(file.getAbsolutePath()));
                    } else {
                        String string = file.getName();
                        if (string.toLowerCase().endsWith(".zip")) {
                            this.fZips.add(RemoteDebugger.convertToSystemIndependentFileName(file.getAbsolutePath()));
                        }
                    }
                }
                ++n;
            }
        }
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        if (this.fProject == null) {
            return true;
        }
        PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)iBreakpoint;
        IMarker iMarker = pHPLineBreakpoint.getMarker();
        IResource iResource = null;
        if (iBreakpoint instanceof PHPRunToLineBreakpoint) {
            return true;
        }
        iResource = iMarker.getResource();
        if (!this.fIsPHPCGI) {
            if (iResource instanceof IWorkspaceRoot) {
                try {
                    if (iMarker.getAttribute("org.eclipse.php.debug.core.Non_Workspace_Breakpoint") == Boolean.TRUE) {
                        return true;
                    }
                }
                catch (CoreException coreException) {}
                String string = iMarker.getAttribute("org.eclipse.php.debug.core.Include_Storage_Type", "");
                String string2 = iMarker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", "");
                String string3 = iMarker.getAttribute("org.eclipse.php.debug.core.Include_Storage", "");
                String string4 = string2.substring(0, string2.length() - (string3.length() + 1));
                if (string.equals("org.eclipse.php.debug.core.zip")) {
                    Object[] objectArray = this.fZips.toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        if (string4.equals((String)objectArray[n])) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                if (string.equals("org.eclipse.php.debug.core.lfile")) {
                    Object[] objectArray = this.fDirectories.toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        if (string4.equals((String)objectArray[n])) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                return true;
            }
            IProject iProject = iResource.getProject();
            if (this.fProject.equals((Object)iProject)) {
                return true;
            }
            return this.fProjects.contains(iProject);
        }
        if (iResource instanceof IWorkspaceRoot) {
            try {
                if (iMarker.getAttribute("org.eclipse.php.debug.core.Non_Workspace_Breakpoint") == Boolean.TRUE) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
            return false;
        }
        IProject iProject = iResource.getProject();
        return this.fProject.equals((Object)iProject);
    }

    private File getVariableFile(String string) {
        IPath iPath;
        int n = string.indexOf(47);
        String string2 = "";
        if (n != -1) {
            if (n + 1 < string.length()) {
                string2 = string.substring(n + 1);
            }
            string = string.substring(0, n);
        }
        if ((iPath = PHPProjectOptions.getIncludePathVariable((String)string)) == null) {
            return null;
        }
        iPath = iPath.append(string2);
        return iPath.toFile();
    }
}

