/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPDocLanguageModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.util.WeakPropertyChangeListener;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.ui.editor.contentassist.CompletionProposalGroup;
import org.eclipse.php.internal.ui.editor.contentassist.ContentAssistSupport;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;

public class PHPDocContentAssistSupport
extends ContentAssistSupport {
    private static final char TAG_SIGN = '@';
    private char[] autoActivationTriggers;
    private CompletionProposalGroup phpDocCompletionProposalGroup = new ContentAssistSupport.PHPCompletionProposalGroup();
    protected IPropertyChangeListener prefChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null) {
                PHPDocContentAssistSupport.this.initPreferences(propertyChangeEvent.getProperty());
            }
        }
    };

    protected void initPreferences(String string) {
        if (string == null || "contentAssistAutoactivationTriggersPHPDoc".equals(string)) {
            this.autoActivationTriggers = PreferenceConstants.getPreferenceStore().getString("contentAssistAutoactivationTriggersPHPDoc").trim().toCharArray();
        }
    }

    public PHPDocContentAssistSupport() {
        this.initPreferences(null);
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)WeakPropertyChangeListener.create((IPropertyChangeListener)this.prefChangeListener, (Object)PreferenceConstants.getPreferenceStore()));
    }

    public char[] getAutoactivationTriggers() {
        return this.autoActivationTriggers;
    }

    protected void calcCompletionOption(DOMModelForPHP dOMModelForPHP, int n, ITextViewer iTextViewer, boolean bl) throws BadLocationException {
        boolean bl2;
        Object object;
        Object object2;
        ITextRegion iTextRegion;
        int n2;
        PHPFileData pHPFileData;
        int n3 = iTextViewer.getSelectedRange().x;
        boolean bl3 = n3 != n;
        PHPProjectModel pHPProjectModel = dOMModelForPHP.getProjectModel();
        if (pHPProjectModel == null) {
            pHPProjectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        }
        if ((pHPFileData = dOMModelForPHP.getFileData(true)) != null) {
            pHPFileData.getName();
        }
        int n4 = ((TextSelection)iTextViewer.getSelectionProvider().getSelection()).getLength();
        IStructuredDocumentRegion iStructuredDocumentRegion = ContentAssistUtils.getStructuredDocumentRegion((StructuredTextViewer)((StructuredTextViewer)iTextViewer), (int)n);
        ITextRegion iTextRegion2 = null;
        iTextRegion2 = n == dOMModelForPHP.getStructuredDocument().getLength() ? iStructuredDocumentRegion.getLastRegion() : iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion2 == null) {
            return;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
        if (iTextRegion2 instanceof ITextRegionContainer) {
            iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion2;
            iTextRegion2 = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
        }
        if (iTextRegion2.getType() == "PHP_OPEN") {
            return;
        }
        if (iTextRegion2.getType() == "PHP_CLOSE") {
            if (iStructuredDocumentRegion.getStartOffset(iTextRegion2) == n) {
                ITextRegion iTextRegion3 = iStructuredDocumentRegion.getRegionAtCharacterOffset(n - 1);
                if (iTextRegion3 instanceof PhpScriptRegion) {
                    iTextRegion2 = iTextRegion3;
                }
            } else {
                return;
            }
        }
        if ((n2 = iStructuredDocumentRegion2.getStartOffset(iTextRegion2)) == n) {
            iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n - 1);
            object2 = null;
            if (iTextRegion != null || (object2 = iStructuredDocumentRegion.getPrevious()) != null && (iTextRegion = object2.getRegionAtCharacterOffset(n - 1)) != null) {
                iTextRegion.getType();
            }
            n2 = iStructuredDocumentRegion.getStartOffset(iTextRegion2);
        }
        iTextRegion = null;
        object2 = null;
        int n5 = 0;
        if (iTextRegion2 instanceof PhpScriptRegion) {
            iTextRegion = (PhpScriptRegion)iTextRegion2;
            n5 = n - iStructuredDocumentRegion2.getStartOffset() - iTextRegion.getStart();
            object2 = iTextRegion.getPartition(n5);
            if (!(object2 != "org.eclipse.php.PHP_MULTI_LINE_COMMENT" && object2 != "org.eclipse.php.PHP_DOC" || (object = iTextRegion.getPhpToken(n5).getType()) != "PHP_COMMENT_START" && object != "PHPDOC_COMMENT_START" || iTextRegion.getPhpToken(n5).getStart() != n5)) {
                object2 = iTextRegion.getPartition(n5 - 1);
            }
            if (!((String)object2).equals("org.eclipse.php.PHP_DOC")) {
                return;
            }
            ContextRegion cfr_ignored_0 = (ContextRegion)iTextRegion.getPhpToken(n5);
        }
        iStructuredDocumentRegion.getParentDocument();
        if (pHPFileData == null || iTextRegion == null) {
            return;
        }
        object = PHPTextSequenceUtilities.getStatment((int)n, (IStructuredDocumentRegion)iStructuredDocumentRegion, (boolean)false);
        int n6 = object.length();
        int n7 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)object, (int)n6);
        int n8 = PHPTextSequenceUtilities.readIdentifiarStartIndex((TextSequence)object, (int)n7, (boolean)true);
        String string = object.subSequence(n8, n7).toString();
        boolean bl4 = bl2 = n6 != n7;
        if (this.isInPhpDocCompletion(iTextViewer, (CharSequence)object, n, string, n4, bl2, bl)) {
            return;
        }
        if (this.isVariableCompletion(dOMModelForPHP, pHPFileData, n, string, n4, bl2)) {
            return;
        }
        if (bl) {
            this.templateProposals = this.getTemplates(iTextViewer, n);
        }
    }

    private boolean isInPhpDocCompletion(ITextViewer iTextViewer, CharSequence charSequence, int n, String string, int n2, boolean bl, boolean bl2) {
        if (bl) {
            return false;
        }
        int n3 = charSequence.length() - string.length();
        if (n3 <= 0 || charSequence.charAt(n3 - 1) != '@') {
            return false;
        }
        --n3;
        boolean bl3 = false;
        while (n3 > 0) {
            if (!Character.isWhitespace(charSequence.charAt(n3 - 1))) {
                if (bl3 || charSequence.charAt(n3 - 1) != '*') break;
                bl3 = true;
            }
            --n3;
        }
        CodeData[] codeDataArray = PHPDocLanguageModel.getPHPDocTags((String)string);
        this.phpDocCompletionProposalGroup.setData(n, codeDataArray, string, n2);
        this.completionProposalGroup = this.phpDocCompletionProposalGroup;
        if (bl2) {
            this.templateProposals = this.getTemplates(iTextViewer, n);
        }
        return true;
    }

    private boolean isVariableCompletion(DOMModelForPHP dOMModelForPHP, PHPFileData pHPFileData, int n, String string, int n2, boolean bl) {
        if (bl) {
            return false;
        }
        if (string.startsWith("$")) {
            CodeData[] codeDataArray;
            string = string.substring(1);
            PHPCodeContext pHPCodeContext = ModelSupport.createContext((PHPFileData)pHPFileData, (int)n);
            PHPProjectModel pHPProjectModel = dOMModelForPHP.getProjectModel();
            String string2 = pHPFileData.getName();
            CodeData[] codeDataArray2 = pHPProjectModel.getVariables(string2, pHPCodeContext, string, true);
            PHPClassData[] pHPClassDataArray = pHPFileData.getClasses();
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < pHPClassDataArray.length) {
                CodeData codeData = this.isInClassBlocks(pHPClassDataArray[n3], n);
                if (codeData != null) {
                    pHPCodeContext = ModelSupport.createContext((CodeData)codeData);
                    codeDataArray = pHPProjectModel.getVariables(string2, pHPCodeContext, string, false);
                    codeDataArray2 = this.mergeCodeData(codeDataArray2, codeDataArray);
                    bl2 = true;
                    break;
                }
                ++n3;
            }
            if (!bl2) {
                PHPFunctionData[] pHPFunctionDataArray = pHPFileData.getFunctions();
                int n4 = 0;
                while (n4 < pHPFunctionDataArray.length) {
                    if (this.isInBlock((PHPCodeData)pHPFunctionDataArray[n4], n)) {
                        pHPCodeContext = ModelSupport.createContext((CodeData)pHPFunctionDataArray[n4]);
                        codeDataArray = pHPProjectModel.getVariables(string2, pHPCodeContext, string, false);
                        codeDataArray2 = this.mergeCodeData(codeDataArray2, codeDataArray);
                        break;
                    }
                    ++n4;
                }
            }
            this.completionProposalGroup = this.phpCompletionProposalGroup;
            this.completionProposalGroup.setData(n, codeDataArray2, string, n2);
            return true;
        }
        return false;
    }

    private CodeData isInClassBlocks(PHPClassData pHPClassData, int n) {
        if (this.isInBlock((PHPCodeData)pHPClassData, n)) {
            return pHPClassData;
        }
        PHPFunctionData[] pHPFunctionDataArray = pHPClassData.getFunctions();
        int n2 = 0;
        while (n2 < pHPFunctionDataArray.length) {
            if (this.isInBlock((PHPCodeData)pHPFunctionDataArray[n2], n)) {
                return pHPFunctionDataArray[n2];
            }
            ++n2;
        }
        return null;
    }

    private CodeData[] mergeCodeData(CodeData[] codeDataArray, CodeData[] codeDataArray2) {
        CodeData[] codeDataArray3 = new CodeData[codeDataArray.length + codeDataArray2.length];
        System.arraycopy(codeDataArray, 0, codeDataArray3, 0, codeDataArray.length);
        System.arraycopy(codeDataArray2, 0, codeDataArray3, codeDataArray.length, codeDataArray2.length);
        return codeDataArray3;
    }

    private boolean isInBlock(PHPCodeData pHPCodeData, int n) {
        return pHPCodeData.getDocBlock() != null ? pHPCodeData.getDocBlock().containsPosition(n) : false;
    }

    protected String getTemplateContext() {
        return "phpdoc";
    }
}

