/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.IPVariableElement;
import org.eclipse.php.internal.ui.preferences.includepath.IPVariableElementLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.VariableCreationDialog;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class VariableBlock {
    private ListDialogField fVariablesList;
    private Control fControl;
    private boolean fHasChanges;
    private List fSelectedElements = new ArrayList(0);
    private boolean fAskToBuild;
    private boolean fInPreferencePage;

    public VariableBlock(boolean bl, String string) {
        this.fInPreferencePage = bl;
        this.fAskToBuild = true;
        String[] stringArray = new String[]{PHPUIMessages.VariableBlock_vars_add_button, PHPUIMessages.VariableBlock_vars_edit_button, PHPUIMessages.VariableBlock_vars_remove_button};
        VariablesAdapter variablesAdapter = new VariablesAdapter();
        IPVariableElementLabelProvider iPVariableElementLabelProvider = new IPVariableElementLabelProvider(!bl);
        this.fVariablesList = new ListDialogField(variablesAdapter, stringArray, (ILabelProvider)iPVariableElementLabelProvider);
        this.fVariablesList.setDialogFieldListener(variablesAdapter);
        this.fVariablesList.setLabelText(PHPUIMessages.VariableBlock_vars_label);
        this.fVariablesList.setRemoveButtonIndex(2);
        this.fVariablesList.enableButton(1, false);
        this.fVariablesList.setViewerSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof IPVariableElement && object2 instanceof IPVariableElement) {
                    return ((IPVariableElement)object).getName().compareTo(((IPVariableElement)object2).getName());
                }
                return super.compare(viewer, object, object2);
            }
        });
        this.refresh(string);
    }

    public boolean hasChanges() {
        return this.fHasChanges;
    }

    public void setChanges(boolean bl) {
        this.fHasChanges = bl;
    }

    public Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        LayoutUtil.doDefaultLayout(composite2, new DialogField[]{this.fVariablesList}, true, 0, 0);
        LayoutUtil.setHorizontalGrabbing(this.fVariablesList.getListControl(null));
        this.fControl = composite2;
        return composite2;
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.fVariablesList.getTableViewer().addDoubleClickListener(iDoubleClickListener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fVariablesList.getTableViewer().addSelectionChangedListener(iSelectionChangedListener);
    }

    private Shell getShell() {
        if (this.fControl != null) {
            return this.fControl.getShell();
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }

    private boolean containsReserved(List list) {
        int n = list.size() - 1;
        while (n >= 0) {
            if (((IPVariableElement)list.get(n)).isReserved()) {
                return true;
            }
            --n;
        }
        return false;
    }

    private static void addAll(Object[] objectArray, Collection collection) {
        int n = 0;
        while (n < objectArray.length) {
            collection.add(objectArray[n]);
            ++n;
        }
    }

    private boolean canEdit(List list, boolean bl) {
        return list.size() == 1 && !bl;
    }

    private void doSelectionChanged(DialogField dialogField) {
        List list = this.fVariablesList.getSelectedElements();
        boolean bl = this.containsReserved(list);
        this.fVariablesList.enableButton(1, this.canEdit(list, bl));
        this.fVariablesList.enableButton(2, !bl);
        this.fSelectedElements = list;
    }

    private void editEntries(IPVariableElement iPVariableElement) {
        List list = this.fVariablesList.getElements();
        VariableCreationDialog variableCreationDialog = new VariableCreationDialog(this.getShell(), iPVariableElement, list);
        if (variableCreationDialog.open() != 0) {
            return;
        }
        IPVariableElement iPVariableElement2 = variableCreationDialog.getIncludePathElement();
        if (iPVariableElement == null) {
            this.fVariablesList.addElement(iPVariableElement2);
            iPVariableElement = iPVariableElement2;
            this.fHasChanges = true;
        } else {
            boolean bl;
            boolean bl2 = bl = !iPVariableElement.getName().equals(iPVariableElement2.getName()) || !iPVariableElement.getPath().equals((Object)iPVariableElement2.getPath());
            if (bl) {
                this.fHasChanges = true;
                iPVariableElement.setName(iPVariableElement2.getName());
                iPVariableElement.setPath(iPVariableElement2.getPath());
                this.fVariablesList.refresh();
            }
        }
        this.fVariablesList.selectElements((ISelection)new StructuredSelection((Object)iPVariableElement));
    }

    public List getSelectedElements() {
        return this.fSelectedElements;
    }

    public void performDefaults() {
        this.fVariablesList.removeAllElements();
        String[] stringArray = IncludePathVariableManager.instance().getReservedVariables();
        int n = 0;
        while (n < stringArray.length) {
            IPVariableElement iPVariableElement = new IPVariableElement(stringArray[n], (IPath)Path.EMPTY, true);
            iPVariableElement.setReserved(true);
            this.fVariablesList.addElement(iPVariableElement);
            ++n;
        }
        this.fHasChanges = true;
    }

    public boolean performOk() {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(PHPProjectOptions.getIncludePathVariableNames()));
        List list = this.fVariablesList.getElements();
        List list2 = this.fVariablesList.getElements();
        int n = list.size() - 1;
        while (n >= 0) {
            IPVariableElement iPVariableElement = (IPVariableElement)list.get(n);
            if (iPVariableElement.isReserved()) {
                list.remove(iPVariableElement);
            } else {
                object2 = iPVariableElement.getPath();
                object = PHPProjectOptions.getIncludePathVariable((String)iPVariableElement.getName());
                if (object != null && object.equals(object2)) {
                    list.remove(iPVariableElement);
                } else {
                    arrayList2.add(iPVariableElement.getName());
                    list2.remove(iPVariableElement);
                }
            }
            arrayList.remove(iPVariableElement.getName());
            --n;
        }
        n = list.size() + arrayList.size();
        if (n > 0) {
            boolean bl = false;
            if (this.fAskToBuild && this.doesChangeRequireFullBuild(arrayList, arrayList2)) {
                object2 = PHPUIMessages.VariableBlock_needsbuild_title;
                object = PHPUIMessages.VariableBlock_needsbuild_message;
                MessageDialog messageDialog = new MessageDialog(this.getShell(), (String)object2, null, (String)object, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int n2 = messageDialog.open();
                if (n2 != 0 && n2 != 1) {
                    return false;
                }
                bl = n2 == 0;
            }
            object2 = new VariableBlockRunnable(arrayList, list, list2, bl);
            object = new Job(PHPUIMessages.VariableBlock_job_description, (VariableBlockRunnable)object2){
                private final /* synthetic */ VariableBlockRunnable val$runnable;
                {
                    this.val$runnable = variableBlockRunnable;
                    super(string);
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    try {
                        try {
                            this.val$runnable.setVariables(iProgressMonitor);
                        }
                        catch (CoreException coreException) {
                            IStatus iStatus = coreException.getStatus();
                            Object var3_5 = null;
                            iProgressMonitor.done();
                            return iStatus;
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            Object var3_6 = null;
                            iProgressMonitor.done();
                            return iStatus;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_7 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_8 = null;
                    }
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            };
            object.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
            object.setUser(true);
            object.schedule();
            return true;
        }
        return true;
    }

    private boolean doesChangeRequireFullBuild(List list, List list2) {
        IProject[] iProjectArray = PHPWorkspaceModelManager.getInstance().listProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            PHPProjectOptions pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProjectArray[n]);
            IIncludePathEntry[] iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath();
            int n2 = 0;
            while (n2 < iIncludePathEntryArray.length) {
                String string;
                IIncludePathEntry iIncludePathEntry = iIncludePathEntryArray[n2];
                if (iIncludePathEntry.getEntryKind() == 4 && (list.contains(string = iIncludePathEntry.getPath().segment(0)) || list2.contains(string))) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public void setAskToBuild(boolean bl) {
        this.fAskToBuild = bl;
    }

    public void refresh(String string) {
        IPVariableElement iPVariableElement = null;
        Object[] objectArray = IncludePathVariableManager.instance().getReservedVariables();
        ArrayList arrayList = new ArrayList(objectArray.length);
        VariableBlock.addAll(objectArray, arrayList);
        String[] stringArray = PHPProjectOptions.getIncludePathVariableNames();
        ArrayList<IPVariableElement> arrayList2 = new ArrayList<IPVariableElement>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            IPath iPath = PHPProjectOptions.getIncludePathVariable((String)string2);
            if (iPath != null) {
                IPVariableElement iPVariableElement2 = new IPVariableElement(string2, iPath, arrayList.contains(string2));
                arrayList2.add(iPVariableElement2);
                if (string2.equals(string)) {
                    iPVariableElement = iPVariableElement2;
                }
            } else {
                PHPCorePlugin.logErrorMessage((String)("VariableBlock: IncludePath variable with null value: " + string2));
            }
            ++n;
        }
        this.fVariablesList.setElements(arrayList2);
        if (iPVariableElement != null) {
            StructuredSelection structuredSelection = new StructuredSelection(iPVariableElement);
            this.fVariablesList.selectElements((ISelection)structuredSelection);
        } else {
            this.fVariablesList.selectFirstElement();
        }
        this.fHasChanges = false;
    }

    private class VariableBlockRunnable
    implements IRunnableWithProgress {
        private List fToRemove;
        private List fToChange;
        private List fUnchanged;
        private boolean fDoBuild;

        public VariableBlockRunnable(List list, List list2, List list3, boolean bl) {
            this.fToRemove = list;
            this.fToChange = list2;
            this.fUnchanged = list3;
            this.fDoBuild = bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            iProgressMonitor.beginTask(PHPUIMessages.VariableBlock_operation_desc, this.fDoBuild ? 2 : 1);
            try {
                try {
                    this.setVariables(iProgressMonitor);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new InterruptedException();
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            iProgressMonitor.done();
        }

        public void setVariables(IProgressMonitor iProgressMonitor) throws CoreException {
            IPVariableElement iPVariableElement;
            int n = this.fToChange.size() + this.fToRemove.size() + this.fUnchanged.size();
            String[] stringArray = new String[n];
            IPath[] iPathArray = new IPath[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.fUnchanged.size()) {
                iPVariableElement = (IPVariableElement)this.fUnchanged.get(n3);
                stringArray[n2] = iPVariableElement.getName();
                iPathArray[n2] = iPVariableElement.getPath();
                ++n2;
                ++n3;
            }
            n3 = 0;
            while (n3 < this.fToChange.size()) {
                iPVariableElement = (IPVariableElement)this.fToChange.get(n3);
                stringArray[n2] = iPVariableElement.getName();
                iPathArray[n2] = iPVariableElement.getPath();
                ++n2;
                ++n3;
            }
            n3 = 0;
            while (n3 < this.fToRemove.size()) {
                stringArray[n2] = (String)this.fToRemove.get(n3);
                iPathArray[n2] = null;
                ++n2;
                ++n3;
            }
            PHPProjectOptions.setIncludePathVariables((String[])stringArray, (IPath[])iPathArray, (SubProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (this.fDoBuild) {
                ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            }
        }
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private VariablesAdapter() {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            switch (n) {
                case 0: {
                    VariableBlock.this.editEntries(null);
                    break;
                }
                case 1: {
                    List list = listDialogField.getSelectedElements();
                    VariableBlock.this.editEntries((IPVariableElement)list.get(0));
                }
            }
        }

        public void selectionChanged(ListDialogField listDialogField) {
            VariableBlock.this.doSelectionChanged(listDialogField);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            List list;
            if (VariableBlock.this.fInPreferencePage && VariableBlock.this.canEdit(list = listDialogField.getSelectedElements(), VariableBlock.this.containsReserved(list))) {
                VariableBlock.this.editEntries((IPVariableElement)list.get(0));
            }
        }

        public void dialogFieldChanged(DialogField dialogField) {
        }
    }
}

