/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search.text;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.internal.ui.search.text.ResultVisitor;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;

public class TextSearcher {
    public final TextSearchEngine engine;
    public final TextSearchScope scope;
    public final ResultVisitor visitor;
    public final Pattern searchPattern;
    private boolean done;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.internal.ui.search.text.TextSearcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    TextSearcher(TextSearchEngine textSearchEngine, TextSearchScope textSearchScope, ResultVisitor resultVisitor, Pattern pattern) {
        if (textSearchEngine == null || textSearchScope == null || resultVisitor == null) {
            throw new IllegalArgumentException();
        }
        this.engine = textSearchEngine;
        this.scope = textSearchScope;
        this.visitor = resultVisitor;
        this.searchPattern = pattern;
        this.done = false;
    }

    public final boolean isDone() {
        return this.done;
    }

    public static final TextSearcher createSearcher(TextSearchEngine textSearchEngine, TextSearchScope textSearchScope, ResultVisitor resultVisitor, Pattern pattern) {
        return new TextSearcher(textSearchEngine, textSearchScope, resultVisitor, pattern);
    }

    public static final TextSearcher createSearcher(TextSearchScope textSearchScope, ResultVisitor resultVisitor, Pattern pattern) {
        TextSearchEngine textSearchEngine = TextSearchEngine.createDefault();
        return TextSearcher.createSearcher(textSearchEngine, textSearchScope, resultVisitor, pattern);
    }

    public static final TextSearcher createSearcher(IResource iResource, ResultVisitor resultVisitor, Pattern pattern) {
        TextSearchScope textSearchScope = TextSearchScope.newSearchScope((IResource[])new IResource[]{iResource}, null, (boolean)true);
        return TextSearcher.createSearcher(textSearchScope, resultVisitor, pattern);
    }

    public static final TextSearcher createSearcher(IResource iResource, Pattern pattern) {
        ResultVisitor resultVisitor = new ResultVisitor();
        return TextSearcher.createSearcher(iResource, resultVisitor, pattern);
    }

    public static final TextSearcher createSearcher(IResource iResource, String string) {
        Pattern pattern = Pattern.compile(string);
        return TextSearcher.createSearcher(iResource, pattern);
    }

    public void search(IProgressMonitor iProgressMonitor) {
        if (!$assertionsDisabled && this.done) {
            throw new AssertionError();
        }
        this.engine.search(this.scope, (TextSearchRequestor)this.visitor, this.searchPattern, iProgressMonitor);
        this.done = true;
    }

    public List getResults() {
        if (!$assertionsDisabled && !this.done) {
            throw new AssertionError();
        }
        return this.visitor.getResult();
    }
}

