/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.ui.util.ACodeDataResolver;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;

public class EditorCodeDataResolver
extends ACodeDataResolver {
    private static final char SINGLE_QUOTE = '\'';
    protected ITextViewer fileSource;
    private IStructuredDocumentRegion documentRegion;
    private ITextRegion phpToken;
    private String phpTokenType;

    public void initialize(ITextViewer iTextViewer, int n) {
        super.initialize(iTextViewer, n);
    }

    protected boolean isSingleQuoted() {
        return PHPPartitionTypes.isPHPQuotesState((String)this.getPhpTokenType()) && this.getDocumentRegion().getText(this.getPhpToken()).charAt(0) == '\'';
    }

    protected boolean isCommented() {
        return PHPPartitionTypes.isPHPCommentState((String)this.getPhpTokenType());
    }

    private IStructuredDocumentRegion getDocumentRegion() {
        if (this.documentRegion != null) {
            return this.documentRegion;
        }
        this.documentRegion = ContentAssistUtils.getStructuredDocumentRegion((StructuredTextViewer)((StructuredTextViewer)this.fileSource), (int)this.offset);
        if (this.documentRegion == null) {
            throw new ACodeDataResolver.CodeUnresolvedException("Unable to resolve document region");
        }
        return this.documentRegion;
    }

    private ITextRegion getPhpToken() {
        if (this.phpToken != null) {
            return this.phpToken;
        }
        ITextRegion iTextRegion = this.getDocumentRegion().getRegionAtCharacterOffset(this.offset);
        if (iTextRegion == null) {
            throw new ACodeDataResolver.CodeUnresolvedException("Unable to resolve php region");
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = this.documentRegion;
        if (iTextRegion instanceof ITextRegionContainer && (iTextRegion = (iStructuredDocumentRegion = (ITextRegionContainer)iTextRegion).getRegionAtCharacterOffset(this.offset)) == null) {
            throw new ACodeDataResolver.CodeUnresolvedException("Unable to resolve contained php region");
        }
        int n = iStructuredDocumentRegion.getStartOffset();
        if (iTextRegion.getType() != "PHP_CONTENT") {
            throw new ACodeDataResolver.CodeUnresolvedException("Incompatible php region context");
        }
        try {
            this.phpToken = ((PhpScriptRegion)iTextRegion).getPhpToken(this.offset - n - iTextRegion.getStart());
        }
        catch (BadLocationException badLocationException) {
            throw new ACodeDataResolver.CodeUnresolvedException("Unable to resolve php token");
        }
        return iTextRegion;
    }

    private String getPhpTokenType() {
        if (this.phpTokenType != null) {
            return this.phpTokenType;
        }
        this.phpTokenType = this.getPhpToken().getType();
        if (this.phpTokenType == null) {
            throw new ACodeDataResolver.CodeUnresolvedException("Unable to resolve region type");
        }
        return this.phpTokenType;
    }
}

