/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class CastExpression
extends Expression {
    public static final int TYPE_INT = 0;
    public static final int TYPE_REAL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_ARRAY = 3;
    public static final int TYPE_OBJECT = 4;
    public static final int TYPE_BOOL = 5;
    public static final int TYPE_UNSET = 6;
    private final Expression expr;
    private final int castType;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.internal.core.ast.nodes.CastExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CastExpression(int n, int n2, Expression expression, int n3) {
        super(n, n2);
        if (!$assertionsDisabled && expression == null) {
            throw new AssertionError();
        }
        this.expr = expression;
        this.castType = n3;
        expression.setParent(this);
    }

    public static String getCastType(int n) {
        switch (n) {
            case 0: {
                return "int";
            }
            case 1: {
                return "real";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "array";
            }
            case 4: {
                return "object";
            }
            case 5: {
                return "bool";
            }
            case 6: {
                return "unset";
            }
        }
        throw new IllegalArgumentException();
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.expr.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.expr.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.expr.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<CastExpression");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" castType='").append(CastExpression.getCastType(this.castType)).append("'>\n");
        this.expr.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n").append(string).append("</CastExpression>");
    }

    public int getType() {
        return 8;
    }

    public int getCastType() {
        return this.castType;
    }

    public Expression getExpr() {
        return this.expr;
    }
}

