/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.dom.AttrImplForPhp;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.format.CaseDefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.CommentIndentationStrategy;
import org.eclipse.php.internal.core.format.CurlyCloseIndentationStrategy;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IIndentationStrategy;
import org.eclipse.php.internal.core.format.PHPCloseTagIndentationStrategy;
import org.eclipse.php.internal.core.format.PhpFormatConstraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.text.rules.SimpleStructuredRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class PhpFormatter
implements IStructuredFormatter {
    private IIndentationStrategy defaultIndentationStrategy = new DefaultIndentationStrategy();
    private IIndentationStrategy curlyCloseIndentationStrategy = new CurlyCloseIndentationStrategy();
    private IIndentationStrategy caseDefaultIndentationStrategy = new CaseDefaultIndentationStrategy();
    private IIndentationStrategy commentIndentationStrategy = new CommentIndentationStrategy();
    private IIndentationStrategy phpCloseTagIndentationStrategy = new PHPCloseTagIndentationStrategy();
    protected PhpFormatConstraints fFormatContraints = null;
    protected IStructuredFormatPreferences fFormatPreferences = null;
    protected IProgressMonitor fProgressMonitor = null;
    private final int length;
    private final int start;
    private static final byte CHAR_TAB = 9;
    private static final byte CHAR_SPACE = 32;
    private StringBuffer resultBuffer = new StringBuffer();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.php.internal.core.format.PhpFormatter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PhpFormatter(int n, int n2) {
        this.start = n;
        this.length = n2;
    }

    public void format(Node node) {
        this.format(node, this.getFormatContraints());
    }

    public void format(Node node, IStructuredFormatContraints iStructuredFormatContraints) {
        if (node instanceof IDOMNode) {
            this.formatNode((IDOMNode)node, iStructuredFormatContraints);
        }
    }

    private void formatNode(IDOMNode iDOMNode, IStructuredFormatContraints iStructuredFormatContraints) {
        IStructuredDocument iStructuredDocument;
        if (iDOMNode instanceof ElementImplForPhp && ((ElementImplForPhp)iDOMNode).isPhpTag()) {
            iStructuredDocument = iDOMNode.getStartStructuredDocumentRegion();
            this.format((IStructuredDocumentRegion)iStructuredDocument);
        }
        if (iDOMNode instanceof AttrImplForPhp) {
            iStructuredDocument = iDOMNode.getStructuredDocument();
            int n = iStructuredDocument.getLineOfOffset(iDOMNode.getStartOffset());
            int n2 = iStructuredDocument.getLineOfOffset(iDOMNode.getEndOffset());
            while (n <= n2) {
                this.formatLine(iStructuredDocument, n);
                ++n;
            }
        }
        if (iDOMNode.hasChildNodes()) {
            iStructuredDocument = (IDOMNode)iDOMNode.getFirstChild();
            while (iStructuredDocument != null) {
                this.formatNode((IDOMNode)iStructuredDocument, iStructuredFormatContraints);
                iStructuredDocument = (IDOMNode)iStructuredDocument.getNextSibling();
            }
        }
    }

    public IStructuredFormatContraints getFormatContraints() {
        if (this.fFormatContraints == null) {
            this.fFormatContraints = new PhpFormatConstraints();
        }
        return this.fFormatContraints;
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        return this.fFormatPreferences;
    }

    public void setFormatPreferences(IStructuredFormatPreferences iStructuredFormatPreferences) {
        this.fFormatPreferences = iStructuredFormatPreferences;
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.fProgressMonitor = iProgressMonitor;
    }

    protected final int getStart() {
        return this.start;
    }

    protected final int getLength() {
        return this.length;
    }

    private void format(IStructuredDocumentRegion iStructuredDocumentRegion) {
        if (!$assertionsDisabled && iStructuredDocumentRegion == null) {
            throw new AssertionError();
        }
        int n = iStructuredDocumentRegion.getStartOffset();
        int n2 = iStructuredDocumentRegion.getEnd();
        int n3 = this.getStart();
        int n4 = n3 + this.getLength();
        int n5 = Math.max(n3, n);
        int n6 = Math.min(n4, n2);
        IStructuredDocument iStructuredDocument = iStructuredDocumentRegion.getParentDocument();
        int n7 = iStructuredDocument.getLineOfOffset(n5);
        int n8 = iStructuredDocument.getLineOfOffset(n6);
        while (n7 <= n8) {
            this.formatLine(iStructuredDocument, n7);
            ++n7;
        }
    }

    private void formatLine(IStructuredDocument iStructuredDocument, int n) {
        this.resultBuffer.setLength(0);
        try {
            Object object;
            int n2;
            IRegion iRegion = iStructuredDocument.getLineInformation(n);
            int n3 = iRegion.getOffset();
            int n4 = iRegion.getLength();
            if (n4 == 0) {
                return;
            }
            String string = iStructuredDocument.get(n3, n4);
            IRegion iRegion2 = this.getFormattedLineInformation(iRegion, string);
            if (!this.shouldReformat(iStructuredDocument, iRegion2)) {
                return;
            }
            int n5 = iRegion2.getOffset();
            int n6 = n5 + iRegion2.getLength();
            if (n6 != (n2 = n3 + n4)) {
                iStructuredDocument.replace(n6, n2 - n6, "");
                if (n5 == n6) {
                    return;
                }
            }
            int n7 = n5 - n3;
            IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n5);
            ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n5);
            int n8 = iStructuredDocumentRegion.getStartOffset(iTextRegion);
            if (iTextRegion instanceof ITextRegionContainer) {
                object = (ITextRegionContainer)iTextRegion;
                iTextRegion = object.getRegionAtCharacterOffset(n5);
                n8 += iTextRegion.getStart();
            }
            if (iTextRegion instanceof PhpScriptRegion && (iTextRegion = ((PhpScriptRegion)((Object)(object = (PhpScriptRegion)iTextRegion))).getPhpToken(n5 - n8)) != null && iTextRegion.getStart() + iStructuredDocumentRegion.getStartOffset() < n3 && iTextRegion.getType() == "WHITESPACE") {
                iTextRegion = ((PhpScriptRegion)((Object)object)).getPhpToken(n5 - n8 + iTextRegion.getLength());
            }
            if (iTextRegion == null) {
                return;
            }
            if (iTextRegion == null) {
                return;
            }
            object = iTextRegion.getType();
            IIndentationStrategy iIndentationStrategy = object == "PHP_CASE" || object == "PHP_DEFAULT" ? this.caseDefaultIndentationStrategy : (this.isPHPCommentRegion((String)object) ? this.commentIndentationStrategy : (object == "PHP_CLOSETAG" ? this.phpCloseTagIndentationStrategy : this.getIndentationStrategy(string.charAt(n7))));
            iIndentationStrategy.placeMatchingBlanks(iStructuredDocument, this.resultBuffer, n, iStructuredDocument.getLineOffset(n));
            String string2 = this.resultBuffer.toString();
            String string3 = string.substring(0, n7);
            if (string2.length() != string3.length()) {
                iStructuredDocument.replaceText((Object)iStructuredDocumentRegion, n3, n7, string2);
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
    }

    private boolean isPHPCommentRegion(String string) {
        return string == "PHP_COMMENT" || string == "PHP_COMMENT_END" || string == "PHPDOC_COMMENT" || string == "PHPDOC_COMMENT_END";
    }

    private IRegion getFormattedLineInformation(IRegion iRegion, String string) {
        int n = 0;
        int n2 = string.length() - 1;
        byte[] byArray = string.getBytes();
        boolean bl = true;
        while (bl) {
            boolean bl2;
            boolean bl3 = byArray[n] == 32 || byArray[n] == 9;
            boolean bl4 = bl2 = byArray[n2] == 32 || byArray[n2] == 9;
            if (bl3) {
                ++n;
            }
            if (bl2) {
                --n2;
            }
            boolean bl5 = bl = (bl3 || bl2) && n < n2;
        }
        if (n > n2) {
            return new SimpleStructuredRegion(iRegion.getOffset(), 0);
        }
        return n == 0 && n2 == string.length() - 1 ? iRegion : new SimpleStructuredRegion(iRegion.getOffset() + n, n2 - n + 1);
    }

    private boolean shouldReformat(IStructuredDocument iStructuredDocument, IRegion iRegion) {
        String string = FormatterUtils.getPartitionType(iStructuredDocument, iRegion.getOffset());
        return string == "org.eclipse.php.PHP_DEFAULT" || string == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || string == "org.eclipse.php.PHP_SINGLE_LINE_COMMENT" || string == "org.eclipse.php.PHP_DOC";
    }

    protected IIndentationStrategy getIndentationStrategy(char c) {
        if (c == '}') {
            return this.curlyCloseIndentationStrategy;
        }
        return this.getDefaultIndentationStrategy();
    }

    private IIndentationStrategy getDefaultIndentationStrategy() {
        return this.defaultIndentationStrategy;
    }
}

