/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.documentModel.validate.PHPProblemsValidator;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;

public class PhpResourceDeltaBuildVisitor
implements IResourceDeltaVisitor {
    private static final IContentTypeManager CONTENT_TYPE_MANAGER = Platform.getContentTypeManager();
    private PHPProblemsValidator validator = PHPProblemsValidator.getInstance();

    public boolean visit(IResourceDelta iResourceDelta) {
        switch (iResourceDelta.getResource().getType()) {
            case 1: {
                this.processFileDelta(iResourceDelta);
                return false;
            }
            case 4: {
                return this.processProjectDelta(iResourceDelta);
            }
        }
        return true;
    }

    private void processFileDelta(IResourceDelta iResourceDelta) {
        IFile iFile = (IFile)iResourceDelta.getResource();
        int n = iResourceDelta.getFullPath().segmentCount();
        String string = iResourceDelta.getFullPath().segment(n - 1);
        IContentType iContentType = CONTENT_TYPE_MANAGER.getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
        if (!iContentType.isAssociatedWith(string)) {
            return;
        }
        switch (iResourceDelta.getKind()) {
            case 1: {
                PHPWorkspaceModelManager.getInstance().addFileToModel(iFile);
            }
            case 4: {
                this.validator.validateFile(iFile);
                break;
            }
            case 2: {
                PHPWorkspaceModelManager.getInstance().removeFileFromModel(iFile);
            }
        }
    }

    private boolean processProjectDelta(IResourceDelta iResourceDelta) {
        IProject iProject = (IProject)iResourceDelta.getResource();
        try {
            return iProject.hasNature("org.eclipse.php.core.PHPNature");
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
            return false;
        }
    }
}

