/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.properties.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencePropagatorFactory;
import org.eclipse.php.internal.core.preferences.PreferencesPropagator;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;

public class PhpVersionChangedHandler
implements IWorkspaceModelListener {
    private HashMap projectListeners = new HashMap();
    private HashMap preferencesPropagatorListeners = new HashMap();
    private static PhpVersionChangedHandler instance = null;
    private PreferencesPropagator preferencesPropagator;
    private static final String NODES_QUALIFIER = "org.eclipse.php.core";
    private static final IPreferenceStore store = PHPCorePlugin.getDefault().getPreferenceStore();

    private PhpVersionChangedHandler() {
        PreferencePropagatorFactory.getInstance();
        this.preferencesPropagator = PreferencePropagatorFactory.getPreferencePropagator(NODES_QUALIFIER, store);
    }

    public static PhpVersionChangedHandler getInstance() {
        if (instance == null) {
            instance = new PhpVersionChangedHandler();
        }
        return instance;
    }

    public synchronized void projectModelAdded(IProject iProject) {
        if (iProject == null || this.projectListeners.get(iProject) != null) {
            return;
        }
        PHPWorkspaceModelManager.getInstance().addWorkspaceModelListener(iProject.getName(), instance);
        this.projectListeners.put(iProject, new ArrayList());
        PreferencesPropagatorListener preferencesPropagatorListener = new PreferencesPropagatorListener(iProject);
        this.preferencesPropagatorListeners.put(iProject, preferencesPropagatorListener);
        this.preferencesPropagator.addPropagatorListener(preferencesPropagatorListener, "phpVersion");
    }

    public synchronized void projectModelRemoved(IProject iProject) {
        this.projectListeners.remove(iProject);
        PreferencesPropagatorListener preferencesPropagatorListener = (PreferencesPropagatorListener)this.preferencesPropagatorListeners.get(iProject);
        this.preferencesPropagator.removePropagatorListener(preferencesPropagatorListener, "phpVersion");
        this.preferencesPropagatorListeners.remove(iProject);
    }

    public void projectModelChanged(IProject iProject) {
    }

    private void projectVersionChanged(IProject iProject, PreferencesPropagatorEvent preferencesPropagatorEvent) {
        ArrayList arrayList = (ArrayList)this.projectListeners.get(iProject);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                IPreferencesPropagatorListener iPreferencesPropagatorListener = (IPreferencesPropagatorListener)iterator.next();
                iPreferencesPropagatorListener.preferencesEventOccured(preferencesPropagatorEvent);
            }
        }
    }

    public void addPhpVersionChangedListener(IPreferencesPropagatorListener iPreferencesPropagatorListener) {
        IProject iProject = iPreferencesPropagatorListener.getProject();
        ArrayList arrayList = (ArrayList)this.projectListeners.get(iProject);
        if (arrayList == null) {
            this.projectModelAdded(iProject);
            arrayList = (ArrayList)this.projectListeners.get(iProject);
        }
        arrayList.add(iPreferencesPropagatorListener);
    }

    public void removePhpVersionChangedListener(IPreferencesPropagatorListener iPreferencesPropagatorListener) {
        IProject iProject = iPreferencesPropagatorListener.getProject();
        ArrayList arrayList = (ArrayList)this.projectListeners.get(iProject);
        if (arrayList != null) {
            arrayList.remove(iPreferencesPropagatorListener);
        }
    }

    private class PreferencesPropagatorListener
    implements IPreferencesPropagatorListener {
        private IProject project;

        public PreferencesPropagatorListener(IProject iProject) {
            this.project = iProject;
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            String string;
            if (preferencesPropagatorEvent.getNewValue() == null) {
                String string2 = PreferencesSupport.getWorkspacePreferencesValue((String)preferencesPropagatorEvent.getKey(), PHPCorePlugin.getDefault().getPreferenceStore());
                if (string2 == null || string2.equals(preferencesPropagatorEvent.getOldValue())) {
                    return;
                }
                preferencesPropagatorEvent = new PreferencesPropagatorEvent(preferencesPropagatorEvent.getSource(), preferencesPropagatorEvent.getOldValue(), string2, preferencesPropagatorEvent.getKey());
            } else if (preferencesPropagatorEvent.getOldValue() == null && (string = PreferencesSupport.getWorkspacePreferencesValue((String)preferencesPropagatorEvent.getKey(), PHPCorePlugin.getDefault().getPreferenceStore())) != null && string.equals(preferencesPropagatorEvent.getNewValue())) {
                return;
            }
            PhpVersionChangedHandler.this.projectVersionChanged(this.project, preferencesPropagatorEvent);
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

