/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPExecutableDebuggerInitializer {
    private HashMap systemEnvironmentVariables = null;
    private ILaunch launch;

    public PHPExecutableDebuggerInitializer(ILaunch iLaunch) throws IOException {
        this.launch = iLaunch;
        this.initializeSystemEnvironmentVariables();
    }

    public PHPExecutableDebuggerInitializer() throws IOException {
        this.initializeSystemEnvironmentVariables();
    }

    public void initializeDebug(String string, String string2, String string3) {
        this.initializeDebug(string, string2, string3, null, null);
    }

    public void initializeDebug(String string, String string2, String string3, Map map, String string4) {
        try {
            Path path = new Path(string);
            File file = new File(path.removeLastSegments(1).toString());
            String string5 = file.getAbsolutePath();
            if (string4 != null && !string4.equals("")) {
                string5 = string4;
            }
            string5 = new File(string5).getParentFile().getAbsolutePath();
            this.systemEnvironmentVariables.put("REQUEST_METHOD", "GET");
            this.systemEnvironmentVariables.put("SCRIPT_FILENAME", string2);
            this.systemEnvironmentVariables.put("SCRIPT_NAME", string2);
            this.systemEnvironmentVariables.put("PATH_TRANSLATED", string2);
            this.systemEnvironmentVariables.put("PATH_INFO", string2);
            this.systemEnvironmentVariables.put("QUERY_STRING", String.valueOf(string3) + "&debug_host=127.0.0.1");
            this.systemEnvironmentVariables.put("REDIRECT_STATUS", "1");
            this.systemEnvironmentVariables.put("PHPRC", string5);
            if (map != null) {
                this.systemEnvironmentVariables.putAll(map);
            }
            String[] stringArray = this.mapAsArray(this.systemEnvironmentVariables);
            String[] stringArray2 = new String[]{string, "-c", string5, string2};
            Process process = Runtime.getRuntime().exec(stringArray2, stringArray, file);
            ProcessOutputReader processOutputReader = new ProcessOutputReader(process);
            new Thread(processOutputReader).start();
        }
        catch (Exception exception) {
            final Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                public void run() {
                    String string = exception.getLocalizedMessage();
                    string = string.replaceFirst(String.valueOf(exception.getClass().getName()) + ": ", "");
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)"Error", (String)NLS.bind((String)"Error running PHP executable:\n\n{0}", (Object)string));
                }
            });
            DebugPlugin.log((Throwable)exception);
        }
    }

    private String[] mapAsArray(Map map) {
        String[] stringArray = new String[map.size()];
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringArray[n++] = entry.getKey() + "=" + entry.getValue();
        }
        return stringArray;
    }

    private void initializeSystemEnvironmentVariables() throws IOException {
        String string;
        Process process;
        ArrayList<String> arrayList = new ArrayList<String>();
        Runtime runtime = Runtime.getRuntime();
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string2.indexOf("windows") > -1) {
            process = string2.indexOf("windows 9") > -1 ? runtime.exec("command.com /c set") : runtime.exec("cmd.exe /c set");
        } else if (string2.indexOf("linux") > -1) {
            process = runtime.exec("env");
        } else if (string2.indexOf("unix") > -1) {
            process = runtime.exec("/bin/env");
        } else if (string2.indexOf("sunos") > -1) {
            process = runtime.exec("/bin/env");
        } else if (string2.indexOf("mac") > -1) {
            try {
                process = runtime.exec("env");
            }
            catch (IOException iOException) {
                process = runtime.exec("setenv");
            }
        } else if (string2.indexOf("freebsd") > -1) {
            process = runtime.exec("set");
        } else {
            System.out.println("OS not known: " + string2);
            this.systemEnvironmentVariables = new HashMap(0);
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        this.systemEnvironmentVariables = new HashMap();
        int n = 0;
        while (n < arrayList.size()) {
            String[] stringArray = ((String)arrayList.get(n)).split("=");
            if (stringArray.length == 2) {
                this.systemEnvironmentVariables.put(stringArray[0], stringArray[1]);
            } else if (stringArray.length == 1) {
                this.systemEnvironmentVariables.put(stringArray[0], "");
            }
            ++n;
        }
    }

    private class ProcessOutputReader
    implements Runnable {
        Process p;

        ProcessOutputReader(Process process) {
            this.p = process;
        }

        public void run() {
            Object object;
            Object object2;
            try {
                object2 = new byte[1000];
                object = this.p.getInputStream();
                int n = ((InputStream)object).read((byte[])object2);
                while (n > 0) {
                    n = ((InputStream)object).read((byte[])object2);
                }
                object = this.p.getErrorStream();
                n = ((InputStream)object).read((byte[])object2);
                while (n != -1) {
                    n = ((InputStream)object).read((byte[])object2);
                }
            }
            catch (IOException iOException) {
                PHPDebugPlugin.log(iOException);
            }
            if (PHPExecutableDebuggerInitializer.this.launch != null && PHPExecutableDebuggerInitializer.this.launch.getDebugTarget() == null) {
                object2 = PHPExecutableDebuggerInitializer.this.launch.getLaunchConfiguration().getName();
                object = MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_2, object2);
                Display.getDefault().asyncExec(new Runnable(this, (String)object){
                    final /* synthetic */ ProcessOutputReader this$1;
                    private final /* synthetic */ String val$message;
                    {
                        this.this$1 = processOutputReader;
                        this.val$message = string;
                    }

                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.Debugger_Error, (String)this.val$message);
                        DebugPlugin.getDefault().getLaunchManager().removeLaunch(PHPExecutableDebuggerInitializer.access$0(ProcessOutputReader.access$0(this.this$1)));
                    }
                });
            }
        }

        static /* synthetic */ PHPExecutableDebuggerInitializer access$0(ProcessOutputReader processOutputReader) {
            return processOutputReader.PHPExecutableDebuggerInitializer.this;
        }
    }
}

