/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.datatypes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class CoercibilityType
extends AbstractEnumerator {
    public static final int IMPLICIT = 0;
    public static final int EXPLICIT = 1;
    public static final int COERCIBILE = 2;
    public static final int NO_COLLATION = 3;
    public static final CoercibilityType IMPLICIT_LITERAL = new CoercibilityType(0, "IMPLICIT", "IMPLICIT");
    public static final CoercibilityType EXPLICIT_LITERAL = new CoercibilityType(1, "EXPLICIT", "EXPLICIT");
    public static final CoercibilityType COERCIBILE_LITERAL = new CoercibilityType(2, "COERCIBILE", "COERCIBILE");
    public static final CoercibilityType NO_COLLATION_LITERAL = new CoercibilityType(3, "NO_COLLATION", "NO_COLLATION");
    private static final CoercibilityType[] VALUES_ARRAY = new CoercibilityType[]{IMPLICIT_LITERAL, EXPLICIT_LITERAL, COERCIBILE_LITERAL, NO_COLLATION_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static CoercibilityType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CoercibilityType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CoercibilityType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CoercibilityType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CoercibilityType get(int value) {
        switch (value) {
            case 0: {
                return IMPLICIT_LITERAL;
            }
            case 1: {
                return EXPLICIT_LITERAL;
            }
            case 2: {
                return COERCIBILE_LITERAL;
            }
            case 3: {
                return NO_COLLATION_LITERAL;
            }
        }
        return null;
    }

    private CoercibilityType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

