/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.OpenAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;

public class OpenEditorActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private boolean fIsEditorOwner;
    private OpenAction fOpen;

    public OpenEditorActionGroup(IViewPart iViewPart) {
        this.fSite = iViewPart.getSite();
        this.fOpen = new OpenAction(this.fSite);
        this.fOpen.setActionDefinitionId("org.eclipse.php.ui.edit.text.open.editor");
        this.initialize(this.fSite.getSelectionProvider());
    }

    public IAction getOpenAction() {
        return this.fOpen;
    }

    private void initialize(ISelectionProvider iSelectionProvider) {
        ISelection iSelection = iSelectionProvider.getSelection();
        this.fOpen.update(iSelection);
        if (!this.fIsEditorOwner) {
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fOpen);
        }
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.setGlobalActionHandlers(iActionBars);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        this.fOpen = new OpenAction(this.fSite);
        this.fOpen.setActionDefinitionId("org.eclipse.php.ui.edit.text.open.editor");
        this.appendToGroup(iMenuManager, (IAction)this.fOpen);
        if (!this.fIsEditorOwner) {
            this.addOpenWithMenu(iMenuManager);
        }
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fOpen);
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars iActionBars) {
        iActionBars.setGlobalActionHandler("org.eclipse.php.ui.actions.Open", (IAction)this.fOpen);
    }

    private void appendToGroup(IMenuManager iMenuManager, IAction iAction) {
        if (iAction.isEnabled()) {
            iMenuManager.appendToGroup("group.open", iAction);
        }
    }

    private void addOpenWithMenu(IMenuManager iMenuManager) {
        ISelection iSelection = this.getContext().getSelection();
        if (iSelection.isEmpty() || !(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (iStructuredSelection.size() != 1) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)object;
        Object object2 = iAdaptable.getAdapter(IResource.class);
        if (!(object2 instanceof IFile)) {
            return;
        }
        MenuManager menuManager = new MenuManager(PHPUIMessages.OpenWithMenu_label);
        menuManager.add((IContributionItem)new OpenWithMenu(this.fSite.getPage(), (IAdaptable)((IFile)object2)));
        iMenuManager.appendToGroup("group.open", (IContributionItem)menuManager);
    }
}

