/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.explorer.ExplorerPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.views.navigator.ResourceNavigatorRenameAction;

public class RenameResourceAction
extends SelectionDispatchAction {
    TreeViewer treeViewer;

    public RenameResourceAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        ViewSite viewSite;
        IWorkbenchPart iWorkbenchPart;
        if (iWorkbenchSite instanceof ViewSite && (iWorkbenchPart = (viewSite = (ViewSite)iWorkbenchSite).getPart()) instanceof ExplorerPart) {
            ExplorerPart explorerPart = (ExplorerPart)iWorkbenchPart;
            this.treeViewer = explorerPart.getViewer();
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(true);
    }

    public void run(IStructuredSelection iStructuredSelection) {
        IResource iResource = RenameResourceAction.getResource(iStructuredSelection);
        if (!ActionUtils.isProcessable(this.getShell(), iResource)) {
            return;
        }
        if (!ActionUtils.isRenameAvailable(iResource)) {
            return;
        }
        this.createWorkbenchAction(iStructuredSelection).run();
    }

    private ResourceNavigatorRenameAction createWorkbenchAction(IStructuredSelection iStructuredSelection) {
        PHPResourceNavigatorRenameAction pHPResourceNavigatorRenameAction = new PHPResourceNavigatorRenameAction(this.getShell(), this.treeViewer);
        pHPResourceNavigatorRenameAction.selectionChanged(iStructuredSelection);
        return pHPResourceNavigatorRenameAction;
    }

    private static IResource getResource(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof PHPCodeData && !(object instanceof PHPFileData)) {
            return null;
        }
        if (!((object = PHPModelUtil.getResource((Object)object)) instanceof IResource)) {
            return null;
        }
        return (IResource)object;
    }

    private class PHPResourceNavigatorRenameAction
    extends ResourceNavigatorRenameAction {
        public PHPResourceNavigatorRenameAction(Shell shell, TreeViewer treeViewer) {
            super(shell, treeViewer);
        }

        protected void runWithNewPath(IPath iPath, IResource iResource) {
            IBreakpoint iBreakpoint;
            Object object;
            ArrayList<IBreakpoint> arrayList = new ArrayList<IBreakpoint>(6);
            ArrayList<Map> arrayList2 = new ArrayList<Map>(6);
            IBreakpointManager iBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            try {
                object = iResource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
                int n = 0;
                while (n < ((IMarker[])object).length) {
                    iBreakpoint = iBreakpointManager.getBreakpoint(object[n]);
                    if (iBreakpoint != null && !arrayList.contains(iBreakpoint)) {
                        arrayList.add(iBreakpoint);
                        arrayList2.add(iBreakpoint.getMarker().getAttributes());
                    }
                    ++n;
                }
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
            }
            super.runWithNewPath(iPath, iResource);
            object = arrayList.iterator();
            Iterator iterator = arrayList2.iterator();
            while (object.hasNext()) {
                iBreakpoint = (IBreakpoint)object.next();
                Map map = (Map)iterator.next();
                try {
                    IMarker iMarker = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath).createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                    String string = (String)map.get("message");
                    if (string != null) {
                        map.put("message", string.replaceFirst(iResource.getName(), iPath.lastSegment()));
                    }
                    iMarker.setAttributes(map);
                    iBreakpoint.setMarker(iMarker);
                    iBreakpointManager.addBreakpoint(iBreakpoint);
                }
                catch (CoreException coreException) {
                    Logger.logException(coreException);
                }
            }
        }
    }
}

