/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.ui.compare.MergeSourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;

public class TextEditorPropertyAction
extends Action
implements IPropertyChangeListener {
    private final MergeSourceViewer[] viewers;
    private final String preferenceKey;
    private IPreferenceStore store;

    public TextEditorPropertyAction(String string, MergeSourceViewer[] mergeSourceViewerArray, String string2) {
        super(string, 2);
        this.viewers = mergeSourceViewerArray;
        this.preferenceKey = string2;
        this.store = EditorsUI.getPreferenceStore();
        if (this.store != null) {
            this.store.addPropertyChangeListener((IPropertyChangeListener)this);
        }
        this.synchronizeWithPreference();
        this.addActionToViewers();
    }

    private void addActionToViewers() {
        int n = 0;
        while (n < this.viewers.length) {
            MergeSourceViewer mergeSourceViewer = this.viewers[n];
            mergeSourceViewer.addTextAction((IAction)this);
            ++n;
        }
    }

    public MergeSourceViewer[] getViewers() {
        return this.viewers;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals(this.getPreferenceKey())) {
            this.synchronizeWithPreference();
        }
    }

    private void synchronizeWithPreference() {
        boolean bl = false;
        if (this.store != null) {
            bl = this.store.getBoolean(this.getPreferenceKey());
        }
        if (bl != this.isChecked()) {
            this.toggleState(bl);
            this.setChecked(bl);
        }
    }

    public String getPreferenceKey() {
        return this.preferenceKey;
    }

    public void run() {
        this.toggleState(this.isChecked());
        if (this.store != null) {
            this.store.setValue(this.getPreferenceKey(), this.isChecked());
        }
    }

    public void dispose() {
        if (this.store != null) {
            this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    protected void toggleState(boolean bl) {
    }
}

