/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dnd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class PHPViewerDropAdapter
implements DropTargetListener {
    protected static final int LOCATION_BEFORE = 1;
    protected static final int LOCATION_AFTER = 2;
    protected static final int LOCATION_ON = 3;
    protected static final int LOCATION_NONE = 4;
    private static final int LOCATION_EPSILON = 5;
    public static final int INSERTION_FEEDBACK = 2;
    private StructuredViewer fViewer;
    private int fFeedback;
    private boolean fShowInsertionFeedback;
    private int fRequestedOperation;
    private int fLastOperation;
    protected int fLocation;
    protected Object fTarget;

    public PHPViewerDropAdapter(StructuredViewer structuredViewer, int n) {
        this.fViewer = structuredViewer;
        Assert.isNotNull((Object)this.fViewer);
        this.fFeedback = n;
        this.fLastOperation = -1;
    }

    public void showInsertionFeedback(boolean bl) {
        this.fShowInsertionFeedback = bl;
    }

    protected StructuredViewer getViewer() {
        return this.fViewer;
    }

    public void drop(DropTargetEvent dropTargetEvent) {
        this.drop(this.fTarget, dropTargetEvent);
    }

    public void drop(Object object, DropTargetEvent dropTargetEvent) {
    }

    public void validateDrop(DropTargetEvent dropTargetEvent) {
        this.validateDrop(this.fTarget, dropTargetEvent, this.fRequestedOperation);
    }

    public void validateDrop(Object object, DropTargetEvent dropTargetEvent, int n) {
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.dragOperationChanged(dropTargetEvent);
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        this.fTarget = null;
        this.fLocation = 4;
    }

    public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
        this.fRequestedOperation = dropTargetEvent.detail;
        this.fTarget = this.computeTarget(dropTargetEvent);
        this.fLocation = this.computeLocation(dropTargetEvent);
        this.validateDrop(dropTargetEvent);
        this.fLastOperation = dropTargetEvent.detail;
        this.computeFeedback(dropTargetEvent);
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        Object object = this.fTarget;
        this.fTarget = this.computeTarget(dropTargetEvent);
        int n = this.fLocation;
        this.fLocation = this.computeLocation(dropTargetEvent);
        if (n != this.fLocation || object != this.fTarget || this.fLastOperation != dropTargetEvent.detail) {
            this.validateDrop(dropTargetEvent);
            this.fLastOperation = dropTargetEvent.detail;
        } else {
            dropTargetEvent.detail = this.fLastOperation;
        }
        this.computeFeedback(dropTargetEvent);
    }

    public void dropAccept(DropTargetEvent dropTargetEvent) {
        this.fTarget = this.computeTarget(dropTargetEvent);
        this.validateDrop(dropTargetEvent);
        this.fLastOperation = dropTargetEvent.detail;
    }

    protected Object computeTarget(DropTargetEvent dropTargetEvent) {
        return dropTargetEvent.item == null ? null : dropTargetEvent.item.getData();
    }

    protected final int computeLocation(DropTargetEvent dropTargetEvent) {
        if (!(dropTargetEvent.item instanceof Item)) {
            return 4;
        }
        Item item = (Item)dropTargetEvent.item;
        Point point = this.fViewer.getControl().toControl(new Point(dropTargetEvent.x, dropTargetEvent.y));
        Rectangle rectangle = this.getBounds(item);
        if (rectangle == null) {
            return 4;
        }
        if (point.y - rectangle.y < 5) {
            return 1;
        }
        if (rectangle.y + rectangle.height - point.y < 5) {
            return 2;
        }
        return 3;
    }

    private Rectangle getBounds(Item item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBounds();
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(0);
        }
        return null;
    }

    protected void computeFeedback(DropTargetEvent dropTargetEvent) {
        if (!this.fShowInsertionFeedback && this.fLocation != 4) {
            dropTargetEvent.feedback = 1;
        } else if (this.fLocation == 1) {
            dropTargetEvent.feedback = 2;
        } else if (this.fLocation == 2) {
            dropTargetEvent.feedback = 4;
        }
        dropTargetEvent.feedback |= this.fFeedback;
    }

    protected void clearDropOperation(DropTargetEvent dropTargetEvent) {
        dropTargetEvent.detail = 0;
    }

    protected int getRequestedOperation() {
        return this.fRequestedOperation;
    }
}

