/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.php.internal.ui.text.SequenceCharacterIterator;

public class PHPBreakIterator
extends BreakIterator {
    private static final Run WHITESPACE = new Whitespace();
    private static final Run DELIMITER = new LineDelimiter();
    private static final Run CAMELCASE = new CamelCaseIdentifier();
    private static final Run OTHER = new Other();
    protected final BreakIterator fIterator = BreakIterator.getWordInstance();
    protected CharSequence fText;
    private int fIndex = this.fIterator.current();

    public int current() {
        return this.fIndex;
    }

    public int first() {
        this.fIndex = this.fIterator.first();
        return this.fIndex;
    }

    public int following(int n) {
        if (n == this.getText().getEndIndex()) {
            return -1;
        }
        int n2 = this.fIterator.following(n);
        if (n2 == -1) {
            return -1;
        }
        Run run = this.consumeRun(n);
        return n + run.length;
    }

    private Run consumeRun(int n) {
        char c = this.fText.charAt(n);
        int n2 = this.fText.length();
        Run run = this.getRun(c);
        while (run.consume(c) && n < n2 - 1) {
            c = this.fText.charAt(++n);
        }
        return run;
    }

    private Run getRun(char c) {
        Run run;
        if (WHITESPACE.isValid(c)) {
            run = WHITESPACE;
        } else if (DELIMITER.isValid(c)) {
            run = DELIMITER;
        } else if (CAMELCASE.isValid(c)) {
            run = CAMELCASE;
        } else if (OTHER.isValid(c)) {
            run = OTHER;
        } else {
            Assert.isTrue((boolean)false);
            return null;
        }
        run.init();
        return run;
    }

    public CharacterIterator getText() {
        return this.fIterator.getText();
    }

    public boolean isBoundary(int n) {
        if (n == this.getText().getBeginIndex()) {
            return true;
        }
        return this.following(n - 1) == n;
    }

    public int last() {
        this.fIndex = this.fIterator.last();
        return this.fIndex;
    }

    public int next() {
        this.fIndex = this.following(this.fIndex);
        return this.fIndex;
    }

    public int next(int n) {
        return this.fIterator.next(n);
    }

    public int preceding(int n) {
        if (n == this.getText().getBeginIndex()) {
            return -1;
        }
        if (this.isBoundary(n - 1)) {
            return n - 1;
        }
        int n2 = n - 1;
        while (!this.isBoundary(n2 = this.fIterator.preceding(n2))) {
        }
        int n3 = -1;
        while (n2 < n) {
            n3 = n2;
            n2 = this.following(n2);
        }
        return n3;
    }

    public int previous() {
        this.fIndex = this.preceding(this.fIndex);
        return this.fIndex;
    }

    public void setText(String string) {
        this.setText(string);
    }

    public void setText(CharSequence charSequence) {
        this.fText = charSequence;
        this.fIterator.setText(new SequenceCharacterIterator(charSequence));
        this.first();
    }

    public void setText(CharacterIterator characterIterator) {
        if (!(characterIterator instanceof CharSequence)) {
            throw new UnsupportedOperationException("CharacterIterator not supported");
        }
        this.fText = (CharSequence)((Object)characterIterator);
        this.fIterator.setText(characterIterator);
        this.first();
    }

    static final class CamelCaseIdentifier
    extends Run {
        private static final int S_INIT = 0;
        private static final int S_LOWER = 1;
        private static final int S_ONE_CAP = 2;
        private static final int S_ALL_CAPS = 3;
        private static final int S_EXIT = 4;
        private static final int S_EXIT_MINUS_ONE = 5;
        private static final int K_INVALID = 0;
        private static final int K_LOWER = 1;
        private static final int K_UPPER = 2;
        private static final int K_OTHER = 3;
        private int fState;
        private static final int[][] MATRIX = new int[][]{{4, 1, 2, 1}, {4, 1, 4, 1}, {4, 1, 3, 1}, {4, 5, 3, 1}};

        CamelCaseIdentifier() {
        }

        protected void init() {
            super.init();
            this.fState = 0;
        }

        protected boolean consume(char c) {
            int n = this.getKind(c);
            this.fState = MATRIX[this.fState][n];
            switch (this.fState) {
                case 1: 
                case 2: 
                case 3: {
                    ++this.length;
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    --this.length;
                    return false;
                }
            }
            Assert.isTrue((boolean)false);
            return false;
        }

        private int getKind(char c) {
            if (Character.isUpperCase(c)) {
                return 2;
            }
            if (Character.isLowerCase(c)) {
                return 1;
            }
            if (Character.isJavaIdentifierPart(c)) {
                return 3;
            }
            return 0;
        }

        protected boolean isValid(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    static final class Identifier
    extends Run {
        Identifier() {
        }

        protected boolean isValid(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    static final class LineDelimiter
    extends Run {
        private char fState;
        private static final char INIT = '\u0000';
        private static final char EXIT = '\u0001';

        LineDelimiter() {
        }

        protected void init() {
            super.init();
            this.fState = '\u0000';
        }

        protected boolean consume(char c) {
            if (!this.isValid(c) || this.fState == '\u0001') {
                return false;
            }
            if (this.fState == '\u0000') {
                this.fState = c;
                ++this.length;
                return true;
            }
            if (this.fState != c) {
                this.fState = '\u0001';
                ++this.length;
                return true;
            }
            return false;
        }

        protected boolean isValid(char c) {
            return c == '\n' || c == '\r';
        }
    }

    static final class Other
    extends Run {
        Other() {
        }

        protected boolean isValid(char c) {
            return !Character.isWhitespace(c) && !Character.isJavaIdentifierPart(c);
        }
    }

    protected static abstract class Run {
        protected int length;

        public Run() {
            this.init();
        }

        protected boolean consume(char c) {
            if (this.isValid(c)) {
                ++this.length;
                return true;
            }
            return false;
        }

        protected abstract boolean isValid(char var1);

        protected void init() {
            this.length = 0;
        }
    }

    static final class Whitespace
    extends Run {
        Whitespace() {
        }

        protected boolean isValid(char c) {
            return Character.isWhitespace(c) && c != '\n' && c != '\r';
        }
    }
}

