/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.misc.DisjointSet;

public class CloseUnrelatedProjectsAction
extends CloseResourceAction {
    public static final String ID = "org.eclipse.ui.CloseUnrelatedProjectsAction";
    private final List projectsToClose = new ArrayList();
    private boolean selectionDirty = true;
    private List oldSelection = Collections.EMPTY_LIST;

    private static DisjointSet buildConnectedComponents(IProject[] projects) {
        DisjointSet set = new DisjointSet();
        int i = 0;
        while (i < projects.length) {
            set.makeSet(projects[i]);
            ++i;
        }
        i = 0;
        while (i < projects.length) {
            try {
                IProject[] references = projects[i].getReferencedProjects();
                int j = 0;
                while (j < references.length) {
                    Object setOne = set.findSet(projects[i]);
                    Object setTwo = set.findSet(references[j]);
                    if (setOne != null && setTwo != null && setOne != setTwo) {
                        set.union(setOne, setTwo);
                    }
                    ++j;
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return set;
    }

    public CloseUnrelatedProjectsAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.CloseUnrelatedProjectsAction_text);
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseUnrelatedProjectsAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_unrelated_projects_action_context");
    }

    protected void clearCache() {
        super.clearCache();
        this.oldSelection = Collections.EMPTY_LIST;
        this.selectionDirty = true;
    }

    private void computeRelated(List selection) {
        DisjointSet set = CloseUnrelatedProjectsAction.buildConnectedComponents(ResourcesPlugin.getWorkspace().getRoot().getProjects());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            set.removeSet(it.next());
        }
        this.projectsToClose.clear();
        set.toList(this.projectsToClose);
    }

    protected List getSelectedResources() {
        if (this.selectionDirty) {
            List newSelection = super.getSelectedResources();
            if (!this.oldSelection.equals(newSelection)) {
                this.oldSelection = newSelection;
                this.computeRelated(newSelection);
            }
            this.selectionDirty = false;
        }
        return this.projectsToClose;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta;
        if (this.selectionIsOfType(4) && (delta = event.getDelta()) != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x84000) != 0) {
                    this.selectionChanged(this.getStructuredSelection());
                    return;
                }
                ++i;
            }
        }
    }
}

