/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.launching.ApplicationFileViewerFilter;
import org.eclipse.php.internal.debug.ui.model.ExtendedWorkbenchContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ApplicationFileSelectionDialog
extends ElementTreeSelectionDialog {
    private static final String SHOW_EXTERNAL_FILES = "ApplicationFileSelectionDialog_showExternalFiles";
    protected String[] fExtensions;
    protected String[] fRequiredNatures;
    private Button fExternalFilesBt;
    private boolean fAllowExternalFiles;
    private Preferences fStore;

    public ApplicationFileSelectionDialog(Shell shell, ILabelProvider iLabelProvider, String string, String string2, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2) {
        super(shell, iLabelProvider, (ITreeContentProvider)new ExtendedWorkbenchContentProvider(bl2));
        PHPDebugUIPlugin pHPDebugUIPlugin;
        this.fAllowExternalFiles = bl2;
        this.setShellStyle(67696);
        this.setTitle(string);
        if (string == null) {
            this.setTitle("Title");
        }
        if (string2 == null) {
            string2 = "Message";
        }
        this.setMessage(string2);
        this.setAllowMultiple(bl);
        if (stringArray != null) {
            this.addFilter(new ApplicationFileViewerFilter(stringArray2, stringArray));
        }
        if ((pHPDebugUIPlugin = PHPDebugUIPlugin.getDefault()) != null) {
            this.fStore = pHPDebugUIPlugin.getPluginPreferences();
        }
    }

    public String[] getExtensions() {
        return this.fExtensions;
    }

    public void setExtensions(String[] stringArray) {
        this.fExtensions = stringArray;
    }

    protected Control createDialogArea(Composite composite) {
        if (!this.fAllowExternalFiles) {
            return super.createDialogArea(composite);
        }
        Font font = composite.getFont();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setFont(font);
        super.createDialogArea(composite2);
        this.fExternalFilesBt = new Button(composite2, 32);
        this.fExternalFilesBt.setText("Show non-workspace files");
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        this.fExternalFilesBt.setLayoutData((Object)gridData);
        this.fExternalFilesBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ApplicationFileSelectionDialog.this.updateView(ApplicationFileSelectionDialog.this.fExternalFilesBt.getSelection());
            }
        });
        String string = this.fStore.getString(SHOW_EXTERNAL_FILES);
        if (string.length() == 0) {
            this.fExternalFilesBt.setSelection(true);
            this.updateView(true);
        } else {
            boolean bl = Boolean.valueOf(string);
            this.fExternalFilesBt.setSelection(bl);
            this.updateView(bl);
        }
        return composite2;
    }

    protected void okPressed() {
        if (this.fExternalFilesBt != null) {
            this.fStore.setValue(SHOW_EXTERNAL_FILES, Boolean.toString(this.fExternalFilesBt.getSelection()));
        }
        super.okPressed();
    }

    private void updateView(boolean bl) {
        ((ExtendedWorkbenchContentProvider)this.getTreeViewer().getContentProvider()).setProvideExternalFiles(bl);
        this.getTreeViewer().refresh();
    }
}

