/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class DeclareStatement
extends Statement {
    private final Identifier[] directiveNames;
    private final Expression[] directiveValues;
    private final Statement action;

    private DeclareStatement(int n, int n2, Identifier[] identifierArray, Expression[] expressionArray, Statement statement) {
        super(n, n2);
        assert (identifierArray != null && expressionArray != null && identifierArray.length == expressionArray.length);
        this.directiveNames = identifierArray;
        this.directiveValues = expressionArray;
        this.action = statement;
        int n3 = 0;
        while (n3 < identifierArray.length) {
            identifierArray[n3].setParent(this);
            expressionArray[n3].setParent(this);
            ++n3;
        }
        statement.setParent(this);
    }

    public DeclareStatement(int n, int n2, List list, List list2, Statement statement) {
        this(n, n2, list == null ? null : list.toArray(new Identifier[list.size()]), list2 == null ? null : list2.toArray(new Expression[list2.size()]), statement);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        int n = 0;
        while (n < this.directiveNames.length) {
            this.directiveNames[n].accept(visitor);
            this.directiveValues[n].accept(visitor);
            ++n;
        }
        this.action.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        int n = 0;
        while (n < this.directiveNames.length) {
            this.directiveNames[n].traverseTopDown(visitor);
            this.directiveValues[n].traverseTopDown(visitor);
            ++n;
        }
        this.action.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        int n = 0;
        while (n < this.directiveNames.length) {
            this.directiveNames[n].traverseBottomUp(visitor);
            this.directiveValues[n].traverseBottomUp(visitor);
            ++n;
        }
        this.action.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<DeclareStatement");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">\n");
        stringBuffer.append(string).append("\t").append("<Directives>\n");
        int n = 0;
        while (n < this.directiveNames.length) {
            stringBuffer.append(string).append("\t").append("\t").append("<Name>\n");
            this.directiveNames[n].toString(stringBuffer, "\t\t\t" + string);
            stringBuffer.append("\n");
            stringBuffer.append(string).append("\t").append("\t").append("</Name>\n");
            stringBuffer.append(string).append("\t").append("\t").append("<Value>\n");
            this.directiveValues[n].toString(stringBuffer, "\t\t\t" + string);
            stringBuffer.append("\n");
            stringBuffer.append(string).append("\t").append("\t").append("</Value>\n");
            ++n;
        }
        stringBuffer.append(string).append("\t").append("</Directives>\n");
        this.action.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append(string).append("</DeclareStatement>");
    }

    public int getType() {
        return 19;
    }

    public Statement getAction() {
        return this.action;
    }

    public Identifier[] getDirectiveNames() {
        return this.directiveNames;
    }

    public Expression[] getDirectiveValues() {
        return this.directiveValues;
    }
}

