/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FunctionInvocation
extends VariableBase {
    private final FunctionName functionName;
    private final Expression[] parameters;

    private FunctionInvocation(int n, int n2, FunctionName functionName, Expression[] expressionArray) {
        super(n, n2);
        assert (functionName != null && expressionArray != null);
        this.functionName = functionName;
        this.parameters = expressionArray;
        functionName.setParent(this);
        int n3 = 0;
        while (n3 < expressionArray.length) {
            expressionArray[n3].setParent(this);
            ++n3;
        }
    }

    public FunctionInvocation(int n, int n2, FunctionName functionName, List list) {
        this(n, n2, functionName, list == null ? null : list.toArray(new Expression[list.size()]));
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.functionName.accept(visitor);
        int n = 0;
        while (n < this.parameters.length) {
            this.parameters[n].accept(visitor);
            ++n;
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.functionName.traverseTopDown(visitor);
        int n = 0;
        while (n < this.parameters.length) {
            this.parameters[n].traverseTopDown(visitor);
            ++n;
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        this.functionName.traverseBottomUp(visitor);
        int n = 0;
        while (n < this.parameters.length) {
            this.parameters[n].traverseBottomUp(visitor);
            ++n;
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<FunctionInvocation");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">\n");
        this.functionName.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n");
        stringBuffer.append("\t").append(string).append("<Parameters>\n");
        int n = 0;
        while (this.parameters != null && n < this.parameters.length) {
            this.parameters[n].toString(stringBuffer, "\t\t" + string);
            stringBuffer.append("\n");
            ++n;
        }
        stringBuffer.append("\t").append(string).append("</Parameters>\n");
        stringBuffer.append(string).append("</FunctionInvocation>");
    }

    public int getType() {
        return 30;
    }

    public FunctionName getFunctionName() {
        return this.functionName;
    }

    public Expression[] getParameters() {
        return this.parameters;
    }
}

