/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelGridInsertRowCommand
extends DesignerCommand {
    private int _rowIndex;
    private Element _panelGridEle;

    public PanelGridInsertRowCommand(IHTMLGraphicalViewer viewer, Element panelGrid, int rowIndex) {
        super(CommandResources.getString("PanelGridInsertRowCommand.Label.InsertRow"), viewer);
        this._panelGridEle = panelGrid;
        this._rowIndex = rowIndex;
    }

    public boolean canExecute() {
        List children;
        int numRows;
        int columns;
        boolean hasHeaderRow;
        if (this._rowIndex < 0) {
            return false;
        }
        boolean bl = hasHeaderRow = JSFDOMUtil.findFacet(this._panelGridEle, "header") != null;
        if (hasHeaderRow && this._rowIndex == 0) {
            return false;
        }
        int offIndex = this._rowIndex;
        if (hasHeaderRow) {
            --offIndex;
        }
        if ((columns = DOMUtil.getIntAttributeIgnoreCase((Element)this._panelGridEle, (String)"columns", (int)1)) < 1) {
            columns = 1;
        }
        if (offIndex > (numRows = ((children = JSFDOMUtil.getUIComponentChildren(this._panelGridEle)).size() + columns - 1) / columns)) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        boolean hasHeaderRow = JSFDOMUtil.findFacet(this._panelGridEle, "header") != null;
        int columns = DOMUtil.getIntAttributeIgnoreCase((Element)this._panelGridEle, (String)"columns", (int)1);
        if (columns < 1) {
            columns = 1;
        }
        List children = JSFDOMUtil.getUIComponentChildren(this._panelGridEle);
        int numRows = (children.size() + columns - 1) / columns;
        int insertRow = this._rowIndex;
        if (hasHeaderRow) {
            if (insertRow == 0) {
                return;
            }
            --insertRow;
        }
        int insertPoint = insertRow * columns;
        Node node = null;
        if (insertPoint < children.size()) {
            node = (Node)children.get(insertPoint);
        }
        int adds = 0;
        adds = insertRow >= numRows ? columns * (numRows + 1) - children.size() : columns;
        int i = 0;
        while (i < adds) {
            Node child = this.createDefaultNode();
            this._panelGridEle.insertBefore(child, node);
            ++i;
        }
        this.formatNode(this._panelGridEle);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._panelGridEle);
    }

    private Node createDefaultNode() {
        String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)this.getModel(), (String)"http://java.sun.com/jsf/html", (String)"h");
        Element child = this._panelGridEle.getOwnerDocument().createElement("outputText");
        child.setPrefix(prefix);
        return child;
    }
}

