/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.wizards.ConfigurationWizardElement;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ConfigureProjectWizardMainPage
extends WizardPage {
    private Table table;
    private Button showAllToggle;
    private TableViewer viewer;
    private AdaptableList wizards;
    private AdaptableList disabledWizards;
    private IWorkbench workbench;
    private IProject project;
    private String description;
    private IConfigurationWizard selectedWizard;

    public ConfigureProjectWizardMainPage(String pageName, String title, ImageDescriptor titleImage, AdaptableList wizards, AdaptableList disabledWizards) {
        this(pageName, title, titleImage, wizards, disabledWizards, TeamUIMessages.ConfigureProjectWizardMainPage_selectRepository);
    }

    public ConfigureProjectWizardMainPage(String pageName, String title, ImageDescriptor titleImage, AdaptableList wizards, AdaptableList disabledWizards, String description) {
        super(pageName, title, titleImage);
        this.wizards = wizards;
        this.disabledWizards = disabledWizards;
        this.description = description;
    }

    public IConfigurationWizard getSelectedWizard() {
        return this.selectedWizard;
    }

    public boolean canFlipToNextPage() {
        return this.selectedWizard != null && this.selectedWizard.getPageCount() > 0;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.ui.share_project_page_context");
        Label label = new Label(composite, 16384);
        label.setText(this.description);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.table = new Table(composite, 2052);
        data = new GridData(1808);
        data.heightHint = this.table.getItemHeight() * 7;
        this.table.setLayoutData((Object)data);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || !(selection instanceof IStructuredSelection)) {
                    ConfigureProjectWizardMainPage.this.selectedWizard = null;
                    ConfigureProjectWizardMainPage.this.setPageComplete(false);
                    return;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.size() != 1) {
                    ConfigureProjectWizardMainPage.this.selectedWizard = null;
                    ConfigureProjectWizardMainPage.this.setPageComplete(false);
                    return;
                }
                ConfigurationWizardElement selectedElement = (ConfigurationWizardElement)((Object)ss.getFirstElement());
                try {
                    ConfigureProjectWizardMainPage.this.selectedWizard = (IConfigurationWizard)selectedElement.createExecutableExtension();
                    ConfigureProjectWizardMainPage.this.selectedWizard.init(ConfigureProjectWizardMainPage.this.workbench, ConfigureProjectWizardMainPage.this.project);
                }
                catch (CoreException coreException) {
                    return;
                }
                ConfigureProjectWizardMainPage.this.selectedWizard.addPages();
                ConfigureProjectWizardMainPage.this.setPageComplete(true);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConfigureProjectWizardMainPage.this.getWizard().getContainer().showPage(ConfigureProjectWizardMainPage.this.getNextPage());
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ConfigurationWizardElement && e2 instanceof ConfigurationWizardElement) {
                    ConfigurationWizardElement wizard1 = (ConfigurationWizardElement)((Object)e1);
                    ConfigurationWizardElement wizard2 = (ConfigurationWizardElement)((Object)e2);
                    return wizard1.getLabel((Object)wizard1).compareToIgnoreCase(wizard2.getLabel((Object)wizard2));
                }
                return super.compare(viewer, e1, e2);
            }
        });
        if (this.disabledWizards.size() > 0) {
            this.showAllToggle = new Button(composite, 32);
            this.showAllToggle.setText(TeamUIMessages.ConfigureProjectWizard_showAll);
            this.showAllToggle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<Object> all = new ArrayList<Object>(Arrays.asList(ConfigureProjectWizardMainPage.this.wizards.getChildren()));
                    if (ConfigureProjectWizardMainPage.this.showAllToggle.getSelection()) {
                        all.addAll(Arrays.asList(ConfigureProjectWizardMainPage.this.disabledWizards.getChildren()));
                    }
                    ConfigureProjectWizardMainPage.this.viewer.setInput((Object)new AdaptableList(all));
                }
            });
        }
        if (this.wizards.size() == 0 && this.showAllToggle != null) {
            this.showAllToggle.setSelection(true);
            ArrayList<Object> all = new ArrayList<Object>(Arrays.asList(this.wizards.getChildren()));
            all.addAll(Arrays.asList(this.disabledWizards.getChildren()));
            this.viewer.setInput((Object)new AdaptableList(all));
        } else {
            this.viewer.setInput((Object)this.wizards);
        }
        Dialog.applyDialogFont((Control)parent);
    }

    public IWizardPage getNextPage() {
        if (this.selectedWizard == null) {
            return null;
        }
        if (!WorkbenchActivityHelper.allowUseOf((ITriggerPoint)this.getTriggerPoint(), (Object)((IStructuredSelection)this.viewer.getSelection()).getFirstElement())) {
            return null;
        }
        return this.selectedWizard.getStartingPage();
    }

    private ITriggerPoint getTriggerPoint() {
        return PlatformUI.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.team.ui.activityTriggerPoint");
    }

    public void setWorkbench(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.table.setFocus();
        }
    }
}

