/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.server.core.Logger;
import org.eclipse.php.internal.server.core.PHPServerCoreMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.deploy.ProgressUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileUtil {
    private static final Map EMPTY_MAP = new HashMap(0);
    private static final int BUFFER = 10240;
    private static byte[] buf = new byte[10240];

    private FileUtil() {
    }

    public static boolean publish(Server server, IProject iProject, ILaunchConfiguration iLaunchConfiguration, IProgressMonitor iProgressMonitor) throws CoreException {
        return FileUtil.publish(server, iProject, iLaunchConfiguration, EMPTY_MAP, iProgressMonitor);
    }

    public static boolean publish(Server server, IProject iProject, ILaunchConfiguration iLaunchConfiguration, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        IPath iPath;
        String string = iLaunchConfiguration.getAttribute("publish_to", null);
        Path path = new Path(server.getDocumentRoot());
        if (string != null && !string.equals("")) {
            path = path.append(string);
        }
        if ((iPath = iProject.getLocation()) == null) {
            return false;
        }
        String string2 = iPath.toOSString();
        String string3 = path.toOSString();
        return FileUtil.smartCopyDirectory(string2, string3, map, iProgressMonitor);
    }

    public static void copyDirectory(String string, String string2, IProgressMonitor iProgressMonitor) {
        try {
            File file = new File(string);
            File file2 = new File(string2);
            File[] fileArray = file.listFiles();
            file2.mkdirs();
            int n = fileArray.length;
            iProgressMonitor = ProgressUtil.getMonitorFor(iProgressMonitor);
            iProgressMonitor.beginTask(NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.copying"), (Object[])new String[]{string, string2}), n * 50);
            int n2 = 0;
            while (n2 < n) {
                File file3 = fileArray[n2];
                String string3 = file3.getAbsolutePath();
                String string4 = string2;
                if (!string4.endsWith(File.separator)) {
                    string4 = String.valueOf(string4) + File.separator;
                }
                string4 = String.valueOf(string4) + file3.getName();
                if (file3.isFile()) {
                    FileUtil.copyFile(string3, string4);
                    iProgressMonitor.worked(50);
                } else if (file3.isDirectory()) {
                    iProgressMonitor.subTask(NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.copying"), (Object[])new String[]{string3, string4}));
                    FileUtil.copyDirectory(string3, string4, ProgressUtil.getSubMonitorFor(iProgressMonitor, 50));
                }
                if (iProgressMonitor.isCanceled()) {
                    return;
                }
                ++n2;
            }
            iProgressMonitor.done();
        }
        catch (Exception exception) {
            Logger.logException(PHPServerCoreMessages.getString("FileUtil.errorCopyingDirectory"), exception);
        }
    }

    /*
     * Loose catch block
     */
    public static IStatus copyFile(InputStream inputStream, String string) {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(string);
        int n = inputStream.read(buf);
        while (n > 0) {
            ((OutputStream)fileOutputStream).write(buf, 0, n);
            n = inputStream.read(buf);
        }
        Status status = new Status(0, "org.eclipse.php.server.core", 0, NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.copying"), (Object[])new String[]{string}), null);
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        try {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (Exception exception) {}
        return status;
        catch (Exception exception) {
            Status status2;
            try {
                Logger.log(2, PHPServerCoreMessages.getString("FileUtil.errorCopyingFile"), exception);
                status2 = new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.errorCopyingFileTo"), (Object[])new String[]{string, exception.getLocalizedMessage()}), (Throwable)exception);
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception2) {}
                try {
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (Exception exception3) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception4) {}
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (Exception exception5) {}
            return status2;
        }
    }

    public static IStatus copyFile(String string, String string2) {
        try {
            return FileUtil.copyFile(new FileInputStream(string), string2);
        }
        catch (Exception exception) {
            Logger.logException(PHPServerCoreMessages.getString("FileUtil.errorCopyingFile"), exception);
            return new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.errorCopyingFileTo"), (Object[])new String[]{string2, exception.getLocalizedMessage()}), (Throwable)exception);
        }
    }

    public static IStatus copyFile(URL uRL, String string) {
        try {
            return FileUtil.copyFile(uRL.openStream(), string);
        }
        catch (Exception exception) {
            Logger.logException(PHPServerCoreMessages.getString("FileUtil.errorCopyingFile"), exception);
            return new Status(4, "org.eclipse.php.server.core", 0, NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.errorCopyingFileTo"), (Object[])new String[]{string, exception.getLocalizedMessage()}), (Throwable)exception);
        }
    }

    public static void deleteDirectory(File file, IProgressMonitor iProgressMonitor) {
        try {
            if (!file.exists() || !file.isDirectory()) {
                return;
            }
            try {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                iProgressMonitor = ProgressUtil.getMonitorFor(iProgressMonitor);
                iProgressMonitor.beginTask(NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.deleting"), (Object[])new String[]{file.getAbsolutePath()}), n * 10);
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray[n2];
                    if (file2.isFile()) {
                        file2.delete();
                        iProgressMonitor.worked(10);
                    } else if (file2.isDirectory()) {
                        iProgressMonitor.subTask(NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.deleting"), (Object[])new String[]{file2.getAbsolutePath()}));
                        FileUtil.deleteDirectory(file2, ProgressUtil.getSubMonitorFor(iProgressMonitor, 10));
                    }
                    ++n2;
                }
                file.delete();
            }
            catch (Exception exception) {
                Logger.logException(String.valueOf(PHPServerCoreMessages.getString("FileUtil.errorDeletingDirectory")) + file.getAbsolutePath(), exception);
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    public static boolean smartCopyDirectory(String string, String string2, IProgressMonitor iProgressMonitor) {
        return FileUtil.smartCopyDirectory(string, string2, EMPTY_MAP, iProgressMonitor);
    }

    public static boolean smartCopyDirectory(String string, String string2, Map map, IProgressMonitor iProgressMonitor) {
        long l = 0L;
        try {
            File file = File.createTempFile("probe", null, new File(string2));
            l = System.currentTimeMillis() - file.lastModified();
            file.delete();
        }
        catch (IOException iOException) {}
        return FileUtil.smartCopyDirectory(string, string2, map, l, iProgressMonitor);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean smartCopyDirectory(String string, String string2, Map map, long l, IProgressMonitor iProgressMonitor) {
        try {
            int n;
            int n2;
            int n3;
            File file = new File(string);
            File file2 = new File(string2);
            File[] fileArray = file.listFiles();
            int n4 = fileArray.length;
            iProgressMonitor = ProgressUtil.getMonitorFor(iProgressMonitor);
            iProgressMonitor.beginTask(NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.copying"), (Object[])new String[]{string, string2}), 550);
            File[] fileArray2 = null;
            if (file2.exists() && file2.isDirectory()) {
                fileArray2 = file2.listFiles();
                if (fileArray2 == null) {
                    iProgressMonitor.done();
                    FileUtil.displayPublishError();
                    return false;
                }
                n3 = fileArray2.length;
                n2 = 0;
                while (n2 < n3) {
                    String string3 = fileArray2[n2].getName();
                    n = fileArray2[n2].isDirectory();
                    int n5 = 0;
                    while (n5 < n4) {
                        if (!string3.equals(fileArray[n5].getName()) || n == fileArray[n5].isDirectory()) {
                            // empty if block
                        }
                        ++n5;
                    }
                    if (iProgressMonitor.isCanceled()) {
                        return false;
                    }
                    ++n2;
                }
            } else {
                if (file2.isFile()) {
                    file2.delete();
                }
                if (!file2.mkdirs()) {
                    iProgressMonitor.done();
                    FileUtil.displayPublishError();
                    return false;
                }
            }
            iProgressMonitor.worked(50);
            fileArray2 = file2.listFiles();
            n3 = 0;
            if (fileArray2 != null) {
                n3 = fileArray2.length;
            }
            n2 = 0;
            if (n3 > 0) {
                n2 = 500 / n3;
            }
            boolean bl = true;
            n = 0;
            while (n < n4) {
                String string4;
                File file3 = fileArray[n];
                boolean bl2 = true;
                if (!file3.isDirectory()) {
                    string4 = file3.getName();
                    long l2 = file3.lastModified() - l;
                    int n6 = 0;
                    while (n6 < n3) {
                        if (string4.equals(fileArray2[n6].getName()) && l2 <= fileArray2[n6].lastModified()) {
                            bl2 = false;
                        }
                        ++n6;
                    }
                }
                if (bl2) {
                    string4 = file3.getAbsolutePath();
                    String string5 = string2;
                    if (!string5.endsWith(File.separator)) {
                        string5 = String.valueOf(string5) + File.separator;
                    }
                    string5 = String.valueOf(string5) + file3.getName();
                    if (!map.containsKey(file3.getName())) {
                        if (file3.isFile()) {
                            bl &= FileUtil.copyFile(string4, string5).getSeverity() == 0;
                            iProgressMonitor.worked(n2);
                        } else if (file3.isDirectory()) {
                            iProgressMonitor.subTask(NLS.bind((String)PHPServerCoreMessages.getString("FileUtil.copying"), (Object[])new String[]{string4, string5}));
                            if (!FileUtil.smartCopyDirectory(string4, string5, map, l, ProgressUtil.getSubMonitorFor(iProgressMonitor, n2))) {
                                iProgressMonitor.done();
                                return false;
                            }
                        }
                    } else {
                        iProgressMonitor.worked(n2);
                    }
                }
                if (iProgressMonitor.isCanceled()) {
                    return false;
                }
                ++n;
            }
            iProgressMonitor.worked(500 - n2 * n3);
            iProgressMonitor.done();
            return bl;
        }
        catch (Exception exception) {
            Logger.logException("Error smart copying directory " + string + " - " + string2, exception);
            return false;
        }
    }

    private static void displayPublishError() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)PHPServerCoreMessages.getString("FileUtil.publishError"), (String)PHPServerCoreMessages.getString("FileUtil.serverPublishError"), (IStatus)new Status(4, "org.eclipse.php.server.core", 0, PHPServerCoreMessages.getString("FileUtil.writePermissionError"), null));
            }
        });
    }
}

