/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.swt;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.provisional.swt.SWTUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class TableUpdater {
    private PrivateInterface privateInterface = new PrivateInterface();
    private Table theTable;

    public TableUpdater(Table toUpdate) {
        Assert.isLegal(((toUpdate.getStyle() & 0x10000000) != 0 ? 1 : 0) != 0, (String)"TableUpdater requires virtual table");
        this.theTable = toUpdate;
        this.theTable.addDisposeListener((DisposeListener)this.privateInterface);
        this.theTable.addListener(36, (Listener)this.privateInterface);
    }

    public void dispose() {
        this.theTable.removeDisposeListener((DisposeListener)this.privateInterface);
        this.theTable.removeListener(36, (Listener)this.privateInterface);
    }

    protected abstract void updateItem(TableItem var1);

    private class PrivateInterface
    implements Listener,
    DisposeListener {
        private PrivateInterface() {
        }

        public void handleEvent(Event e) {
            if (e.type == 36) {
                UpdateRunnable runnable = (UpdateRunnable)e.item.getData();
                if (runnable == null) {
                    runnable = new UpdateRunnable((TableItem)e.item);
                    e.item.setData((Object)runnable);
                    runnable.makeDirty();
                } else {
                    runnable.updateIfNecessary();
                }
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            TableUpdater.this.dispose();
        }
    }

    private class UpdateRunnable
    implements Runnable,
    IChangeListener,
    DisposeListener {
        private TableItem item;
        private boolean dirty = false;
        private IObservable[] dependencies = new IObservable[0];

        UpdateRunnable(TableItem item) {
            this.item = item;
            item.addDisposeListener((DisposeListener)this);
        }

        public void run() {
            if (TableUpdater.this.theTable != null && !TableUpdater.this.theTable.isDisposed() && this.item != null && !this.item.isDisposed()) {
                if (TableUpdater.this.theTable.isVisible()) {
                    int topIndex;
                    int tableHeight = ((TableUpdater)TableUpdater.this).theTable.getClientArea().height;
                    int numVisibleItems = tableHeight / TableUpdater.this.theTable.getItemHeight();
                    int indexOfItem = TableUpdater.this.theTable.indexOf(this.item);
                    if (indexOfItem >= (topIndex = TableUpdater.this.theTable.getTopIndex()) && indexOfItem <= topIndex + numVisibleItems) {
                        this.updateIfNecessary();
                        return;
                    }
                }
                TableUpdater.this.theTable.clear(TableUpdater.this.theTable.indexOf(this.item));
            }
        }

        private void updateIfNecessary() {
            if (this.dirty) {
                this.dependencies = ObservableTracker.runAndMonitor((Runnable)new Runnable(this){
                    final /* synthetic */ UpdateRunnable this$1;
                    {
                        this.this$1 = updateRunnable;
                    }

                    public void run() {
                        UpdateRunnable.access$2(this.this$1).updateItem(UpdateRunnable.access$0(this.this$1));
                    }
                }, (IChangeListener)this, null);
                this.dirty = false;
            }
        }

        public void handleChange(ChangeEvent event) {
            this.makeDirty();
        }

        protected final void makeDirty() {
            if (!this.dirty) {
                this.dirty = true;
                this.stopListening();
                SWTUtil.runOnce(TableUpdater.this.theTable.getDisplay(), this);
            }
        }

        private void stopListening() {
            int i = 0;
            while (i < this.dependencies.length) {
                IObservable observable = this.dependencies[i];
                observable.removeChangeListener((IChangeListener)this);
                ++i;
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            this.stopListening();
            this.dependencies = null;
            this.item = null;
        }

        static /* synthetic */ TableItem access$0(UpdateRunnable updateRunnable) {
            return updateRunnable.item;
        }

        static /* synthetic */ TableUpdater access$2(UpdateRunnable updateRunnable) {
            return updateRunnable.TableUpdater.this;
        }
    }
}

